/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.ui.table;

import org.pivot4j.PivotModel;
import org.pivot4j.el.ExpressionContext;
import org.pivot4j.ui.CartesianRenderContext;
import org.pivot4j.ui.table.TableRenderer;

public class TableRenderContext
extends CartesianRenderContext {
    private int columnCount;
    private int rowCount;
    private int columnHeaderCount;
    private int rowHeaderCount;
    private int colIndex;
    private int rowIndex;
    private int colSpan = 1;
    private int rowSpan = 1;

    public TableRenderContext(PivotModel model, TableRenderer renderer, int columnCount, int rowCount, int columnHeaderCount, int rowHeaderCount) {
        super(model, renderer);
        if (columnCount < 0) {
            throw new IllegalArgumentException("Column count should be ZERO or positive integer.");
        }
        if (rowCount < 0) {
            throw new IllegalArgumentException("Row count should be ZERO or positive integer.");
        }
        if (columnHeaderCount < 0) {
            throw new IllegalArgumentException("Column header count should be ZERO or positive integer.");
        }
        if (rowHeaderCount < 0) {
            throw new IllegalArgumentException("Row header count should be ZERO or positive integer.");
        }
        this.columnCount = columnCount;
        this.rowCount = rowCount;
        this.columnHeaderCount = columnHeaderCount;
        this.rowHeaderCount = rowHeaderCount;
    }

    public TableRenderer getRenderer() {
        return (TableRenderer)super.getRenderer();
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getColumnHeaderCount() {
        return this.columnHeaderCount;
    }

    public int getRowHeaderCount() {
        return this.rowHeaderCount;
    }

    public int getColumnIndex() {
        return this.colIndex;
    }

    public void setColIndex(int colIndex) {
        this.colIndex = colIndex;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public void setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
    }

    public int getColumnSpan() {
        return this.colSpan;
    }

    public void setColSpan(int colSpan) {
        this.colSpan = colSpan;
    }

    public int getRowSpan() {
        return this.rowSpan;
    }

    public void setRowSpan(int rowSpan) {
        this.rowSpan = rowSpan;
    }

    @Override
    protected ExpressionContext createExpressionContext(PivotModel model) {
        ExpressionContext context = super.createExpressionContext(model);
        context.put("columnCount", new ExpressionContext.ValueBinding<Integer>(){

            @Override
            public Integer getValue() {
                return TableRenderContext.this.getColumnCount();
            }
        });
        context.put("rowCount", new ExpressionContext.ValueBinding<Integer>(){

            @Override
            public Integer getValue() {
                return TableRenderContext.this.getRowCount();
            }
        });
        context.put("columnHeaderCount", new ExpressionContext.ValueBinding<Integer>(){

            @Override
            public Integer getValue() {
                return TableRenderContext.this.getColumnHeaderCount();
            }
        });
        context.put("rowHeaderCount", new ExpressionContext.ValueBinding<Integer>(){

            @Override
            public Integer getValue() {
                return TableRenderContext.this.getRowHeaderCount();
            }
        });
        context.put("columnIndex", new ExpressionContext.ValueBinding<Integer>(){

            @Override
            public Integer getValue() {
                return TableRenderContext.this.getColumnIndex();
            }
        });
        context.put("rowIndex", new ExpressionContext.ValueBinding<Integer>(){

            @Override
            public Integer getValue() {
                return TableRenderContext.this.getRowIndex();
            }
        });
        context.put("columnSpan", new ExpressionContext.ValueBinding<Integer>(){

            @Override
            public Integer getValue() {
                return TableRenderContext.this.getColumnSpan();
            }
        });
        context.put("rowSpan", new ExpressionContext.ValueBinding<Integer>(){

            @Override
            public Integer getValue() {
                return TableRenderContext.this.getRowSpan();
            }
        });
        return context;
    }
}

