/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.ui.table;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.olap4j.Axis;
import org.olap4j.OlapException;
import org.olap4j.Position;
import org.olap4j.metadata.Dimension;
import org.olap4j.metadata.Hierarchy;
import org.olap4j.metadata.Level;
import org.olap4j.metadata.Measure;
import org.olap4j.metadata.Member;
import org.olap4j.metadata.MetadataElement;
import org.olap4j.metadata.Property;
import org.pivot4j.PivotException;
import org.pivot4j.ui.aggregator.Aggregator;
import org.pivot4j.ui.table.TableAxisContext;
import org.pivot4j.util.MemberHierarchyCache;
import org.pivot4j.util.OlapUtils;
import org.pivot4j.util.TreeNode;
import org.pivot4j.util.TreeNodeCallback;

class TableHeaderNode
extends TreeNode<TableAxisContext> {
    private Position position;
    private Member member;
    private Property property;
    private Hierarchy hierarchy;
    private Integer colSpan;
    private Integer rowSpan;
    private Integer colIndex;
    private Integer rowIndex;
    private Integer maxRowIndex;
    private Integer hierarchyDescendants;
    private Integer memberChildren;
    private boolean aggregation = false;
    private Aggregator aggregator;

    TableHeaderNode(TableAxisContext context) {
        super(context);
    }

    public Position getPosition() {
        return this.position;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    public Member getMember() {
        return this.member;
    }

    public void setMember(Member member) {
        this.member = member;
    }

    public Level getMemberLevel() {
        return this.member == null ? null : this.member.getLevel();
    }

    public Hierarchy getHierarchy() {
        return this.hierarchy;
    }

    public void setHierarchy(Hierarchy hierarchy) {
        this.hierarchy = hierarchy;
    }

    public Property getProperty() {
        return this.property;
    }

    public void setProperty(Property property) {
        this.property = property;
    }

    public void clearCache() {
        this.colIndex = null;
        this.rowIndex = null;
        this.colSpan = null;
        this.rowSpan = null;
        this.maxRowIndex = null;
        this.hierarchyDescendants = null;
        this.memberChildren = null;
    }

    public int getHierarchyIndex() {
        if (this.hierarchy == null) {
            return -1;
        }
        return ((TableAxisContext)this.getReference()).getHierarchies().indexOf(this.hierarchy);
    }

    public Level getRootLevel() {
        int index = this.getHierarchyIndex();
        if (index < 0) {
            return null;
        }
        return ((TableAxisContext)this.getReference()).getLevels(this.getHierarchy()).get(0);
    }

    public int getMaxRowIndex() {
        if (this.maxRowIndex == null) {
            if (this.getChildCount() == 0) {
                this.maxRowIndex = this.getRowIndex();
            } else {
                this.maxRowIndex = 0;
                for (TreeNode child : this.getChildren()) {
                    TableHeaderNode nodeChild = (TableHeaderNode)child;
                    this.maxRowIndex = Math.max(this.maxRowIndex, nodeChild.getMaxRowIndex());
                }
            }
        }
        return this.maxRowIndex;
    }

    void addHierarhcyHeaders() {
        ArrayList children = new ArrayList(this.getChildren());
        for (TreeNode treeNode : children) {
            TableHeaderNode nodeChild = (TableHeaderNode)treeNode;
            Hierarchy childHierarchy = nodeChild.getHierarchy();
            if (childHierarchy != null && !OlapUtils.equals((MetadataElement)this.hierarchy, (MetadataElement)childHierarchy)) {
                int index = this.getChildren().indexOf(treeNode);
                this.removeChild(treeNode);
                TableHeaderNode hierarchyNode = new TableHeaderNode((TableAxisContext)this.getReference());
                hierarchyNode.setHierarchy(childHierarchy);
                this.addChild(index, hierarchyNode);
                hierarchyNode.addChild(treeNode);
            }
            nodeChild.addHierarhcyHeaders();
        }
    }

    void addParentMemberHeaders() {
        ArrayList children = new ArrayList(this.getChildren());
        MemberHierarchyCache cache = ((TableAxisContext)this.getReference()).getMemberHierarchyCache();
        for (TreeNode treeNode : children) {
            TableHeaderNode nodeChild = (TableHeaderNode)treeNode;
            Member mem = nodeChild.getMember();
            if (mem != null) {
                int index = this.getChildren().indexOf(treeNode);
                this.removeChild(treeNode);
                TreeNode childNode = treeNode;
                Member parent = mem;
                while (parent != null && (parent = cache.getParentMember(parent)) != null) {
                    TableHeaderNode parentNode = new TableHeaderNode((TableAxisContext)this.getReference());
                    parentNode.setPosition(nodeChild.getPosition());
                    parentNode.setHierarchy(parent.getHierarchy());
                    parentNode.setMember(parent);
                    parentNode.addChild(childNode);
                    childNode = parentNode;
                }
                this.addChild(index, childNode);
            }
            nodeChild.addParentMemberHeaders();
        }
    }

    void addMemberProperties() {
        if (((TableAxisContext)this.getReference()).getAxis() != Axis.ROWS) {
            return;
        }
        List children = null;
        if (this.getMember() != null) {
            List<Level> levels = ((TableAxisContext)this.getReference()).getLevels(this.getHierarchy());
            int n = levels.indexOf(this.getMember().getLevel());
            int endIndex = ((TableAxisContext)this.getReference()).getRenderer().getShowParentMembers() ? n + 1 : levels.size();
            List<Level> lowerLevels = levels.subList(n, endIndex);
            for (Level level : lowerLevels) {
                List<Property> properties = ((TableAxisContext)this.getReference()).getProperties(level);
                if (properties.isEmpty()) continue;
                children = new ArrayList(this.getChildren());
                this.clear();
                TableHeaderNode parentNode = this;
                for (Property property : properties) {
                    TableHeaderNode propertyNode = new TableHeaderNode((TableAxisContext)this.getReference());
                    propertyNode.setPosition(this.position);
                    propertyNode.setHierarchy(this.getHierarchy());
                    propertyNode.setMember(this.getMember());
                    propertyNode.setProperty(property);
                    parentNode.addChild(propertyNode);
                    parentNode = propertyNode;
                }
                for (TreeNode treeNode : children) {
                    parentNode.addChild(treeNode);
                }
            }
        }
        if (children == null) {
            children = this.getChildren();
        }
        for (TreeNode treeNode : children) {
            TableHeaderNode nodeChild = (TableHeaderNode)treeNode;
            nodeChild.addMemberProperties();
        }
    }

    void mergeChildren() {
        TableHeaderNode headerNode;
        ArrayList children = new ArrayList(this.getChildren());
        TableHeaderNode lastChild = null;
        for (TreeNode treeNode : children) {
            headerNode = (TableHeaderNode)treeNode;
            if (lastChild == null) {
                lastChild = headerNode;
                continue;
            }
            if (lastChild.canMergeWith(headerNode)) {
                for (TreeNode c : treeNode.getChildren()) {
                    lastChild.addChild(c);
                }
                this.removeChild(treeNode);
                continue;
            }
            lastChild = headerNode;
        }
        for (TreeNode treeNode : this.getChildren()) {
            headerNode = (TableHeaderNode)treeNode;
            headerNode.mergeChildren();
        }
    }

    protected boolean canMergeWith(TableHeaderNode sibling) {
        if (!OlapUtils.equals((MetadataElement)this.hierarchy, (MetadataElement)sibling.getHierarchy())) {
            return false;
        }
        if (!OlapUtils.equals((MetadataElement)this.member, (MetadataElement)sibling.getMember())) {
            return false;
        }
        if (!OlapUtils.equals((MetadataElement)this.property, (MetadataElement)sibling.getProperty())) {
            return false;
        }
        if (!OlapUtils.equals((MetadataElement)this.property, (MetadataElement)sibling.getProperty())) {
            return false;
        }
        if (this.aggregator == null) {
            if (sibling.getAggregator() != null) {
                return false;
            }
        } else {
            Aggregator other = sibling.getAggregator();
            if (other == null) {
                return false;
            }
            if (!ObjectUtils.equals((Object)this.aggregator.getName(), (Object)other.getName())) {
                return false;
            }
            if (!ObjectUtils.equals((Object)this.aggregator.getLevel(), (Object)other.getLevel())) {
                return false;
            }
        }
        return this.getRowSpan() == sibling.getRowSpan();
    }

    public int getColIndex() {
        if (this.colIndex == null) {
            if (this.getParent() == null) {
                this.colIndex = 0;
                return this.colIndex;
            }
            int index = ((TableHeaderNode)this.getParent()).getColIndex();
            int childIndex = this.getParent().getChildren().indexOf(this);
            for (int i = 0; i < childIndex; ++i) {
                index += this.getParent().getChildren().get(i).getWidth();
            }
            this.colIndex = index;
        }
        return this.colIndex;
    }

    public int getRowIndex() {
        if (this.rowIndex == null) {
            if (this.getParent() == null) {
                this.rowIndex = 0;
                return this.rowIndex;
            }
            TableHeaderNode headerParent = (TableHeaderNode)this.getParent();
            this.rowIndex = headerParent.getRowIndex() + headerParent.getRowSpan();
        }
        return this.rowIndex;
    }

    public int getColSpan() {
        if (this.colSpan == null) {
            this.colSpan = this.getWidth();
        }
        return this.colSpan;
    }

    public int getRowSpan() {
        block15: {
            HashMap maxSpans;
            block16: {
                Object hier;
                if (this.rowSpan != null) break block15;
                if ((this.member == null || this.property != null) && this.aggregator == null) {
                    this.rowSpan = 1;
                    return this.rowSpan;
                }
                maxSpans = new HashMap(((TableAxisContext)this.getReference()).getHierarchies().size());
                if (this.aggregator != null) {
                    this.getRoot().walkTree(new TreeNodeCallback<TableAxisContext>(){

                        @Override
                        public int handleTreeNode(TreeNode<TableAxisContext> node) {
                            TableHeaderNode nodeChild = (TableHeaderNode)node;
                            if (nodeChild.getMember() == null) {
                                return 0;
                            }
                            Integer maxSpan = (Integer)maxSpans.get(nodeChild.getHierarchy());
                            if (maxSpan == null) {
                                maxSpan = 0;
                            }
                            int current = nodeChild.getHierarchyDescendents();
                            TableHeaderNode parent = nodeChild;
                            while (parent != null) {
                                parent = (TableHeaderNode)parent.getParent();
                                if (!OlapUtils.equals((MetadataElement)nodeChild.getHierarchy(), (MetadataElement)parent.getHierarchy()) || parent.getMember() != null) break;
                                ++current;
                            }
                            if (current > maxSpan) {
                                maxSpans.put(nodeChild.getHierarchy(), current);
                            }
                            return 0;
                        }
                    });
                }
                if (this.member != null) break block16;
                int totalSpans = 0;
                for (Integer span : maxSpans.values()) {
                    totalSpans += span.intValue();
                }
                this.rowSpan = totalSpans;
                if (this.hierarchy != null) {
                    Iterator<Object> iterator = ((TableAxisContext)this.getReference()).getHierarchies().iterator();
                    while (iterator.hasNext() && !OlapUtils.equals((MetadataElement)(hier = (Hierarchy)iterator.next()), (MetadataElement)this.hierarchy)) {
                        TableHeaderNode tableHeaderNode = this;
                        Integer.valueOf(tableHeaderNode.rowSpan - (Integer)maxSpans.get(hier));
                        tableHeaderNode.rowSpan = tableHeaderNode.rowSpan;
                    }
                    TableHeaderNode parent = this;
                    while ((parent = (TableHeaderNode)parent.getParent()) != null && OlapUtils.equals((MetadataElement)this.hierarchy, (MetadataElement)parent.getHierarchy())) {
                        hier = this;
                        Integer.valueOf(hier.rowSpan - parent.getRowSpan());
                        hier.rowSpan = hier.rowSpan;
                    }
                }
                TableHeaderNode child = this;
                while (child != null && child.getChildCount() > 0) {
                    child = (TableHeaderNode)child.getChildren().get(0);
                    hier = this;
                    Integer.valueOf(hier.rowSpan - child.getRowSpan());
                    hier.rowSpan = hier.rowSpan;
                }
                break block15;
            }
            final int[] childSpan = new int[]{0};
            final int[] maxSpan = new int[]{0};
            this.walkChildrenAtColIndex(new TreeNodeCallback<TableAxisContext>(){

                @Override
                public int handleTreeNode(TreeNode<TableAxisContext> node) {
                    TableHeaderNode nodeChild = (TableHeaderNode)node;
                    if (nodeChild == TableHeaderNode.this) {
                        return 0;
                    }
                    if (OlapUtils.equals((MetadataElement)TableHeaderNode.this.hierarchy, (MetadataElement)nodeChild.getHierarchy())) {
                        childSpan[0] = childSpan[0] + nodeChild.getRowSpan();
                        return 0;
                    }
                    return 3;
                }
            }, this.getColIndex());
            final MemberHierarchyCache cache = ((TableAxisContext)this.getReference()).getMemberHierarchyCache();
            String cacheKey = this.getCacheKey();
            Integer cachedSpan = null;
            if (cacheKey != null) {
                cachedSpan = ((TableAxisContext)this.getReference()).getRowSpanCache().get(cacheKey);
            }
            if (cachedSpan == null) {
                this.getRoot().walkTree(new TreeNodeCallback<TableAxisContext>(){

                    @Override
                    public int handleTreeNode(TreeNode<TableAxisContext> node) {
                        TableHeaderNode nodeChild = (TableHeaderNode)node;
                        Level level = null;
                        Member nodeMember = nodeChild.getMember();
                        if (nodeChild == TableHeaderNode.this) {
                            return 0;
                        }
                        if (nodeMember != null) {
                            level = nodeMember.getLevel();
                        } else if (nodeChild.getAggregator() != null) {
                            level = nodeChild.getAggregator().getLevel();
                        }
                        if (OlapUtils.equals((MetadataElement)TableHeaderNode.this.member.getLevel(), (MetadataElement)level)) {
                            if (nodeMember != null && (cache.getAncestorMembers(nodeMember).contains(TableHeaderNode.this.member) || cache.getAncestorMembers(TableHeaderNode.this.member).contains(nodeMember))) {
                                return 0;
                            }
                            int span = nodeChild.getHierarchyDescendents();
                            if (TableHeaderNode.this.aggregator == null && nodeChild.getAggregator() != null && TableHeaderNode.this.member instanceof Measure && ((TableAxisContext)TableHeaderNode.this.getReference()).getHierarchies().size() == 1) {
                                ++span;
                            }
                            maxSpan[0] = Math.max(maxSpan[0], span);
                        }
                        return 0;
                    }
                });
                if (maxSpan[0] > 0) {
                    ((TableAxisContext)this.getReference()).getRowSpanCache().put(cacheKey, maxSpan[0]);
                }
            } else {
                maxSpan[0] = cachedSpan;
            }
            this.rowSpan = Math.max(1, maxSpan[0] - childSpan[0]);
            if (this.aggregator == null) break block15;
            boolean child = false;
            for (Hierarchy hier : ((TableAxisContext)this.getReference()).getHierarchies()) {
                Dimension.Type type;
                if (OlapUtils.equals((MetadataElement)hier, (MetadataElement)this.hierarchy)) {
                    child = true;
                    continue;
                }
                try {
                    type = hier.getDimension().getDimensionType();
                }
                catch (OlapException e) {
                    throw new PivotException(e);
                }
                if (!child || type == Dimension.Type.MEASURE) continue;
                TableHeaderNode tableHeaderNode = this;
                Integer.valueOf(tableHeaderNode.rowSpan + (Integer)maxSpans.get(hier));
                tableHeaderNode.rowSpan = tableHeaderNode.rowSpan;
            }
        }
        return this.rowSpan;
    }

    private String getCacheKey() {
        if (this.member == null || this.aggregator != null) {
            return null;
        }
        return this.member.getLevel().getUniqueName() + "_" + this.getHierarchyDescendents() + "_" + this.getLevelAncestors();
    }

    public boolean isAggregation() {
        return this.aggregation;
    }

    public void setAggregation(boolean aggregation) {
        this.aggregation = aggregation;
    }

    public Aggregator getAggregator() {
        return this.aggregator;
    }

    public void setAggregator(Aggregator aggregator) {
        this.aggregator = aggregator;
    }

    public TableHeaderNode getHierarchyRoot() {
        TableHeaderNode node;
        TableHeaderNode parent = this;
        while ((node = (TableHeaderNode)parent.getParent()) != null && OlapUtils.equals((MetadataElement)this.hierarchy, (MetadataElement)node.getHierarchy())) {
            parent = node;
        }
        return parent;
    }

    public int getHierarchyDescendents() {
        if (this.member == null || this.getChildCount() == 0) {
            return 1;
        }
        if (this.hierarchyDescendants == null) {
            int height = 1;
            for (TreeNode child : this.getChildren()) {
                TableHeaderNode nodeChild = (TableHeaderNode)child;
                if (!OlapUtils.equals((MetadataElement)this.hierarchy, (MetadataElement)nodeChild.getHierarchy())) continue;
                height = Math.max(height, 1 + nodeChild.getHierarchyDescendents());
            }
            this.hierarchyDescendants = height;
        }
        return this.hierarchyDescendants;
    }

    protected int getLevelAncestors() {
        int ancestors = 1;
        TableHeaderNode node = (TableHeaderNode)this.getParent();
        if (this.member != null && node != null) {
            while (node != null) {
                Level parentLevel = node.getMemberLevel();
                if (!OlapUtils.equals((MetadataElement)this.member.getLevel(), (MetadataElement)parentLevel)) break;
                node = (TableHeaderNode)node.getParent();
                ++ancestors;
            }
        }
        return ancestors;
    }

    protected List<Member> getMemberPath() {
        LinkedList<Member> path = new LinkedList<Member>();
        for (TableHeaderNode node = (TableHeaderNode)this.getParent(); node != null; node = (TableHeaderNode)node.getParent()) {
            path.add(0, node.getMember());
        }
        return path;
    }

    private static boolean isSubPath(List<Member> parentPath, List<Member> childPath) {
        Iterator<Member> it = childPath.iterator();
        for (Member member : parentPath) {
            if (OlapUtils.equals((MetadataElement)member, (MetadataElement)it.next())) continue;
            return false;
        }
        return true;
    }

    public int getMemberChildren() {
        if (this.member == null) {
            return 0;
        }
        if (this.memberChildren == null) {
            final MemberHierarchyCache cache = ((TableAxisContext)this.getReference()).getMemberHierarchyCache();
            final List<Member> path = this.getMemberPath();
            final int[] childCount = new int[]{0};
            final int depth = this.member.getDepth();
            this.getRoot().walkChildren(new TreeNodeCallback<TableAxisContext>(){

                @Override
                public int handleTreeNode(TreeNode<TableAxisContext> node) {
                    TableHeaderNode nodeChild = (TableHeaderNode)node;
                    if (node == TableHeaderNode.this) {
                        return 0;
                    }
                    if (OlapUtils.equals((MetadataElement)TableHeaderNode.this.hierarchy, (MetadataElement)nodeChild.getHierarchy())) {
                        List<Member> childPath = nodeChild.getMemberPath();
                        if (path.size() > childPath.size() || !TableHeaderNode.isSubPath(path, childPath)) {
                            return 0;
                        }
                        Member childMember = nodeChild.getMember();
                        if (childMember != null) {
                            int childDepth = childMember.getDepth();
                            if (cache.getAncestorMembers(childMember).contains(TableHeaderNode.this.member)) {
                                childCount[0] = childCount[0] + 1;
                                return 1;
                            }
                            if (depth == childDepth ? !OlapUtils.equals((MetadataElement)childMember, (MetadataElement)TableHeaderNode.this.member) : depth < childDepth || !cache.getAncestorMembers(TableHeaderNode.this.member).contains(childMember)) {
                                return 1;
                            }
                        }
                    } else if (nodeChild.getMember() != null) {
                        Member parentMember;
                        TableHeaderNode parent = TableHeaderNode.this;
                        do {
                            if ((parent = (TableHeaderNode)parent.getParent()) == null) {
                                return 2;
                            }
                            parentMember = parent.getMember();
                        } while (!OlapUtils.equals((MetadataElement)parent.getHierarchy(), (MetadataElement)nodeChild.getHierarchy()) || parentMember == null);
                        if (OlapUtils.equals((MetadataElement)parentMember, (MetadataElement)nodeChild.getMember()) || cache.getAncestorMembers(parentMember).contains(nodeChild.getMember())) {
                            return 0;
                        }
                        return 1;
                    }
                    return 0;
                }
            });
            this.memberChildren = childCount[0];
        }
        return this.memberChildren;
    }

    public int walkChildrenAtRowIndex(TreeNodeCallback<TableAxisContext> callbackHandler, int rowIndex) {
        int code = 0;
        for (TreeNode child : this.getChildren()) {
            TableHeaderNode nodeChild = (TableHeaderNode)child;
            int childIndex = nodeChild.getRowIndex();
            if (rowIndex == childIndex) {
                code = callbackHandler.handleTreeNode(child);
                if (code < 2) continue;
                return code;
            }
            if (rowIndex <= child.getLevel()) continue;
            nodeChild.walkChildrenAtRowIndex(callbackHandler, rowIndex);
        }
        return code;
    }

    public TableHeaderNode getLeafNodeAtColIndex(int colIndex) {
        if (this.getChildCount() == 0 && this.getColIndex() == colIndex) {
            return this;
        }
        for (TreeNode child : this.getChildren()) {
            TableHeaderNode nodeChild = (TableHeaderNode)child;
            int startIndex = nodeChild.getColIndex();
            int endIndex = startIndex + nodeChild.getColSpan();
            if (colIndex >= startIndex && colIndex < endIndex) {
                return nodeChild.getLeafNodeAtColIndex(colIndex);
            }
            if (endIndex <= colIndex) continue;
            break;
        }
        return null;
    }

    public int walkChildrenAtColIndex(TreeNodeCallback<TableAxisContext> callbackHandler, int colIndex) {
        int code = 0;
        if (this.getColIndex() == colIndex && (code = callbackHandler.handleTreeNode(this)) >= 2) {
            return code;
        }
        for (TreeNode child : this.getChildren()) {
            TableHeaderNode nodeChild = (TableHeaderNode)child;
            int startIndex = nodeChild.getColIndex();
            int endIndex = startIndex + nodeChild.getColSpan();
            if (colIndex < startIndex) {
                code = 1;
                continue;
            }
            if (colIndex >= endIndex) {
                code = 2;
                continue;
            }
            code = nodeChild.walkChildrenAtColIndex(callbackHandler, colIndex);
            break;
        }
        return code;
    }

    public String toString() {
        if (this.member != null) {
            return this.member.getCaption();
        }
        if (this.hierarchy != null) {
            return this.hierarchy.getCaption();
        }
        return ((TableAxisContext)this.getReference()).getAxis().name();
    }
}

