/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.ui.fop;

import java.io.OutputStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.olap4j.Axis;
import org.pivot4j.PivotException;
import org.pivot4j.PivotModel;
import org.pivot4j.ui.AbstractContentRenderCallback;
import org.pivot4j.ui.command.UICommand;
import org.pivot4j.ui.table.TableRenderCallback;
import org.pivot4j.ui.table.TableRenderContext;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class FopExporter
extends AbstractContentRenderCallback<TableRenderContext>
implements TableRenderCallback {
    private FopFactory fopFactory;
    private FOUserAgent userAgent;
    private DefaultHandler documentHandler;
    private MediaSize mediaSize = MediaSize.getMediaSizeForName(MediaSizeName.ISO_A4);
    private boolean showHeader = true;
    private boolean showFooter = true;
    private String titleText;
    private String footerText;
    private String fontSize = "8pt";
    private String fontFamily = "Verdana, Geneva, Arial, Helvetica, sans-serif";
    private String titleFontSize = "10pt";
    private String titleFontFamily = "Verdana, Geneva, Arial, Helvetica, sans-serif";
    private String footerFontSize = "10pt";
    private String footerFontFamily = "Verdana, Geneva, Arial, Helvetica, sans-serif";
    private OrientationRequested orientation = OrientationRequested.PORTRAIT;

    public FopExporter(OutputStream out) {
        super(out);
    }

    @Override
    public String getContentType() {
        return "application/pdf";
    }

    public MediaSize getMediaSize() {
        return this.mediaSize;
    }

    public void setMediaSize(MediaSize mediaSize) {
        this.mediaSize = mediaSize;
    }

    public OrientationRequested getOrientation() {
        return this.orientation;
    }

    public void setOrientation(OrientationRequested orientation) {
        this.orientation = orientation;
    }

    public boolean getShowHeader() {
        return this.showHeader;
    }

    public void setShowHeader(boolean showHeader) {
        this.showHeader = showHeader;
    }

    public boolean getShowFooter() {
        return this.showFooter;
    }

    public void setShowFooter(boolean showFooter) {
        this.showFooter = showFooter;
    }

    public String getTitleText() {
        return this.titleText;
    }

    public String getFooterText() {
        return this.footerText;
    }

    public void setFooterText(String footerText) {
        this.footerText = footerText;
    }

    public void setTitleText(String titleText) {
        this.titleText = titleText;
    }

    public String getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(String fontSize) {
        this.fontSize = fontSize;
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public void setFontFamily(String fontFamily) {
        this.fontFamily = fontFamily;
    }

    public String getTitleFontSize() {
        return this.titleFontSize;
    }

    public void setTitleFontSize(String titleFontSize) {
        this.titleFontSize = titleFontSize;
    }

    public String getTitleFontFamily() {
        return this.titleFontFamily;
    }

    public void setTitleFontFamily(String titleFontFamily) {
        this.titleFontFamily = titleFontFamily;
    }

    public String getFooterFontSize() {
        return this.footerFontSize;
    }

    public void setFooterFontSize(String footerFontSize) {
        this.footerFontSize = footerFontSize;
    }

    public String getFooterFontFamily() {
        return this.footerFontFamily;
    }

    public void setFooterFontFamily(String footerFontFamily) {
        this.footerFontFamily = footerFontFamily;
    }

    protected FopFactory createFopFactory() {
        return FopFactory.newInstance();
    }

    protected FopFactory getFopFactory() {
        return this.fopFactory;
    }

    protected FOUserAgent createUserAgent(FopFactory factory) {
        return factory.newFOUserAgent();
    }

    protected FOUserAgent getUserAgent() {
        return this.userAgent;
    }

    protected Fop createFop(FopFactory factory, FOUserAgent agent, OutputStream out) throws FOPException {
        return factory.newFop(this.getContentType(), agent, out);
    }

    protected DefaultHandler getDocumentHandler() {
        return this.documentHandler;
    }

    @Override
    public void startRender(TableRenderContext context) {
        this.fopFactory = this.createFopFactory();
        this.userAgent = this.createUserAgent(this.fopFactory);
        try {
            Fop fop = this.createFop(this.getFopFactory(), this.getUserAgent(), this.getOutputStream());
            this.documentHandler = fop.getDefaultHandler();
            this.documentHandler.startDocument();
            this.documentHandler.startElement("http://www.w3.org/1999/XSL/Format", "root", "root", new AttributesImpl());
            this.startLayoutDefinition(context);
            this.endLayoutDefinition(context);
            this.startPageSequence(context);
        }
        catch (SAXException e) {
            throw new PivotException(e);
        }
    }

    @Override
    public void startTable(TableRenderContext context) {
        try {
            this.documentHandler.startElement("http://www.w3.org/1999/XSL/Format", "table", "table", this.createTableAttributes(context));
        }
        catch (SAXException e) {
            throw new PivotException(e);
        }
    }

    @Override
    public void startHeader(TableRenderContext context) {
        try {
            this.documentHandler.startElement("http://www.w3.org/1999/XSL/Format", "table-header", "table-header", this.createTableHeaderAttributes(context));
        }
        catch (SAXException e) {
            throw new PivotException(e);
        }
    }

    @Override
    public void endHeader(TableRenderContext context) {
        try {
            if (context.getAxis() == Axis.FILTER) {
                this.documentHandler.startElement("http://www.w3.org/1999/XSL/Format", "table-row", "table-row", new AttributesImpl());
                this.documentHandler.startElement("http://www.w3.org/1999/XSL/Format", "table-cell", "table-cell", new AttributesImpl());
                this.documentHandler.startElement("http://www.w3.org/1999/XSL/Format", "block", "block", this.createTitleTextAttributes(context));
                String title = context.getResourceBundle().getString("label.filter");
                this.documentHandler.characters(title.toCharArray(), 0, title.length());
                this.documentHandler.endElement("http://www.w3.org/1999/XSL/Format", "block", "block");
                this.documentHandler.endElement("http://www.w3.org/1999/XSL/Format", "table-cell", "table-cell");
                this.documentHandler.endElement("http://www.w3.org/1999/XSL/Format", "table-row", "table-row");
            }
            this.documentHandler.endElement("http://www.w3.org/1999/XSL/Format", "table-header", "table-header");
        }
        catch (SAXException e) {
            throw new PivotException(e);
        }
    }

    @Override
    public void startBody(TableRenderContext context) {
        try {
            this.documentHandler.startElement("http://www.w3.org/1999/XSL/Format", "table-body", "table-body", this.createTableBodyAttributes(context));
        }
        catch (SAXException e) {
            throw new PivotException(e);
        }
    }

    @Override
    public void startRow(TableRenderContext context) {
        try {
            this.documentHandler.startElement("http://www.w3.org/1999/XSL/Format", "table-row", "table-row", this.createRowAttributes(context));
        }
        catch (SAXException e) {
            throw new PivotException(e);
        }
    }

    @Override
    public void startCell(TableRenderContext context) {
        try {
            this.documentHandler.startElement("http://www.w3.org/1999/XSL/Format", "table-cell", "table-cell", this.createCellAttributes(context));
            this.documentHandler.startElement("http://www.w3.org/1999/XSL/Format", "block", "block", this.createCellContentAttributes(context));
        }
        catch (SAXException e) {
            throw new PivotException(e);
        }
    }

    @Override
    public void renderCommands(TableRenderContext context, List<UICommand<?>> commands) {
    }

    @Override
    public void renderContent(TableRenderContext context, String label, Double value) {
        try {
            this.documentHandler.startElement("http://www.w3.org/1999/XSL/Format", "inline", "inline", new AttributesImpl());
            if (context.getAxis() == Axis.FILTER && context.getColumnIndex() > 1) {
                this.documentHandler.characters(", ".toCharArray(), 0, 2);
            }
            if (label != null) {
                this.documentHandler.characters(label.toCharArray(), 0, label.length());
            }
            this.documentHandler.endElement("http://www.w3.org/1999/XSL/Format", "inline", "inline");
        }
        catch (SAXException e) {
            throw new PivotException(e);
        }
    }

    @Override
    public void endCell(TableRenderContext context) {
        try {
            this.documentHandler.endElement("http://www.w3.org/1999/XSL/Format", "block", "block");
            this.documentHandler.endElement("http://www.w3.org/1999/XSL/Format", "table-cell", "table-cell");
        }
        catch (SAXException e) {
            throw new PivotException(e);
        }
    }

    @Override
    public void endRow(TableRenderContext context) {
        try {
            this.documentHandler.endElement("http://www.w3.org/1999/XSL/Format", "table-row", "table-row");
        }
        catch (SAXException e) {
            throw new PivotException(e);
        }
    }

    @Override
    public void endBody(TableRenderContext context) {
        try {
            this.documentHandler.endElement("http://www.w3.org/1999/XSL/Format", "table-body", "table-body");
        }
        catch (SAXException e) {
            throw new PivotException(e);
        }
    }

    @Override
    public void endTable(TableRenderContext context) {
        try {
            this.documentHandler.endElement("http://www.w3.org/1999/XSL/Format", "table", "table");
        }
        catch (SAXException e) {
            throw new PivotException(e);
        }
    }

    @Override
    public void endRender(TableRenderContext context) {
        try {
            this.endPageSequence(context);
            this.documentHandler.endElement("http://www.w3.org/1999/XSL/Format", "root", "root");
            this.documentHandler.endDocument();
        }
        catch (SAXException e) {
            throw new PivotException(e);
        }
    }

    protected void startLayoutDefinition(TableRenderContext context) throws SAXException {
        this.documentHandler.startElement("http://www.w3.org/1999/XSL/Format", "layout-master-set", "layout-master-set", this.createLayoutMasterSetAttributes(context));
        this.documentHandler.startElement("http://www.w3.org/1999/XSL/Format", "simple-page-master", "simple-page-master", this.createPageMasterAttributes(context));
        this.documentHandler.startElement("http://www.w3.org/1999/XSL/Format", "region-body", "region-body", this.createRegionBodyAttributes(context));
    }

    protected AttributesImpl createLayoutMasterSetAttributes(TableRenderContext context) {
        return new AttributesImpl();
    }

    protected AttributesImpl createPageMasterAttributes(TableRenderContext context) {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute("", "master-name", "master-name", "CDATA", "content");
        String width = this.mediaSize.getX(1000) + "mm";
        String height = this.mediaSize.getY(1000) + "mm";
        if (this.orientation.equals(OrientationRequested.LANDSCAPE) || this.orientation.equals(OrientationRequested.REVERSE_LANDSCAPE)) {
            attributes.addAttribute("", "page-width", "page-width", "CDATA", height);
            attributes.addAttribute("", "page-height", "page-height", "CDATA", width);
        } else if (this.orientation.equals(OrientationRequested.PORTRAIT) || this.orientation.equals(OrientationRequested.REVERSE_PORTRAIT)) {
            attributes.addAttribute("", "page-width", "page-width", "CDATA", width);
            attributes.addAttribute("", "page-height", "page-height", "CDATA", height);
        } else assert (false);
        attributes.addAttribute("", "margin", "margin", "CDATA", "1cm");
        return attributes;
    }

    protected AttributesImpl createRegionBeforeAttributes(TableRenderContext context) {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute("", "extent", "extent", "CDATA", "1cm");
        return attributes;
    }

    protected AttributesImpl createRegionAfterAttributes(TableRenderContext context) {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute("", "extent", "extent", "CDATA", "0.5cm");
        return attributes;
    }

    protected AttributesImpl createRegionBodyAttributes(TableRenderContext context) {
        AttributesImpl attributes = new AttributesImpl();
        if (this.getShowHeader()) {
            attributes.addAttribute("", "margin-top", "margin-top", "CDATA", "1.5cm");
        }
        if (this.getShowFooter()) {
            attributes.addAttribute("", "margin-bottom", "margin-bottom", "CDATA", "1.5cm");
        }
        return attributes;
    }

    protected AttributesImpl createFlowAttributes(TableRenderContext context) {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute("", "flow-name", "flow-name", "CDATA", "xsl-region-body");
        return attributes;
    }

    protected void endLayoutDefinition(TableRenderContext context) throws SAXException {
        this.documentHandler.endElement("http://www.w3.org/1999/XSL/Format", "region-body", "region-body");
        if (this.getShowHeader()) {
            this.documentHandler.startElement("http://www.w3.org/1999/XSL/Format", "region-before", "region-before", this.createRegionBeforeAttributes(context));
            this.documentHandler.endElement("http://www.w3.org/1999/XSL/Format", "region-before", "region-before");
        }
        if (this.getShowFooter()) {
            this.documentHandler.startElement("http://www.w3.org/1999/XSL/Format", "region-after", "region-after", this.createRegionAfterAttributes(context));
            this.documentHandler.endElement("http://www.w3.org/1999/XSL/Format", "region-after", "region-after");
        }
        this.documentHandler.endElement("http://www.w3.org/1999/XSL/Format", "simple-page-master", "simple-page-master");
        this.documentHandler.endElement("http://www.w3.org/1999/XSL/Format", "layout-master-set", "layout-master-set");
    }

    protected void startPageSequence(TableRenderContext context) throws SAXException {
        AttributesImpl attributes;
        this.documentHandler.startElement("http://www.w3.org/1999/XSL/Format", "page-sequence", "page-sequence", this.createPageSequenceAttributes(context));
        if (this.getShowHeader()) {
            attributes = new AttributesImpl();
            attributes.addAttribute("", "flow-name", "flow-name", "CDATA", "xsl-region-before");
            this.documentHandler.startElement("http://www.w3.org/1999/XSL/Format", "static-content", "static-content", attributes);
            this.startHeaderBlock(context);
            this.endHeaderBlock(context);
            this.documentHandler.endElement("http://www.w3.org/1999/XSL/Format", "static-content", "static-content");
        }
        if (this.getShowFooter()) {
            attributes = new AttributesImpl();
            attributes.addAttribute("", "flow-name", "flow-name", "CDATA", "xsl-region-after");
            this.documentHandler.startElement("http://www.w3.org/1999/XSL/Format", "static-content", "static-content", attributes);
            this.startFooterBlock(context);
            this.createFooterContent(context);
            this.endFooterBlock(context);
            this.documentHandler.endElement("http://www.w3.org/1999/XSL/Format", "static-content", "static-content");
        }
        this.documentHandler.startElement("http://www.w3.org/1999/XSL/Format", "flow", "flow", this.createFlowAttributes(context));
        if (this.getShowHeader()) {
            this.createHeaderContent(context);
        }
    }

    protected void createHeaderContent(TableRenderContext context) throws SAXException {
        PivotModel model = context.getModel();
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute("", "marker-class-name", "marker-class-name", "CDATA", "page-head");
        this.documentHandler.startElement("http://www.w3.org/1999/XSL/Format", "marker", "marker", attributes);
        AttributesImpl tableAttrs = new AttributesImpl();
        tableAttrs.addAttribute("", "width", "width", "CDATA", "100%");
        tableAttrs.addAttribute("", "table-layout", "table-layout", "CDATA", "fixed");
        this.documentHandler.startElement("http://www.w3.org/1999/XSL/Format", "table", "table", tableAttrs);
        AttributesImpl colAttrs1 = new AttributesImpl();
        colAttrs1.addAttribute("", "width", "width", "CDATA", "proportional-column-width(4)");
        AttributesImpl colAttrs2 = new AttributesImpl();
        colAttrs1.addAttribute("", "width", "width", "CDATA", "proportional-column-width(1)");
        this.documentHandler.startElement("http://www.w3.org/1999/XSL/Format", "table-column", "table-column", colAttrs1);
        this.documentHandler.endElement("http://www.w3.org/1999/XSL/Format", "table-column", "table-column");
        this.documentHandler.startElement("http://www.w3.org/1999/XSL/Format", "table-column", "table-column", colAttrs2);
        this.documentHandler.endElement("http://www.w3.org/1999/XSL/Format", "table-column", "table-column");
        this.documentHandler.startElement("http://www.w3.org/1999/XSL/Format", "table-body", "table-body", new AttributesImpl());
        this.documentHandler.startElement("http://www.w3.org/1999/XSL/Format", "table-row", "table-row", new AttributesImpl());
        this.documentHandler.startElement("http://www.w3.org/1999/XSL/Format", "table-cell", "table-cell", new AttributesImpl());
        this.documentHandler.startElement("http://www.w3.org/1999/XSL/Format", "block", "block", this.createTitleTextAttributes(context));
        String title = this.getTitleText();
        if (title == null) {
            title = model.getCube().getCaption();
        }
        this.documentHandler.characters(title.toCharArray(), 0, title.length());
        this.documentHandler.endElement("http://www.w3.org/1999/XSL/Format", "block", "block");
        this.documentHandler.endElement("http://www.w3.org/1999/XSL/Format", "table-cell", "table-cell");
        this.documentHandler.startElement("http://www.w3.org/1999/XSL/Format", "table-cell", "table-cell", new AttributesImpl());
        AttributesImpl cellAttrs2 = new AttributesImpl();
        cellAttrs2.addAttribute("", "text-align", "text-align", "CDATA", "right");
        this.documentHandler.startElement("http://www.w3.org/1999/XSL/Format", "block", "block", cellAttrs2);
        this.documentHandler.characters("Page ".toCharArray(), 0, 5);
        this.documentHandler.startElement("http://www.w3.org/1999/XSL/Format", "page-number", "page-number", new AttributesImpl());
        this.documentHandler.endElement("http://www.w3.org/1999/XSL/Format", "page-number", "page-number");
        this.documentHandler.endElement("http://www.w3.org/1999/XSL/Format", "block", "block");
        this.documentHandler.endElement("http://www.w3.org/1999/XSL/Format", "table-cell", "table-cell");
        this.documentHandler.endElement("http://www.w3.org/1999/XSL/Format", "table-row", "table-row");
        this.documentHandler.endElement("http://www.w3.org/1999/XSL/Format", "table-body", "table-body");
        this.documentHandler.endElement("http://www.w3.org/1999/XSL/Format", "table", "table");
        this.documentHandler.endElement("http://www.w3.org/1999/XSL/Format", "marker", "marker");
    }

    protected AttributesImpl createTitleTextAttributes(TableRenderContext context) {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute("", "text-align", "text-align", "CDATA", "left");
        if (this.titleFontSize != null) {
            attributes.addAttribute("", "font-size", "font-size", "CDATA", this.titleFontSize);
        }
        if (this.titleFontFamily != null) {
            attributes.addAttribute("", "font-family", "font-family", "CDATA", this.titleFontFamily);
        }
        return attributes;
    }

    protected void createFooterContent(TableRenderContext context) throws SAXException {
        this.documentHandler.startElement("http://www.w3.org/1999/XSL/Format", "block", "block", this.createFooterTextAttributes(context));
        String footer = this.getFooterText();
        if (footer == null) {
            footer = DateFormat.getDateTimeInstance().format(new Date());
        }
        this.documentHandler.characters(footer.toCharArray(), 0, footer.length());
        this.documentHandler.endElement("http://www.w3.org/1999/XSL/Format", "block", "block");
    }

    protected AttributesImpl createFooterTextAttributes(TableRenderContext context) {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute("", "text-align", "text-align", "CDATA", "right");
        if (this.footerFontSize != null) {
            attributes.addAttribute("", "font-size", "font-size", "CDATA", this.footerFontSize);
        }
        if (this.footerFontFamily != null) {
            attributes.addAttribute("", "font-family", "font-family", "CDATA", this.footerFontFamily);
        }
        return attributes;
    }

    protected AttributesImpl createPageSequenceAttributes(TableRenderContext context) {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute("", "master-reference", "master-reference", "CDATA", "content");
        return attributes;
    }

    protected void startHeaderBlock(TableRenderContext context) throws SAXException {
        this.documentHandler.startElement("http://www.w3.org/1999/XSL/Format", "block", "block", this.createHeaderBlockAttributes(context));
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute("", "retrieve-class-name", "retrieve-class-name", "CDATA", "page-head");
        this.documentHandler.startElement("http://www.w3.org/1999/XSL/Format", "retrieve-marker", "retrieve-marker", attributes);
        this.documentHandler.endElement("http://www.w3.org/1999/XSL/Format", "retrieve-marker", "retrieve-marker");
    }

    protected AttributesImpl createHeaderBlockAttributes(TableRenderContext context) {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute("", "border-bottom", "border-bottom", "CDATA", "1pt solid black");
        if (this.fontSize != null) {
            attributes.addAttribute("", "font-size", "font-size", "CDATA", this.fontSize);
        }
        attributes.addAttribute("", "font-weight", "font-weight", "CDATA", "bold");
        attributes.addAttribute("", "padding-top", "padding-top", "CDATA", "2mm");
        attributes.addAttribute("", "padding-bottom", "padding-bottom", "CDATA", "2mm");
        return attributes;
    }

    protected void endHeaderBlock(TableRenderContext context) throws SAXException {
        this.documentHandler.endElement("http://www.w3.org/1999/XSL/Format", "block", "block");
    }

    protected void startFooterBlock(TableRenderContext context) throws SAXException {
        this.documentHandler.startElement("http://www.w3.org/1999/XSL/Format", "block", "block", this.createFooterBlockAttributes(context));
    }

    protected AttributesImpl createFooterBlockAttributes(TableRenderContext context) {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute("", "border-top", "border-top", "CDATA", "1pt solid black");
        attributes.addAttribute("", "padding-top", "padding-top", "CDATA", "2mm");
        attributes.addAttribute("", "padding-bottom", "padding-bottom", "CDATA", "2mm");
        return attributes;
    }

    protected void endFooterBlock(TableRenderContext context) throws SAXException {
        this.documentHandler.endElement("http://www.w3.org/1999/XSL/Format", "block", "block");
    }

    protected void endPageSequence(TableRenderContext context) throws SAXException {
        this.documentHandler.endElement("http://www.w3.org/1999/XSL/Format", "flow", "flow");
        this.documentHandler.endElement("http://www.w3.org/1999/XSL/Format", "page-sequence", "page-sequence");
    }

    protected AttributesImpl createTableAttributes(TableRenderContext context) {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute("", "width", "width", "CDATA", "100%");
        attributes.addAttribute("", "table-layout", "table-layout", "CDATA", "fixed");
        if (context.getAxis() == Axis.FILTER) {
            attributes.addAttribute("", "margin-top", "margin-top", "CDATA", "1.0em");
        }
        return attributes;
    }

    protected AttributesImpl createTableHeaderAttributes(TableRenderContext context) {
        return new AttributesImpl();
    }

    protected AttributesImpl createTableBodyAttributes(TableRenderContext context) {
        return new AttributesImpl();
    }

    protected AttributesImpl createRowAttributes(TableRenderContext context) {
        return new AttributesImpl();
    }

    protected AttributesImpl createCellAttributes(TableRenderContext context) {
        AttributesImpl attributes = new AttributesImpl();
        if (context.getColumnSpan() > 1) {
            attributes.addAttribute("", "number-columns-spanned", "number-columns-spanned", "CDATA", Integer.toString(context.getColumnSpan()));
        }
        if (context.getRowSpan() > 1) {
            attributes.addAttribute("", "number-rows-spanned", "number-rows-spanned", "CDATA", Integer.toString(context.getRowSpan()));
        }
        if (context.getCell() == null && !"value".equals(context.getCellType())) {
            attributes.addAttribute("", "background-color", "background-color", "CDATA", "#DEDEDE");
            attributes.addAttribute("", "font-weight", "font-weight", "CDATA", "bold");
        } else if (context.getRowIndex() % 2 == 1) {
            attributes.addAttribute("", "background-color", "background-color", "CDATA", "#EFF2F5");
        }
        attributes.addAttribute("", "border", "border", "CDATA", "1px solid black");
        attributes.addAttribute("", "padding-top", "padding-top", "CDATA", "1mm");
        attributes.addAttribute("", "padding-left", "padding-left", "CDATA", "1mm");
        attributes.addAttribute("", "padding-bottom", "padding-bottom", "CDATA", "1mm");
        attributes.addAttribute("", "padding-right", "padding-right", "CDATA", "1mm");
        if (this.fontSize != null) {
            attributes.addAttribute("", "font-size", "font-size", "CDATA", this.fontSize);
        }
        if (this.fontFamily != null) {
            attributes.addAttribute("", "font-family", "font-family", "CDATA", this.fontFamily);
        }
        return attributes;
    }

    protected AttributesImpl createCellContentAttributes(TableRenderContext context) {
        AttributesImpl attributes = new AttributesImpl();
        if ("value".equals(context.getCellType())) {
            attributes.addAttribute("", "text-align", "text-align", "CDATA", "right");
        }
        return attributes;
    }
}

