/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.ui.condition;

import java.io.Serializable;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.pivot4j.ui.RenderContext;
import org.pivot4j.ui.condition.AbstractCondition;
import org.pivot4j.ui.condition.Condition;
import org.pivot4j.ui.condition.ConditionFactory;

public class NotCondition
extends AbstractCondition {
    public static final String NAME = "not";
    private Condition subCondition;

    public NotCondition(ConditionFactory conditionFactory) {
        super(conditionFactory);
    }

    public NotCondition(ConditionFactory conditionFactory, Condition subCondition) {
        super(conditionFactory);
        this.subCondition = subCondition;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public Condition getSubCondition() {
        return this.subCondition;
    }

    public void setSubCondition(Condition subCondition) {
        this.subCondition = subCondition;
    }

    @Override
    public boolean matches(RenderContext context) {
        if (this.subCondition == null) {
            throw new IllegalStateException("Sub condition was not specified.");
        }
        return !this.subCondition.matches(context);
    }

    @Override
    public Serializable saveState() {
        if (this.subCondition == null) {
            return null;
        }
        return new Serializable[]{this.subCondition.getName(), this.subCondition.saveState()};
    }

    @Override
    public void restoreState(Serializable state) {
        Serializable[] states = (Serializable[])state;
        if (states == null) {
            this.subCondition = null;
        } else {
            this.subCondition = this.getConditionFactory().createCondition((String)((Object)states[0]));
            this.subCondition.restoreState(states[1]);
        }
    }

    @Override
    public void saveSettings(HierarchicalConfiguration configuration) {
        super.saveSettings(configuration);
        if (this.subCondition == null) {
            return;
        }
        configuration.setProperty("condition", (Object)"");
        this.subCondition.saveSettings((HierarchicalConfiguration)configuration.configurationAt("condition"));
    }

    @Override
    public void restoreSettings(HierarchicalConfiguration configuration) {
        this.subCondition = null;
        try {
            SubnodeConfiguration subConfig = configuration.configurationAt("condition");
            String name = subConfig.getString("[@name]");
            if (name != null) {
                this.subCondition = this.getConditionFactory().createCondition(name);
                this.subCondition.restoreSettings((HierarchicalConfiguration)subConfig);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("!");
        if (this.subCondition == null) {
            builder.append("[MISSING]");
        } else {
            builder.append(this.subCondition.toString());
        }
        return builder.toString();
    }
}

