/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.ui.condition;

import java.io.Serializable;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.pivot4j.el.ExpressionEvaluator;
import org.pivot4j.ui.RenderContext;
import org.pivot4j.ui.condition.AbstractCondition;
import org.pivot4j.ui.condition.ConditionFactory;

public class ExpressionCondition
extends AbstractCondition {
    public static final String NAME = "expression";
    private String expression;

    public ExpressionCondition(ConditionFactory conditionFactory) {
        super(conditionFactory);
    }

    public ExpressionCondition(ConditionFactory conditionFactory, String expression) {
        super(conditionFactory);
        this.expression = expression;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    @Override
    public boolean matches(RenderContext context) {
        if (this.expression == null) {
            throw new IllegalStateException("Missing expression statement.");
        }
        ExpressionEvaluator evaluator = context.getExpressionEvaluator();
        Object result = evaluator.evaluate(this.expression, context.getExpressionContext());
        if (result != null) {
            return "true".equalsIgnoreCase(result.toString().trim());
        }
        return false;
    }

    @Override
    public Serializable saveState() {
        return this.expression;
    }

    @Override
    public void restoreState(Serializable state) {
        this.expression = state == null ? null : (String)((Object)state);
    }

    @Override
    public void saveSettings(HierarchicalConfiguration configuration) {
        super.saveSettings(configuration);
        if (this.expression == null) {
            return;
        }
        configuration.addProperty(NAME, (Object)this.expression);
    }

    @Override
    public void restoreSettings(HierarchicalConfiguration configuration) {
        this.expression = configuration.getString(NAME);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("eval(");
        if (this.expression != null) {
            builder.append(this.expression);
        }
        builder.append(")");
        return builder.toString();
    }
}

