/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.ui.condition;

import java.io.Serializable;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.pivot4j.ui.RenderContext;
import org.pivot4j.ui.condition.AbstractCondition;
import org.pivot4j.ui.condition.ConditionFactory;

public class CellTypeCondition
extends AbstractCondition {
    public static final String NAME = "cellType";
    private String cellType;

    public CellTypeCondition(ConditionFactory conditionFactory) {
        super(conditionFactory);
    }

    public CellTypeCondition(ConditionFactory conditionFactory, String cellType) {
        super(conditionFactory);
        this.cellType = cellType;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public String getCellType() {
        return this.cellType;
    }

    public void setCellType(String cellType) {
        this.cellType = cellType;
    }

    @Override
    public boolean matches(RenderContext context) {
        if (this.cellType == null) {
            throw new IllegalStateException("CELL type was not specified.");
        }
        return this.cellType == context.getCellType();
    }

    @Override
    public Serializable saveState() {
        if (this.cellType == null) {
            return null;
        }
        return this.cellType;
    }

    @Override
    public void restoreState(Serializable state) {
        this.cellType = state == null ? null : (String)((Object)state);
    }

    @Override
    public void saveSettings(HierarchicalConfiguration configuration) {
        super.saveSettings(configuration);
        if (this.cellType == null) {
            return;
        }
        configuration.setProperty("value", (Object)this.cellType);
    }

    @Override
    public void restoreSettings(HierarchicalConfiguration configuration) {
        String value = configuration.getString("value");
        this.cellType = value == null ? null : value;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getName() + " = ");
        if (this.cellType == null) {
            builder.append("[MISSING]");
        } else {
            builder.append(this.cellType);
        }
        return builder.toString();
    }
}

