/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.ui.condition;

import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.pivot4j.ui.RenderContext;
import org.pivot4j.ui.condition.AbstractCondition;
import org.pivot4j.ui.condition.Condition;
import org.pivot4j.ui.condition.ConditionFactory;

public class AndCondition
extends AbstractCondition {
    public static final String NAME = "and";
    private List<Condition> subConditions;

    public AndCondition(ConditionFactory conditionFactory) {
        super(conditionFactory);
    }

    public AndCondition(ConditionFactory conditionFactory, Condition ... subConditions) {
        super(conditionFactory);
        if (subConditions != null) {
            this.subConditions = new LinkedList<Condition>(Arrays.asList(subConditions));
        }
    }

    public AndCondition(ConditionFactory conditionFactory, List<Condition> subConditions) {
        super(conditionFactory);
        this.subConditions = subConditions;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public List<Condition> getSubConditions() {
        return this.subConditions;
    }

    public void setSubConditions(List<Condition> subConditions) {
        this.subConditions = subConditions;
    }

    @Override
    public boolean matches(RenderContext context) {
        if (this.subConditions == null || this.subConditions.isEmpty()) {
            throw new IllegalStateException("Missing sub conditions.");
        }
        for (Condition condition : this.subConditions) {
            if (condition.matches(context)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Serializable saveState() {
        if (this.subConditions == null) {
            return null;
        }
        Serializable[] states = new Serializable[this.subConditions.size()];
        int index = 0;
        for (Condition condition : this.subConditions) {
            states[index++] = new Serializable[]{condition.getName(), condition.saveState()};
        }
        return states;
    }

    @Override
    public void restoreState(Serializable state) {
        Serializable[] states = (Serializable[])state;
        this.subConditions = new LinkedList<Condition>();
        if (states != null) {
            for (Serializable subState : states) {
                Serializable[] subStates = (Serializable[])subState;
                Condition condition = this.getConditionFactory().createCondition((String)((Object)subStates[0]));
                condition.restoreState(subStates[1]);
                this.subConditions.add(condition);
            }
        }
    }

    @Override
    public void saveSettings(HierarchicalConfiguration configuration) {
        super.saveSettings(configuration);
        if (this.subConditions == null) {
            return;
        }
        int index = 0;
        for (Condition condition : this.subConditions) {
            String name = String.format("condition(%s)", index++);
            configuration.setProperty(name, (Object)"");
            SubnodeConfiguration subConfig = configuration.configurationAt(name);
            condition.saveSettings((HierarchicalConfiguration)subConfig);
        }
    }

    @Override
    public void restoreSettings(HierarchicalConfiguration configuration) {
        this.subConditions = new LinkedList<Condition>();
        try {
            List subConfigs = configuration.configurationsAt("condition");
            for (HierarchicalConfiguration subConfig : subConfigs) {
                String name = subConfig.getString("[@name]");
                if (name == null) continue;
                Condition condition = this.getConditionFactory().createCondition(name);
                condition.restoreSettings(subConfig);
                this.subConditions.add(condition);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        if (this.subConditions != null) {
            boolean first = true;
            for (Condition condition : this.subConditions) {
                if (first) {
                    first = false;
                } else {
                    builder.append(" && ");
                }
                builder.append(condition.toString());
            }
        }
        builder.append(")");
        return builder.toString();
    }
}

