/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.ui.command;

import java.util.List;
import org.olap4j.CellSet;
import org.olap4j.CellSetAxis;
import org.olap4j.metadata.Hierarchy;
import org.pivot4j.PivotModel;
import org.pivot4j.transform.DrillReplace;
import org.pivot4j.transform.PlaceHierarchiesOnAxes;
import org.pivot4j.ui.PivotRenderer;
import org.pivot4j.ui.RenderContext;
import org.pivot4j.ui.command.AbstractDrillDownCommand;
import org.pivot4j.ui.command.UICommandParameters;

public class DrillUpReplaceCommand
extends AbstractDrillDownCommand {
    public static final String NAME = "drillUp";

    public DrillUpReplaceCommand(PivotRenderer<?> renderer) {
        super(renderer);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getMode(RenderContext context) {
        return "replace";
    }

    @Override
    public boolean canExecute(RenderContext context) {
        if (!super.canExecute(context)) {
            return false;
        }
        PivotModel model = context.getModel();
        DrillReplace transform = model.getTransform(DrillReplace.class);
        Hierarchy hierarchy = context.getHierarchy();
        if (hierarchy == null || context.getProperty() != null) {
            return false;
        }
        return transform.canDrillUp(hierarchy);
    }

    @Override
    public UICommandParameters createParameters(RenderContext context) {
        PlaceHierarchiesOnAxes transform = context.getModel().getTransform(PlaceHierarchiesOnAxes.class);
        List<Hierarchy> hierarchies = transform.findVisibleHierarchies(context.getAxis());
        UICommandParameters parameters = new UICommandParameters();
        parameters.setAxisOrdinal(context.getAxis().axisOrdinal());
        parameters.setHierarchyOrdinal(hierarchies.indexOf(context.getHierarchy()));
        return parameters;
    }

    @Override
    public Void execute(PivotModel model, UICommandParameters parameters) {
        CellSet cellSet = model.getCellSet();
        CellSetAxis axis = (CellSetAxis)cellSet.getAxes().get(parameters.getAxisOrdinal());
        PlaceHierarchiesOnAxes transform = model.getTransform(PlaceHierarchiesOnAxes.class);
        List<Hierarchy> hierarchies = transform.findVisibleHierarchies(axis.getAxisOrdinal());
        Hierarchy hierarchy = hierarchies.get(parameters.getHierarchyOrdinal());
        DrillReplace drillTransform = model.getTransform(DrillReplace.class);
        drillTransform.drillUp(hierarchy);
        return null;
    }
}

