/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.ui.command;

import org.pivot4j.sort.SortMode;
import org.pivot4j.ui.PivotRenderer;
import org.pivot4j.ui.RenderContext;
import org.pivot4j.ui.command.AbstractUICommand;
import org.pivot4j.ui.command.SortCommand;
import org.pivot4j.ui.command.UICommandParameters;

public abstract class AbstractSortCommand
extends AbstractUICommand<Void>
implements SortCommand {
    public AbstractSortCommand(PivotRenderer<?> renderer) {
        super(renderer);
    }

    @Override
    public String getMode(RenderContext context) {
        StringBuilder builder;
        block9: {
            block8: {
                builder = new StringBuilder();
                SortMode mode = this.getRenderer().getSortMode();
                if (mode != null) {
                    builder.append(mode.getName());
                    builder.append('-');
                }
                if (!context.getModel().isSorting()) break block8;
                if (context.getPosition() == null || !context.getModel().isSorting(context.getPosition())) {
                    builder.append("other");
                } else {
                    builder.append("current");
                }
                builder.append('-');
                switch (context.getModel().getSortCriteria()) {
                    case ASC: 
                    case BASC: 
                    case TOPCOUNT: {
                        builder.append("up");
                        break block9;
                    }
                    case DESC: 
                    case BDESC: 
                    case BOTTOMCOUNT: {
                        builder.append("down");
                        break block9;
                    }
                    default: {
                        assert (false);
                        break block9;
                    }
                }
            }
            builder.append("natural");
        }
        return builder.toString();
    }

    @Override
    public UICommandParameters createParameters(RenderContext context) {
        UICommandParameters parameters = new UICommandParameters();
        parameters.setAxisOrdinal(context.getAxis().axisOrdinal());
        parameters.setPositionOrdinal(context.getPosition().getOrdinal());
        parameters.setMemberOrdinal(context.getPosition().getMembers().indexOf(context.getMember()));
        return parameters;
    }

    @Override
    public boolean canExecute(RenderContext context) {
        return this.getRenderer().getEnableSort() && context.getPosition() != null && context.getMember() != null && context.getAggregator() == null && context.getPosition().getMembers().indexOf(context.getMember()) == context.getPosition().getMembers().size() - 1 && context.getModel().isSortable(context.getPosition());
    }
}

