/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.ui.collector;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.NullArgumentException;
import org.olap4j.metadata.Level;
import org.olap4j.metadata.NamedList;
import org.olap4j.metadata.Property;
import org.pivot4j.ui.collector.PropertyCollector;

public class ConfigurablePropertyCollector
implements PropertyCollector,
Serializable {
    private static final long serialVersionUID = -2831138114754450877L;
    private List<String> propertyNames;

    public ConfigurablePropertyCollector(List<String> propertyNames) {
        if (propertyNames == null) {
            throw new NullArgumentException("propertyNames");
        }
        this.propertyNames = propertyNames;
    }

    protected List<String> getPropertyNames() {
        return this.propertyNames;
    }

    @Override
    public List<Property> getProperties(Level level) {
        ArrayList<Property> selection = new ArrayList<Property>(this.propertyNames.size());
        NamedList properties = level.getProperties();
        for (String name : this.propertyNames) {
            Property property = (Property)properties.get(name);
            if (property == null) continue;
            selection.add(property);
        }
        return selection;
    }
}

