/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.ui.chart;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.lang.NullArgumentException;
import org.olap4j.Axis;
import org.olap4j.Cell;
import org.olap4j.CellSet;
import org.olap4j.CellSetAxis;
import org.olap4j.OlapException;
import org.olap4j.Position;
import org.olap4j.metadata.Hierarchy;
import org.olap4j.metadata.Member;
import org.olap4j.metadata.MetadataElement;
import org.pivot4j.PivotException;
import org.pivot4j.PivotModel;
import org.pivot4j.ui.AbstractPivotRenderer;
import org.pivot4j.ui.chart.ChartRenderCallback;
import org.pivot4j.ui.chart.ChartRenderContext;
import org.pivot4j.util.OlapUtils;
import org.pivot4j.util.TreeNode;
import org.pivot4j.util.TreeNodeCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChartRenderer
extends AbstractPivotRenderer<ChartRenderContext, ChartRenderCallback> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String DEFAULT_MEMBER_SEPARATOR = " / ";
    private static final String UNUSED_AXIS = "none";
    private Axis pageAxis = Axis.COLUMNS;
    private Axis chartAxis = Axis.COLUMNS;
    private Axis seriesAxis = Axis.ROWS;
    private Axis plotAxis = Axis.ROWS;
    private String memberSeparator = " / ";

    public String getMemberSeparator() {
        return this.memberSeparator;
    }

    public void setMemberSeparator(String memberSeparator) {
        this.memberSeparator = memberSeparator;
    }

    public Axis getPageAxis() {
        return this.pageAxis;
    }

    public void setPageAxis(Axis pageAxis) {
        this.pageAxis = pageAxis;
    }

    public Axis getChartAxis() {
        return this.chartAxis;
    }

    public void setChartAxis(Axis chartAxis) {
        this.chartAxis = chartAxis;
    }

    public Axis getSeriesAxis() {
        return this.seriesAxis;
    }

    public void setSeriesAxis(Axis seriesAxis) {
        this.seriesAxis = seriesAxis;
    }

    public Axis getPlotAxis() {
        return this.plotAxis;
    }

    public void setPlotAxis(Axis plotAxis) {
        this.plotAxis = plotAxis;
    }

    @Override
    public void render(PivotModel model, ChartRenderCallback callback) {
        if (model == null) {
            throw new NullArgumentException("model");
        }
        if (callback == null) {
            throw new NullArgumentException("callback");
        }
        CellSet cellSet = model.getCellSet();
        if (cellSet == null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Cell set is empty.");
            }
            return;
        }
        List axes = cellSet.getAxes();
        if (axes.size() != 2) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Not enough axes.");
            }
            return;
        }
        CellSetAxis columnAxis = (CellSetAxis)axes.get(Axis.COLUMNS.axisOrdinal());
        CellSetAxis rowAxis = (CellSetAxis)axes.get(Axis.ROWS.axisOrdinal());
        if (columnAxis == null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Column axis is missing.");
            }
            return;
        }
        if (rowAxis == null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Row axis is missing.");
            }
            return;
        }
        List columnPositions = columnAxis.getPositions();
        List rowPositions = rowAxis.getPositions();
        PlotNode columnRoot = new PlotNode();
        int maxColumnLevel = 0;
        for (Position columnPosition : columnPositions) {
            PlotNode node = columnRoot.addPositionNodes(columnPosition);
            maxColumnLevel = Math.max(maxColumnLevel, node.getLevel());
        }
        PlotNode rowRoot = new PlotNode();
        int maxRowLevel = 0;
        for (Position rowPosition : rowPositions) {
            PlotNode node = rowRoot.addPositionNodes(rowPosition);
            maxRowLevel = Math.max(maxRowLevel, node.getLevel());
        }
        ChartRenderContext context = new ChartRenderContext(model, this);
        callback.startRender(context);
        PagePartRenderer pagePart = new PagePartRenderer(this.pageAxis, callback);
        ChartPartRenderer chartPart = new ChartPartRenderer(this.chartAxis, callback);
        SeriesPartRenderer seriesPart = new SeriesPartRenderer(this.seriesAxis, callback);
        PlotPartRenderer plotPart = new PlotPartRenderer(this.plotAxis, callback);
        pagePart.setChildRenderer(chartPart);
        chartPart.setChildRenderer(seriesPart);
        seriesPart.setChildRenderer(plotPart);
        HashMap<Axis, PlotNode> nodeContext = new HashMap<Axis, PlotNode>(2);
        nodeContext.put((Axis)Axis.ROWS, rowRoot);
        nodeContext.put((Axis)Axis.COLUMNS, columnRoot);
        pagePart.render(context, nodeContext);
        context.setPageCount(pagePart.getRenderCount());
        context.setChartCount(chartPart.getRenderCount());
        context.setSeriesCount(seriesPart.getRenderCount());
        context.setPlotCount(plotPart.getRenderCount());
        pagePart.setDryRun(false);
        pagePart.render(context, nodeContext);
        context.setAxis(null);
        context.setPosition(null);
        context.setColumnPosition(null);
        context.setRowPosition(null);
        context.setHierarchy(null);
        context.setMember(null);
        context.setCell(null);
        context.setPagePath(Collections.<Member>emptyList());
        context.setChartPath(Collections.<Member>emptyList());
        context.setSeriesPath(Collections.<Member>emptyList());
        context.setPlotPath(Collections.<Member>emptyList());
        callback.endRender(context);
    }

    @Override
    protected String getLabel(List<Member> members) {
        int size = members.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return this.getLabel(members.get(0));
        }
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (Member member : members) {
            if (first) {
                first = false;
            } else {
                builder.append(this.memberSeparator);
            }
            builder.append(this.getLabel(member));
        }
        return builder.toString();
    }

    @Override
    protected String getLabel(Member member) {
        return member.getCaption();
    }

    @Override
    protected String getLabel(ChartRenderContext context) {
        return this.getLabel(context.getPlotPath());
    }

    @Override
    protected Double getValue(ChartRenderContext context) {
        Double value = null;
        Cell cell = context.getCell();
        if (cell != null && !cell.isEmpty()) {
            try {
                value = cell.getDoubleValue();
            }
            catch (OlapException e) {
                throw new PivotException(e);
            }
        }
        return value;
    }

    @Override
    public Serializable saveState() {
        Serializable[] states = new Serializable[6];
        int index = 0;
        states[index++] = super.saveState();
        states[index++] = this.pageAxis == null ? Integer.valueOf(-1) : Integer.valueOf(this.pageAxis.axisOrdinal());
        states[index++] = this.chartAxis == null ? Integer.valueOf(-1) : Integer.valueOf(this.chartAxis.axisOrdinal());
        states[index++] = this.seriesAxis == null ? Integer.valueOf(-1) : Integer.valueOf(this.seriesAxis.axisOrdinal());
        states[index++] = this.plotAxis == null ? Integer.valueOf(-1) : Integer.valueOf(this.plotAxis.axisOrdinal());
        states[index++] = this.memberSeparator;
        return states;
    }

    @Override
    public void restoreState(Serializable state) {
        Serializable[] states = (Serializable[])state;
        int index = 0;
        super.restoreState(states[index++]);
        int ordinal = (Integer)states[index++];
        this.pageAxis = ordinal > -1 ? Axis.Factory.forOrdinal((int)ordinal) : null;
        ordinal = (Integer)states[index++];
        this.chartAxis = ordinal > -1 ? Axis.Factory.forOrdinal((int)ordinal) : null;
        ordinal = (Integer)states[index++];
        this.seriesAxis = ordinal > -1 ? Axis.Factory.forOrdinal((int)ordinal) : null;
        ordinal = (Integer)states[index++];
        this.plotAxis = ordinal > -1 ? Axis.Factory.forOrdinal((int)ordinal) : null;
        this.memberSeparator = (String)((Object)states[index++]);
    }

    @Override
    public void saveSettings(HierarchicalConfiguration configuration) {
        super.saveSettings(configuration);
        configuration.addProperty("mappings.page[@axis]", (Object)(this.pageAxis == null ? UNUSED_AXIS : this.pageAxis.name()));
        configuration.addProperty("mappings.chart[@axis]", (Object)(this.chartAxis == null ? UNUSED_AXIS : this.chartAxis.name()));
        configuration.addProperty("mappings.series[@axis]", (Object)(this.seriesAxis == null ? UNUSED_AXIS : this.seriesAxis.name()));
        configuration.addProperty("mappings.plot[@axis]", (Object)(this.plotAxis == null ? UNUSED_AXIS : this.plotAxis.name()));
        if (!DEFAULT_MEMBER_SEPARATOR.equals(this.memberSeparator)) {
            configuration.addProperty("member-separator", (Object)this.memberSeparator);
        }
    }

    @Override
    public void restoreSettings(HierarchicalConfiguration configuration) {
        super.restoreSettings(configuration);
        this.pageAxis = this.readAxisMapping("page", configuration, (Axis)Axis.COLUMNS);
        this.chartAxis = this.readAxisMapping("chart", configuration, (Axis)Axis.COLUMNS);
        this.seriesAxis = this.readAxisMapping("series", configuration, (Axis)Axis.ROWS);
        this.plotAxis = this.readAxisMapping("plot", configuration, (Axis)Axis.ROWS);
        this.memberSeparator = configuration.getString("member-separator", DEFAULT_MEMBER_SEPARATOR);
    }

    private Axis readAxisMapping(String name, HierarchicalConfiguration configuration, Axis defaultValue) {
        Axis axis = defaultValue;
        String axisName = configuration.getString("mappings." + name + "[@axis]");
        if (UNUSED_AXIS.equals(axisName)) {
            axis = null;
        } else if (axisName != null) {
            axis = Axis.Factory.forOrdinal((int)Axis.Standard.valueOf((String)axisName).axisOrdinal());
        }
        return axis;
    }

    class PlotPartRenderer
    extends PartRenderer {
        PlotPartRenderer(Axis axis, ChartRenderCallback callback) {
            super(axis, callback);
        }

        @Override
        protected void renderContent(ChartRenderContext context, Map<Axis, PlotNode> nodeContext) {
            super.renderContent(context, nodeContext);
            if (!this.isDryRun()) {
                String label = ChartRenderer.this.getLabel(context.getPlotPath());
                ChartRenderCallback callback = this.getCallback();
                callback.renderCommands(context, ChartRenderer.this.getCommands(context));
                callback.renderContent(context, label, ChartRenderer.this.getValue(context));
            }
        }

        @Override
        protected void updateContext(ChartRenderContext context, Map<Axis, PlotNode> nodeContext, PlotNode contextNode) {
            super.updateContext(context, nodeContext, contextNode);
            context.setPlotIndex(this.getRenderIndex());
            if (this.isDryRun()) {
                return;
            }
            if (contextNode == null) {
                context.setHierarchy(null);
                context.setMember(null);
                context.setPosition(null);
                context.setColumnPosition(null);
                context.setRowPosition(null);
                context.setCell(null);
                context.setPlotPath(Collections.<Member>emptyList());
            } else {
                Position rowPosition;
                Position columnPosition;
                if (OlapUtils.equals(this.getAxis(), (Axis)Axis.COLUMNS)) {
                    columnPosition = contextNode.getPosition();
                    rowPosition = nodeContext.get(Axis.ROWS).getPosition();
                } else if (OlapUtils.equals(this.getAxis(), (Axis)Axis.ROWS)) {
                    columnPosition = nodeContext.get(Axis.COLUMNS).getPosition();
                    rowPosition = contextNode.getPosition();
                } else {
                    return;
                }
                CellSet cellSet = context.getCellSet();
                Cell cell = cellSet.getCell(new Position[]{columnPosition, rowPosition});
                Member member = (Member)contextNode.getReference();
                Hierarchy hierarchy = member.getHierarchy();
                context.setHierarchy(hierarchy);
                context.setMember(member);
                context.setPosition(contextNode.getPosition());
                context.setColumnPosition(columnPosition);
                context.setRowPosition(rowPosition);
                context.setCell(cell);
                LinkedList<Member> path = new LinkedList<Member>(contextNode.getPath());
                for (Member m : context.getPagePath()) {
                    path.remove(m);
                }
                for (Member m : context.getChartPath()) {
                    path.remove(m);
                }
                for (Member m : context.getSeriesPath()) {
                    path.remove(m);
                }
                context.setPlotPath(path);
            }
        }
    }

    class SeriesPartRenderer
    extends PartRenderer {
        SeriesPartRenderer(Axis axis, ChartRenderCallback callback) {
            super(axis, callback);
        }

        @Override
        protected void renderStart(ChartRenderContext context, Map<Axis, PlotNode> nodeContext) {
            super.renderStart(context, nodeContext);
            if (!this.isDryRun()) {
                this.getCallback().startSeries(context);
            }
        }

        @Override
        protected void renderEnd(ChartRenderContext context, Map<Axis, PlotNode> nodeContext) {
            super.renderEnd(context, nodeContext);
            if (!this.isDryRun()) {
                this.getCallback().endSeries(context);
            }
        }

        @Override
        protected void updateContext(ChartRenderContext context, Map<Axis, PlotNode> nodeContext, PlotNode contextNode) {
            super.updateContext(context, nodeContext, contextNode);
            context.setSeriesIndex(this.getRenderIndex());
            if (this.isDryRun()) {
                return;
            }
            if (contextNode == null) {
                context.setSeriesPath(Collections.<Member>emptyList());
            } else {
                LinkedList<Member> path = new LinkedList<Member>(contextNode.getPath());
                for (Member member : context.getPagePath()) {
                    path.remove(member);
                }
                for (Member member : context.getChartPath()) {
                    path.remove(member);
                }
                context.setSeriesPath(path);
            }
        }
    }

    class ChartPartRenderer
    extends PartRenderer {
        ChartPartRenderer(Axis axis, ChartRenderCallback callback) {
            super(axis, callback);
        }

        @Override
        protected void renderStart(ChartRenderContext context, Map<Axis, PlotNode> nodeContext) {
            super.renderStart(context, nodeContext);
            if (!this.isDryRun()) {
                this.getCallback().startChart(context);
            }
        }

        @Override
        protected void renderEnd(ChartRenderContext context, Map<Axis, PlotNode> nodeContext) {
            super.renderEnd(context, nodeContext);
            if (!this.isDryRun()) {
                this.getCallback().endChart(context);
            }
        }

        @Override
        protected void updateContext(ChartRenderContext context, Map<Axis, PlotNode> nodeContext, PlotNode contextNode) {
            super.updateContext(context, nodeContext, contextNode);
            context.setChartIndex(this.getRenderIndex());
            if (this.isDryRun()) {
                return;
            }
            if (contextNode == null) {
                context.setChartPath(Collections.<Member>emptyList());
            } else {
                LinkedList<Member> path = new LinkedList<Member>(contextNode.getPath());
                for (Member member : context.getPagePath()) {
                    path.remove(member);
                }
                context.setChartPath(path);
            }
        }
    }

    class PagePartRenderer
    extends PartRenderer {
        PagePartRenderer(Axis axis, ChartRenderCallback callback) {
            super(axis, callback);
        }

        @Override
        protected void renderStart(ChartRenderContext context, Map<Axis, PlotNode> nodeContext) {
            super.renderStart(context, nodeContext);
            if (!this.isDryRun()) {
                this.getCallback().startPage(context);
            }
        }

        @Override
        protected void renderEnd(ChartRenderContext context, Map<Axis, PlotNode> nodeContext) {
            super.renderEnd(context, nodeContext);
            if (!this.isDryRun()) {
                this.getCallback().endPage(context);
            }
        }

        @Override
        protected void updateContext(ChartRenderContext context, Map<Axis, PlotNode> nodeContext, PlotNode contextNode) {
            super.updateContext(context, nodeContext, contextNode);
            context.setPageIndex(this.getRenderIndex());
            if (this.isDryRun()) {
                return;
            }
            if (contextNode == null) {
                context.setPagePath(Collections.<Member>emptyList());
            } else {
                context.setPagePath(contextNode.getPath());
            }
        }
    }

    static abstract class PartRenderer {
        private Axis axis;
        private ChartRenderCallback callback;
        private PartRenderer childRenderer;
        private boolean dryRun = true;
        private int renderIndex = 0;
        private int renderCount = 0;

        PartRenderer(Axis axis, ChartRenderCallback callback) {
            this.axis = axis;
            this.callback = callback;
        }

        public Axis getAxis() {
            return this.axis;
        }

        public ChartRenderCallback getCallback() {
            return this.callback;
        }

        public PartRenderer getChildRenderer() {
            return this.childRenderer;
        }

        public void setChildRenderer(PartRenderer childRenderer) {
            this.childRenderer = childRenderer;
        }

        public boolean isDryRun() {
            return this.dryRun;
        }

        public void setDryRun(boolean dryRun) {
            this.dryRun = dryRun;
            if (this.childRenderer != null) {
                this.childRenderer.setDryRun(dryRun);
            }
        }

        public int getRenderIndex() {
            return this.renderIndex;
        }

        public int getRenderCount() {
            return this.renderCount;
        }

        public void reset() {
            this.renderIndex = 0;
            this.renderCount = 0;
        }

        protected int getRendererCount(Axis axis) {
            int count = 0;
            if (OlapUtils.equals(axis, this.axis)) {
                ++count;
            }
            if (this.childRenderer != null) {
                count += this.childRenderer.getRendererCount(axis);
            }
            return count;
        }

        public void render(final ChartRenderContext context, final Map<Axis, PlotNode> nodeContext) {
            boolean contextAvailable;
            this.resetContext(context);
            context.setAxis(this.axis);
            PlotNode contextNode = null;
            if (this.axis != null) {
                contextNode = nodeContext.get(this.axis);
            }
            int level = 1;
            if (contextNode == null) {
                contextAvailable = false;
            } else {
                int count = this.getRendererCount(this.axis);
                int maxDepth = contextNode.getMaxDescendantLevel();
                level = maxDepth - count + 1;
                boolean bl = contextAvailable = maxDepth >= count;
            }
            if (contextAvailable) {
                TreeNodeCallback<Member> handler = new TreeNodeCallback<Member>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public int handleTreeNode(TreeNode<Member> node) {
                        PlotNode plotNode = (PlotNode)node;
                        PlotNode originalContext = (PlotNode)nodeContext.get(PartRenderer.this.axis);
                        try {
                            nodeContext.put(PartRenderer.this.axis, plotNode);
                            PartRenderer.this.updateContext(context, nodeContext, plotNode);
                            PartRenderer.this.renderStart(context, nodeContext);
                            PartRenderer.this.renderContent(context, nodeContext);
                            PartRenderer.this.updateContext(context, nodeContext, plotNode);
                            PartRenderer.this.renderEnd(context, nodeContext);
                            PartRenderer.this.updateContext(context, nodeContext, null);
                        }
                        finally {
                            nodeContext.put(PartRenderer.this.axis, originalContext);
                        }
                        return 0;
                    }
                };
                if (contextNode != null) {
                    contextNode.walkChildrenAtLevel(handler, level);
                }
            } else {
                this.updateContext(context, nodeContext, null);
                this.renderStart(context, nodeContext);
                this.renderContent(context, nodeContext);
                this.updateContext(context, nodeContext, null);
                this.renderEnd(context, nodeContext);
            }
            context.setAxis(null);
        }

        protected void updateContext(ChartRenderContext context, Map<Axis, PlotNode> nodeContext, PlotNode contextNode) {
            if (this.getAxis() == null) {
                return;
            }
            Position position = null;
            if (contextNode != null) {
                position = contextNode.getPosition();
            }
            if (OlapUtils.equals(this.getAxis(), (Axis)Axis.COLUMNS)) {
                context.setColumnPosition(position);
            } else if (OlapUtils.equals(this.getAxis(), (Axis)Axis.ROWS)) {
                context.setRowPosition(position);
            }
        }

        protected void resetContext(ChartRenderContext context) {
            this.renderIndex = 0;
        }

        protected void renderStart(ChartRenderContext context, Map<Axis, PlotNode> nodeContext) {
            if (this.childRenderer != null) {
                this.childRenderer.resetContext(context);
            }
        }

        protected void renderContent(ChartRenderContext context, Map<Axis, PlotNode> nodeContext) {
            PartRenderer child = this.getChildRenderer();
            if (child != null) {
                child.render(context, nodeContext);
            }
        }

        protected void renderEnd(ChartRenderContext context, Map<Axis, PlotNode> nodeContext) {
            ++this.renderIndex;
            this.renderCount = Math.max(this.renderCount, this.renderIndex);
        }
    }

    static class PlotNode
    extends TreeNode<Member> {
        private Position position;
        private Cell cell;

        public PlotNode() {
        }

        public PlotNode(Member member, Position position) {
            super(member);
            this.position = position;
        }

        public PlotNode addPositionNodes(Position position) {
            TreeNode child;
            PlotNode node;
            Member member;
            PlotNode targetNode = null;
            int depth = this.getLevel() - 1;
            if (depth > -1) {
                member = (Member)position.getMembers().get(depth);
                if (!OlapUtils.equals((MetadataElement)member, (MetadataElement)this.getReference())) {
                    return null;
                }
                if (depth == position.getMembers().size() - 1) {
                    return this;
                }
            }
            member = this.getChildren().iterator();
            while (member.hasNext() && (targetNode = (node = (PlotNode)(child = (TreeNode)member.next())).addPositionNodes(position)) == null) {
            }
            if (targetNode == null) {
                PlotNode child2 = new PlotNode((Member)position.getMembers().get(depth + 1), position);
                this.addChild(child2);
                targetNode = child2.addPositionNodes(position);
            }
            return targetNode;
        }

        public Position getPosition() {
            return this.position;
        }

        public Cell getCell() {
            return this.cell;
        }

        public void setCell(Cell cell) {
            this.cell = cell;
        }

        public Double getValue() {
            Double value = 0.0;
            if (this.cell != null && !this.cell.isEmpty()) {
                try {
                    value = this.cell.getDoubleValue();
                }
                catch (OlapException e) {
                    throw new PivotException(e);
                }
            }
            for (TreeNode child : this.getChildren()) {
                PlotNode node = (PlotNode)child;
                Double nodeValue = node.getValue();
                if (nodeValue == null) continue;
                value = value + nodeValue;
            }
            return value;
        }

        public List<Member> getPath() {
            PlotNode parent = (PlotNode)this.getParent();
            if (parent == null) {
                return new LinkedList<Member>();
            }
            List<Member> path = parent.getPath();
            path.add((Member)this.getReference());
            return path;
        }

        public int walkChildrenAtLevel(TreeNodeCallback<Member> callbackHandler, int level) {
            int code;
            int nodeLevel = this.getLevel();
            if (nodeLevel == level) {
                callbackHandler.handleTreeNode(this);
                code = 1;
            } else if (nodeLevel < level) {
                for (TreeNode child : this.getChildren()) {
                    PlotNode childNode = (PlotNode)child;
                    childNode.walkChildrenAtLevel(callbackHandler, level);
                }
                code = 1;
            } else {
                code = 2;
            }
            return code;
        }
    }
}

