/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.ui.aggregator;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.NullArgumentException;
import org.olap4j.Axis;
import org.olap4j.metadata.Level;
import org.olap4j.metadata.Measure;
import org.olap4j.metadata.Member;
import org.pivot4j.ui.aggregator.AbstractAggregator;
import org.pivot4j.ui.aggregator.Aggregator;
import org.pivot4j.ui.aggregator.AggregatorFactory;
import org.pivot4j.ui.aggregator.AverageAggregator;
import org.pivot4j.ui.aggregator.CountAggregator;
import org.pivot4j.ui.aggregator.MaximumAggregator;
import org.pivot4j.ui.aggregator.MinimumAggregator;
import org.pivot4j.ui.aggregator.TotalAggregator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAggregatorFactory
implements AggregatorFactory {
    @Override
    public List<String> getAvailableAggregations() {
        LinkedList<String> names = new LinkedList<String>();
        names.add("SUM");
        names.add("AVG");
        names.add("MIN");
        names.add("MAX");
        names.add("CNT");
        return names;
    }

    @Override
    public Aggregator createAggregator(String name, Axis axis, List<Member> members, Level level, Measure measure) {
        Logger logger;
        if (name == null) {
            throw new NullArgumentException("name");
        }
        if (axis == null) {
            throw new NullArgumentException("axis");
        }
        AbstractAggregator aggregator = null;
        if ("SUM".equals(name)) {
            aggregator = new TotalAggregator(axis, members, level, measure);
        } else if ("AVG".equals(name)) {
            aggregator = new AverageAggregator(axis, members, level, measure);
        } else if ("MIN".equals(name)) {
            aggregator = new MinimumAggregator(axis, members, level, measure);
        } else if ("MAX".equals(name)) {
            aggregator = new MaximumAggregator(axis, members, level, measure);
        } else if ("CNT".equals(name)) {
            aggregator = new CountAggregator(axis, members, level, measure);
        }
        if (aggregator == null && (logger = LoggerFactory.getLogger(this.getClass())).isWarnEnabled()) {
            logger.warn("Unknown aggregator name : {}", (Object)name);
        }
        return aggregator;
    }
}

