/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.transform.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.olap4j.Axis;
import org.olap4j.CellSet;
import org.olap4j.CellSetAxis;
import org.olap4j.OlapConnection;
import org.olap4j.OlapException;
import org.olap4j.Position;
import org.olap4j.metadata.Hierarchy;
import org.olap4j.metadata.Member;
import org.olap4j.metadata.MetadataElement;
import org.pivot4j.PivotException;
import org.pivot4j.PivotModel;
import org.pivot4j.impl.PivotModelImpl;
import org.pivot4j.impl.Quax;
import org.pivot4j.impl.QuaxUtil;
import org.pivot4j.impl.QueryAdapter;
import org.pivot4j.mdx.Exp;
import org.pivot4j.mdx.FunCall;
import org.pivot4j.mdx.Syntax;
import org.pivot4j.mdx.metadata.MemberExp;
import org.pivot4j.transform.AbstractTransform;
import org.pivot4j.transform.PlaceMembersOnAxes;
import org.pivot4j.util.MemberHierarchyCache;
import org.pivot4j.util.MemberSelection;
import org.pivot4j.util.OlapUtils;
import org.pivot4j.util.TreeNode;
import org.pivot4j.util.TreeNodeCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlaceMembersOnAxesImpl
extends AbstractTransform
implements PlaceMembersOnAxes {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public PlaceMembersOnAxesImpl(QueryAdapter queryAdapter, OlapConnection connection) {
        super(queryAdapter, connection);
    }

    @Override
    public void placeMembers(Hierarchy hierarchy, List<Member> members) {
        QueryAdapter adapter = this.getQueryAdapter();
        Quax quax = adapter.findQuax(hierarchy.getDimension());
        if (quax == null) {
            throw new IllegalArgumentException("Cannot find the specified hierarchy on any axis.");
        }
        ArrayList<Member> selection = new ArrayList<Member>();
        List<Hierarchy> hierarchies = quax.getHierarchies();
        for (Hierarchy hier : hierarchies) {
            if (OlapUtils.equals((MetadataElement)hier, (MetadataElement)hierarchy)) {
                selection.addAll(members);
                continue;
            }
            selection.addAll(this.findVisibleMembers(hier));
        }
        int iAx = quax.getOrdinal();
        if (adapter.isAxesSwapped()) {
            iAx = (iAx + 1) % 2;
        }
        Axis axis = Axis.Factory.forOrdinal((int)iAx);
        this.placeMembers(axis, selection);
    }

    @Override
    public void placeMembers(Axis axis, List<Member> members) {
        QueryAdapter adapter = this.getQueryAdapter();
        Quax quax = adapter.getQuax(axis);
        if (quax == null) {
            quax = adapter.createQuax(axis);
        }
        ArrayList<Hierarchy> hierarchies = new ArrayList<Hierarchy>(members.size());
        HashMap<Hierarchy, ArrayList<Member>> memberMap = new HashMap<Hierarchy, ArrayList<Member>>(hierarchies.size());
        for (Member member : members) {
            ArrayList<Member> selection;
            Hierarchy hierarchy = member.getHierarchy();
            if (!hierarchies.contains(hierarchy)) {
                hierarchies.add(hierarchy);
            }
            if ((selection = (ArrayList<Member>)memberMap.get(hierarchy)) == null) {
                selection = new ArrayList<Member>(members.size());
                memberMap.put(hierarchy, selection);
            }
            if (selection.contains(member)) continue;
            selection.add(member);
        }
        OlapUtils utils = new OlapUtils(this.getModel().getCube());
        utils.setMemberHierarchyCache(this.getQueryAdapter().getModel().getMemberHierarchyCache());
        ArrayList<Exp> expressions = new ArrayList<Exp>(hierarchies.size());
        for (Hierarchy hierarchy : hierarchies) {
            List selection = (List)memberMap.get(hierarchy);
            ArrayList<Exp> sets = new ArrayList<Exp>(selection.size());
            if (selection.size() == 1) {
                expressions.add(new MemberExp(utils.wrapRaggedIfNecessary((Member)selection.get(0))));
                continue;
            }
            for (Member member : selection) {
                sets.add(new MemberExp(utils.wrapRaggedIfNecessary(member)));
            }
            expressions.add(new FunCall("{}", Syntax.Braces, sets));
        }
        quax.regeneratePosTree(expressions, true);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("setQueryAxis axis={}, nDimension={}", (Object)quax.getOrdinal(), (Object)hierarchies.size());
            this.logger.debug("Expression for the axis : {}", (Object)quax);
        }
    }

    @Override
    public void addMember(Member member, int position) {
        Hierarchy hierarchy = member.getHierarchy();
        ArrayList<Member> selection = new ArrayList<Member>(this.findVisibleMembers(hierarchy));
        if (selection.contains(member)) {
            this.moveMember(member, position);
            return;
        }
        if (position < 0 || position >= selection.size()) {
            selection.add(member);
        } else {
            selection.add(position, member);
        }
        this.placeMembers(hierarchy, selection);
    }

    @Override
    public void addMembers(Hierarchy hierarchy, List<Member> members) {
        if (members.isEmpty()) {
            return;
        }
        PlaceMembersOnAxes transform = this.getQueryAdapter().getModel().getTransform(PlaceMembersOnAxes.class);
        MemberSelection selection = new MemberSelection(transform.findVisibleMembers(hierarchy), this.getModel().getCube());
        selection.addMembers(members);
        if (this.getModel() instanceof PivotModelImpl) {
            MemberHierarchyCache cache = ((PivotModelImpl)this.getModel()).getMemberHierarchyCache();
            selection.setMemberHierarchyCache(cache);
        }
        this.placeMembers(hierarchy, selection.getMembers());
    }

    @Override
    public void addMember(Axis axis, Member member, int position) {
        QueryAdapter adapter = this.getQueryAdapter();
        Quax quax = adapter.findQuax(member.getDimension());
        if (quax == null) {
            quax = adapter.getQuax(axis);
            ArrayList<Object> hierarchies = quax == null ? new ArrayList() : new ArrayList<Hierarchy>(quax.getHierarchies());
            if (position < 0 || position >= hierarchies.size()) {
                hierarchies.add(member.getHierarchy());
            } else {
                hierarchies.add(position, member.getHierarchy());
            }
            ArrayList<Member> members = new ArrayList<Member>();
            for (Hierarchy hierarchy : hierarchies) {
                if (OlapUtils.equals((MetadataElement)member.getHierarchy(), (MetadataElement)hierarchy)) {
                    members.add(member);
                    continue;
                }
                members.addAll(this.findVisibleMembers(hierarchy));
            }
            this.placeMembers(axis, members);
        } else {
            this.addMember(member, position);
        }
    }

    @Override
    public void addMembers(Axis axis, List<Member> members, int position) {
        QueryAdapter adapter = this.getQueryAdapter();
        Quax quax = adapter.getQuax(axis);
        ArrayList<Hierarchy> hierarchies = new ArrayList<Hierarchy>(quax.getHierarchies());
        if (position < 0 || position >= hierarchies.size()) {
            hierarchies.add(null);
        } else {
            hierarchies.add(position, null);
        }
        ArrayList<Member> memberList = new ArrayList<Member>();
        for (Hierarchy hierarchy : hierarchies) {
            if (hierarchy == null) {
                memberList.addAll(members);
                continue;
            }
            memberList.addAll(this.findVisibleMembers(hierarchy));
        }
        this.placeMembers(axis, members);
    }

    @Override
    public void removeMember(Member member) {
        Hierarchy hierarchy = member.getHierarchy();
        ArrayList<Member> members = new ArrayList<Member>(this.findVisibleMembers(hierarchy));
        members.remove(member);
        this.placeMembers(hierarchy, members);
    }

    @Override
    public void removeMembers(Hierarchy hierarchy, List<Member> members) {
        ArrayList<Member> selection = new ArrayList<Member>(this.findVisibleMembers(hierarchy));
        selection.removeAll(members);
        this.placeMembers(hierarchy, selection);
    }

    @Override
    public void moveMember(Member member, int position) {
        Hierarchy hierarchy = member.getHierarchy();
        ArrayList<Member> selection = new ArrayList<Member>(this.findVisibleMembers(hierarchy));
        if (!selection.contains(member)) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("The specified member is not visible on the current result : {}", (Object)member.getUniqueName());
            }
            return;
        }
        if (position < 0 || position >= selection.size()) {
            selection.remove(member);
            selection.add(member);
        } else {
            int index = selection.indexOf(member);
            if (position < index) {
                selection.remove(member);
                selection.add(position, member);
            } else if (position > index) {
                selection.add(position, member);
                selection.remove(index);
            }
        }
        this.placeMembers(hierarchy, selection);
    }

    @Override
    public List<Member> findVisibleMembers(Axis axis) {
        ArrayList<Member> visibleMembers = new ArrayList<Member>();
        QueryAdapter adapter = this.getQueryAdapter();
        Quax quax = adapter.getQuax(axis);
        if (quax == null) {
            return Collections.emptyList();
        }
        CellSet cellSet = adapter.getModel().getCellSet();
        CellSetAxis cellAxis = this.getCellSetAxis(cellSet, axis);
        if (cellAxis == null) {
            MemberCollector collector = new MemberCollector(null);
            quax.getPosTreeRoot().walkTree(collector);
            return collector.getMembers();
        }
        List positions = cellAxis.getPositions();
        for (Position position : positions) {
            List members = position.getMembers();
            for (Member member : members) {
                if (member == null || visibleMembers.contains(member)) continue;
                visibleMembers.add(member);
            }
        }
        return visibleMembers;
    }

    @Override
    public List<Member> findVisibleMembers(Hierarchy hierarchy) {
        ArrayList<Member> visibleMembers = new ArrayList<Member>();
        QueryAdapter adapter = this.getQueryAdapter();
        Quax quax = adapter.findQuax(hierarchy.getDimension());
        if (quax == null) {
            return Collections.emptyList();
        }
        int iDim = quax.dimIdx(hierarchy.getDimension());
        Axis axis = Axis.Factory.forOrdinal((int)quax.getOrdinal());
        CellSet cellSet = adapter.getModel().getCellSet();
        CellSetAxis cellAxis = this.getCellSetAxis(cellSet, axis);
        if (cellAxis == null) {
            MemberCollector collector = new MemberCollector(hierarchy);
            quax.getPosTreeRoot().walkTree(collector);
            return collector.getMembers();
        }
        List positions = cellAxis.getPositions();
        for (Position position : positions) {
            List members = position.getMembers();
            Member member = (Member)members.get(iDim);
            if (member == null || visibleMembers.contains(member)) continue;
            visibleMembers.add(member);
        }
        return visibleMembers;
    }

    class MemberCollector
    implements TreeNodeCallback<Exp> {
        private QuaxUtil util;
        private List<Member> members = new LinkedList<Member>();
        private Hierarchy hierarchy;

        MemberCollector(Hierarchy hierarchy) {
            this.hierarchy = hierarchy;
            PivotModel model = PlaceMembersOnAxesImpl.this.getModel();
            this.util = model instanceof PivotModelImpl ? new QuaxUtil(model.getCube(), ((PivotModelImpl)model).getMemberHierarchyCache()) : new QuaxUtil(model.getCube());
        }

        @Override
        public int handleTreeNode(TreeNode<Exp> node) {
            Exp exp = node.getReference();
            if (exp != null) {
                this.addExp(exp);
            }
            return 0;
        }

        void addExp(Exp exp) {
            Exp arg;
            if (this.util.isMember(exp)) {
                this.addMember(this.util.memberForExp(exp));
            } else if (this.util.isFunCallTo(exp, "{}") || this.util.isFunCallTo(exp, "CrossJoin") || this.util.isFunCallTo(exp, "Hierarchize") || this.util.isFunCallTo(exp, "Union")) {
                FunCall func = (FunCall)exp;
                for (Exp arg2 : func.getArgs()) {
                    this.addExp(arg2);
                }
            } else if (this.util.isFunCallTo(exp, "Children") && this.util.isMember(arg = this.util.funCallArg(exp, 0))) {
                Member member = this.util.memberForExp(arg);
                try {
                    for (Member child : member.getChildMembers()) {
                        if (!OlapUtils.isVisible(child)) continue;
                        this.addMember(child);
                    }
                }
                catch (OlapException e) {
                    throw new PivotException(e);
                }
            }
        }

        void addMember(Member member) {
            if (!this.members.contains(member) && (this.hierarchy == null || OlapUtils.equals((MetadataElement)this.hierarchy, (MetadataElement)member.getHierarchy()))) {
                this.members.add(member);
            }
        }

        public List<Member> getMembers() {
            return Collections.unmodifiableList(this.members);
        }
    }
}

