/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.transform.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.olap4j.CellSet;
import org.olap4j.CellSetAxis;
import org.olap4j.OlapConnection;
import org.olap4j.OlapException;
import org.olap4j.Position;
import org.olap4j.metadata.Hierarchy;
import org.olap4j.metadata.Measure;
import org.olap4j.metadata.Member;
import org.olap4j.metadata.MetadataElement;
import org.pivot4j.PivotException;
import org.pivot4j.impl.QueryAdapter;
import org.pivot4j.mdx.Exp;
import org.pivot4j.mdx.FunCall;
import org.pivot4j.mdx.Syntax;
import org.pivot4j.mdx.metadata.MemberExp;
import org.pivot4j.transform.AbstractTransform;
import org.pivot4j.transform.ChangeSlicer;
import org.pivot4j.util.OlapUtils;

public class ChangeSlicerImpl
extends AbstractTransform
implements ChangeSlicer {
    public ChangeSlicerImpl(QueryAdapter queryAdapter, OlapConnection connection) {
        super(queryAdapter, connection);
    }

    @Override
    public List<Hierarchy> getHierarchies() {
        if (!this.getModel().isInitialized()) {
            return Collections.emptyList();
        }
        CellSet cellSet = this.getModel().getCellSet();
        if (cellSet == null) {
            return Collections.emptyList();
        }
        CellSetAxis slicer = cellSet.getFilterAxis();
        LinkedHashSet<Hierarchy> hierarchies = new LinkedHashSet<Hierarchy>();
        for (Position position : slicer.getPositions()) {
            for (Member member : position.getMembers()) {
                try {
                    if (OlapUtils.equals((MetadataElement)member, (MetadataElement)member.getHierarchy().getDefaultMember()) || member instanceof Measure || hierarchies.contains(member.getHierarchy())) continue;
                    hierarchies.add(member.getHierarchy());
                }
                catch (OlapException e) {
                    throw new PivotException(e);
                }
            }
        }
        return new LinkedList<Hierarchy>(hierarchies);
    }

    @Override
    public List<Member> getSlicer() {
        if (!this.getModel().isInitialized()) {
            return Collections.emptyList();
        }
        CellSet cellSet = this.getModel().getCellSet();
        CellSetAxis slicer = cellSet.getFilterAxis();
        List positions = slicer.getPositions();
        ArrayList<Member> members = new ArrayList<Member>();
        for (Position position : positions) {
            List posMembers = position.getMembers();
            for (Member posMember : posMembers) {
                if (members.contains(posMember)) continue;
                members.add(posMember);
            }
        }
        return members;
    }

    @Override
    public List<Member> getSlicer(Hierarchy hierarchy) {
        if (hierarchy == null) {
            return this.getSlicer();
        }
        CellSet cellSet = this.getModel().getCellSet();
        CellSetAxis slicer = cellSet.getFilterAxis();
        List positions = slicer.getPositions();
        ArrayList<Member> members = new ArrayList<Member>();
        for (Position position : positions) {
            List posMembers = position.getMembers();
            for (Member posMember : posMembers) {
                if (!OlapUtils.equals((MetadataElement)posMember.getHierarchy(), (MetadataElement)hierarchy) || members.contains(posMember)) continue;
                members.add(posMember);
            }
        }
        return members;
    }

    @Override
    public void setSlicer(List<Member> members) {
        Exp exp = null;
        if (members != null && !members.isEmpty()) {
            ArrayList<Hierarchy> hierarchies = new ArrayList<Hierarchy>(members.size());
            HashMap<Hierarchy, ArrayList<Member>> memberMap = new HashMap<Hierarchy, ArrayList<Member>>();
            for (Member member : members) {
                ArrayList<Member> hierarchyMembers;
                Hierarchy hierarchy = member.getHierarchy();
                if (!hierarchies.contains(hierarchy)) {
                    hierarchies.add(hierarchy);
                }
                if ((hierarchyMembers = (ArrayList<Member>)memberMap.get(hierarchy)) == null) {
                    hierarchyMembers = new ArrayList<Member>(members.size());
                    memberMap.put(hierarchy, hierarchyMembers);
                }
                hierarchyMembers.add(member);
            }
            if (hierarchies.size() == 1) {
                Hierarchy hierarchy = (Hierarchy)hierarchies.get(0);
                exp = this.createMemberSetExpression(hierarchy, (List)memberMap.get(hierarchy));
            } else {
                int index = 0;
                Exp[] sets = new Exp[2];
                for (Hierarchy hierarchy : hierarchies) {
                    Exp set = this.createMemberSetExpression(hierarchy, (List)memberMap.get(hierarchy));
                    if (set == null) continue;
                    if (index < 2) {
                        sets[index] = set;
                    } else {
                        sets[0] = new FunCall("CrossJoin", Syntax.Function, Arrays.asList(sets));
                        sets[1] = set;
                    }
                    ++index;
                }
                exp = new FunCall("CrossJoin", Syntax.Function, Arrays.asList(sets));
            }
        }
        this.getQueryAdapter().changeSlicer(exp);
    }

    @Override
    public void setSlicer(Hierarchy hierarchy, List<Member> members) {
        if (hierarchy == null) {
            this.setSlicer(members);
            return;
        }
        Exp exp = null;
        ArrayList<Hierarchy> hierarchies = new ArrayList<Hierarchy>();
        HashMap<Hierarchy, List<Member>> memberMap = new HashMap<Hierarchy, List<Member>>();
        List<Member> membersOnSlicer = this.getSlicer();
        if (membersOnSlicer != null && !membersOnSlicer.isEmpty()) {
            for (Member member : membersOnSlicer) {
                Hierarchy memberHierarchy = member.getHierarchy();
                if (!hierarchies.contains(memberHierarchy)) {
                    hierarchies.add(memberHierarchy);
                }
                if (OlapUtils.equals((MetadataElement)memberHierarchy, (MetadataElement)hierarchy)) continue;
                ArrayList<Member> hierarchyMembers = (ArrayList<Member>)memberMap.get(memberHierarchy);
                if (hierarchyMembers == null) {
                    hierarchyMembers = new ArrayList<Member>();
                    memberMap.put(memberHierarchy, hierarchyMembers);
                }
                hierarchyMembers.add(member);
            }
        }
        if (members == null || members.isEmpty()) {
            hierarchies.remove(hierarchy);
        } else {
            if (!hierarchies.contains(hierarchy)) {
                hierarchies.add(hierarchy);
            }
            memberMap.put(hierarchy, members);
        }
        int size = hierarchies.size();
        if (size == 1) {
            Hierarchy hier = (Hierarchy)hierarchies.get(0);
            exp = this.createMemberSetExpression(hier, (List)memberMap.get(hier));
        } else if (size > 1) {
            int index = 0;
            Exp[] sets = new Exp[2];
            for (Hierarchy hier : hierarchies) {
                Exp set = this.createMemberSetExpression(hier, (List)memberMap.get(hier));
                if (set == null) continue;
                if (index < 2) {
                    sets[index] = set;
                } else {
                    sets[0] = new FunCall("CrossJoin", Syntax.Function, Arrays.asList(sets));
                    sets[1] = set;
                }
                ++index;
            }
            exp = new FunCall("CrossJoin", Syntax.Function, Arrays.asList(sets));
        }
        this.getQueryAdapter().changeSlicer(exp);
    }

    protected Exp createMemberSetExpression(Hierarchy hierachy, List<Member> members) {
        if (members == null || members.isEmpty()) {
            return null;
        }
        OlapUtils utils = new OlapUtils(this.getModel().getCube());
        utils.setMemberHierarchyCache(this.getQueryAdapter().getModel().getMemberHierarchyCache());
        if (members.size() == 1) {
            return new MemberExp(utils.wrapRaggedIfNecessary(members.get(0)));
        }
        ArrayList<Exp> expressions = new ArrayList<Exp>(members.size());
        for (Member member : members) {
            expressions.add(new MemberExp(utils.wrapRaggedIfNecessary(member)));
        }
        return new FunCall("{}", Syntax.Braces, expressions);
    }
}

