/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.transform;

import org.apache.commons.lang.NullArgumentException;
import org.olap4j.Axis;
import org.olap4j.CellSet;
import org.olap4j.CellSetAxis;
import org.olap4j.OlapConnection;
import org.pivot4j.PivotModel;
import org.pivot4j.impl.QueryAdapter;
import org.pivot4j.transform.Transform;

public abstract class AbstractTransform
implements Transform {
    private QueryAdapter queryAdapter;
    private OlapConnection connection;

    public AbstractTransform(QueryAdapter queryAdapter, OlapConnection connection) {
        if (queryAdapter == null) {
            throw new NullArgumentException("queryAdapter");
        }
        if (connection == null) {
            throw new NullArgumentException("connection");
        }
        this.queryAdapter = queryAdapter;
        this.connection = connection;
    }

    @Override
    public PivotModel getModel() {
        return this.getQueryAdapter().getModel();
    }

    protected QueryAdapter getQueryAdapter() {
        return this.queryAdapter;
    }

    protected OlapConnection getConnection() {
        return this.connection;
    }

    protected CellSetAxis getCellSetAxis(CellSet cellSet, Axis axis) {
        Axis targetAxis = axis;
        if (this.queryAdapter.isAxesSwapped()) {
            if (axis == Axis.COLUMNS) {
                targetAxis = Axis.ROWS;
            } else if (axis == Axis.ROWS) {
                targetAxis = Axis.COLUMNS;
            }
        }
        CellSetAxis cellAxis = null;
        if (cellSet != null) {
            for (CellSetAxis item : cellSet.getAxes()) {
                if (item.getAxisOrdinal() != targetAxis) continue;
                cellAxis = item;
                break;
            }
        }
        return cellAxis;
    }
}

