/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.mdx;

import org.apache.commons.lang.ObjectUtils;
import org.olap4j.OlapException;
import org.olap4j.mdx.IdentifierNode;
import org.olap4j.metadata.Cube;
import org.olap4j.metadata.Member;
import org.pivot4j.PivotException;
import org.pivot4j.mdx.ExpVisitor;
import org.pivot4j.mdx.ExpressionParameter;

public class MemberParameter
extends ExpressionParameter {
    private static final long serialVersionUID = 7205831600041541541L;
    private transient Member member;

    public MemberParameter() {
    }

    public MemberParameter(String expression) {
        super(expression);
    }

    public Member getMember(Cube cube) {
        if (this.getResult() == null) {
            return null;
        }
        try {
            this.member = cube.lookupMember(IdentifierNode.parseIdentifier((String)this.getResult()).getSegmentList());
        }
        catch (OlapException e) {
            throw new PivotException(e);
        }
        return this.member;
    }

    @Override
    public void setResult(String result) {
        boolean changed = !ObjectUtils.equals((Object)this.getResult(), (Object)result);
        super.setResult(result);
        if (changed) {
            this.member = null;
        }
    }

    @Override
    public MemberParameter copy() {
        MemberParameter clone = new MemberParameter(this.getExpression());
        clone.setEvaluated(this.isEvaluated());
        clone.setResult(this.getResult());
        clone.member = this.member;
        return clone;
    }

    @Override
    public void accept(ExpVisitor visitor) {
        visitor.visitMemberParameter(this);
    }

    @Override
    protected String toMdx(String expression) {
        StringBuilder sb = new StringBuilder();
        sb.append("$[");
        if (expression != null) {
            sb.append(expression.replaceAll("]", "]]"));
        }
        sb.append("]");
        return sb.toString();
    }
}

