/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.mdx;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.olap4j.Axis;
import org.pivot4j.mdx.AbstractExp;
import org.pivot4j.mdx.CompoundId;
import org.pivot4j.mdx.Exp;
import org.pivot4j.mdx.ExpVisitor;
import org.pivot4j.mdx.Formula;
import org.pivot4j.mdx.QueryAxis;
import org.pivot4j.mdx.SapVariable;

public class MdxStatement
extends AbstractExp {
    private static final long serialVersionUID = 8608792548174831908L;
    private List<Formula> formulas = new ArrayList<Formula>();
    private List<QueryAxis> axes = new ArrayList<QueryAxis>();
    private Exp slicer;
    private CompoundId cube;
    private List<CompoundId> cellProperties = new ArrayList<CompoundId>();
    private List<SapVariable> sapVariables = new ArrayList<SapVariable>();
    private boolean axesSwapped = false;

    public List<Formula> getFormulas() {
        return this.formulas;
    }

    public List<QueryAxis> getAxes() {
        return this.axes;
    }

    public boolean isAxesSwapped() {
        return this.axesSwapped;
    }

    public void setAxesSwapped(boolean axesSwapped) {
        this.axesSwapped = axesSwapped;
    }

    public QueryAxis getAxis(Axis axis) {
        QueryAxis result = null;
        for (QueryAxis ax : this.axes) {
            if (axis != ax.getAxis()) continue;
            result = ax;
            break;
        }
        return result;
    }

    public void setAxis(QueryAxis axis) {
        this.removeAxis(axis.getAxis());
        this.axes.add(axis);
    }

    public void removeAxis(Axis axis) {
        Iterator<QueryAxis> it = this.axes.iterator();
        while (it.hasNext()) {
            QueryAxis ax = it.next();
            if (ax.getAxis() != axis) continue;
            it.remove();
        }
    }

    public CompoundId getCube() {
        return this.cube;
    }

    public void setCube(CompoundId cube) {
        this.cube = cube;
    }

    public Exp getSlicer() {
        return this.slicer;
    }

    public void setSlicer(Exp exp) {
        this.slicer = exp;
    }

    public List<CompoundId> getCellProperties() {
        return this.cellProperties;
    }

    public List<SapVariable> getSapVariables() {
        return this.sapVariables;
    }

    @Override
    public String toMdx() {
        StringBuilder mdx = new StringBuilder();
        if (!this.formulas.isEmpty()) {
            mdx.append("WITH");
            for (Formula element : this.formulas) {
                mdx.append(' ');
                mdx.append(element.toMdx());
            }
            mdx.append(' ');
        }
        mdx.append("SELECT");
        boolean following = false;
        for (QueryAxis qa : this.axes) {
            if (qa.getExp() == null) continue;
            if (following) {
                mdx.append(", ");
            } else {
                mdx.append(' ');
                following = true;
            }
            mdx.append(qa.toMdx());
        }
        mdx.append(" FROM ");
        mdx.append(this.cube);
        if (this.slicer != null) {
            mdx.append(" WHERE ");
            mdx.append(this.slicer.toMdx());
        }
        if (!this.cellProperties.isEmpty()) {
            mdx.append(" CELL PROPERTIES VALUE, FORMATTED_VALUE");
            for (CompoundId cid : this.cellProperties) {
                String str = cid.toMdx();
                if (str.equalsIgnoreCase("VALUE") || str.equalsIgnoreCase("FORMATTED_VALUE")) continue;
                mdx.append(" ,");
                mdx.append(str);
            }
        }
        if (!this.sapVariables.isEmpty()) {
            mdx.append(" SAP VARIABLES ");
            following = false;
            for (SapVariable sapVariable : this.sapVariables) {
                if (following) {
                    mdx.append(", ");
                } else {
                    following = true;
                }
                mdx.append(sapVariable.toMdx());
            }
        }
        return mdx.toString();
    }

    @Override
    public MdxStatement copy() {
        MdxStatement clone = new MdxStatement();
        if (!this.formulas.isEmpty()) {
            clone.formulas = new ArrayList<Formula>(this.formulas.size());
            for (Formula element : this.formulas) {
                clone.formulas.add(element.copy());
            }
        }
        clone.axes = new ArrayList<QueryAxis>(this.axes.size());
        for (QueryAxis axis : this.axes) {
            clone.axes.add(axis.copy());
        }
        if (this.cube != null) {
            clone.cube = this.cube.copy();
        }
        if (this.slicer != null) {
            clone.slicer = this.slicer.copy();
        }
        for (CompoundId property : this.cellProperties) {
            clone.cellProperties.add(property.copy());
        }
        for (SapVariable variable : this.sapVariables) {
            clone.sapVariables.add(variable.copy());
        }
        clone.axesSwapped = this.axesSwapped;
        return clone;
    }

    @Override
    public void accept(ExpVisitor visitor) {
        visitor.visitStatement(this);
        for (Formula element : this.formulas) {
            element.accept(visitor);
        }
        for (QueryAxis axis : this.axes) {
            axis.accept(visitor);
        }
        if (this.cube != null) {
            this.cube.accept(visitor);
        }
        if (this.slicer != null) {
            this.slicer.accept(visitor);
        }
        for (CompoundId property : this.cellProperties) {
            property.accept(visitor);
        }
        for (SapVariable variable : this.sapVariables) {
            variable.accept(visitor);
        }
    }
}

