/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.mdx;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import org.pivot4j.mdx.Exp;
import org.pivot4j.util.TreeNode;

public class ExpNode
extends TreeNode<Exp>
implements Serializable {
    private static final long serialVersionUID = 1956521185377274271L;

    protected ExpNode() {
    }

    public ExpNode(Exp exp) {
        super(exp);
    }

    @Override
    public void addChild(TreeNode<Exp> child) {
        if (!(child instanceof ExpNode)) {
            throw new IllegalArgumentException("Only ExpNode instance can be added as a child node.");
        }
        super.addChild(child);
    }

    public ExpNode deepCopy() {
        ExpNode newNode = new ExpNode((Exp)this.getReference());
        for (TreeNode child : this.getChildren()) {
            newNode.addChild(child.deepCopy());
        }
        return newNode;
    }

    public ExpNode deepCopyPrune(int depth) {
        if (depth < 0) {
            throw new IllegalArgumentException("Depth is negative");
        }
        ExpNode newNode = new ExpNode((Exp)this.getReference());
        if (depth == 0) {
            return newNode;
        }
        for (TreeNode child : this.getChildren()) {
            newNode.addChild(child.deepCopyPrune(depth - 1));
        }
        return newNode;
    }

    public ExpNode getParent() {
        return (ExpNode)super.getParent();
    }

    public ExpNode getRoot() {
        return (ExpNode)super.getRoot();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.setReference((Exp)in.readObject());
        List children = (List)in.readObject();
        for (TreeNode child : children) {
            this.addChild(child);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.getReference());
        out.writeObject(this.getChildren());
    }

    public String toString() {
        return ((Exp)this.getReference()).toMdx();
    }
}

