/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.olap4j.Axis;
import org.olap4j.CellSet;
import org.olap4j.CellSetAxis;
import org.olap4j.OlapException;
import org.olap4j.Position;
import org.olap4j.metadata.Dimension;
import org.olap4j.metadata.Hierarchy;
import org.olap4j.metadata.Member;
import org.pivot4j.PivotException;
import org.pivot4j.el.ExpressionEvaluator;
import org.pivot4j.impl.CalcSetMode;
import org.pivot4j.impl.PivotModelImpl;
import org.pivot4j.impl.Quax;
import org.pivot4j.impl.QuaxChangeEvent;
import org.pivot4j.impl.QuaxChangeListener;
import org.pivot4j.impl.QuaxUtil;
import org.pivot4j.impl.QueryChangeEvent;
import org.pivot4j.impl.QueryChangeListener;
import org.pivot4j.mdx.AbstractExpVisitor;
import org.pivot4j.mdx.CompoundId;
import org.pivot4j.mdx.Exp;
import org.pivot4j.mdx.ExpressionParameter;
import org.pivot4j.mdx.FunCall;
import org.pivot4j.mdx.Literal;
import org.pivot4j.mdx.MdxStatement;
import org.pivot4j.mdx.MemberParameter;
import org.pivot4j.mdx.QueryAxis;
import org.pivot4j.mdx.Syntax;
import org.pivot4j.mdx.ValueParameter;
import org.pivot4j.mdx.impl.MdxParserImpl;
import org.pivot4j.state.Bookmarkable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryAdapter
implements Bookmarkable {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private PivotModelImpl model;
    private Map<Axis, Quax> quaxes;
    private boolean useQuax = false;
    private boolean axesSwapped = false;
    private Quax quaxToSort;
    private MdxStatement parsedQuery;
    private MdxStatement cloneQuery;
    private Collection<QueryChangeListener> listeners = new LinkedList<QueryChangeListener>();
    private QuaxChangeListener quaxListener = new QuaxChangeListener(){

        @Override
        public void quaxChanged(QuaxChangeEvent e) {
            QueryAdapter.this.onQuaxChanged(e.getQuax(), e.isChangedByNavigator());
        }
    };

    public QueryAdapter(PivotModelImpl model) {
        if (model == null) {
            throw new NullArgumentException("model");
        }
        this.model = model;
    }

    public void initialize() {
        this.useQuax = false;
        this.axesSwapped = false;
        this.quaxToSort = null;
        this.parsedQuery = this.parseQuery(this.model.getMdx());
        this.cloneQuery = null;
        List<QueryAxis> queryAxes = this.parsedQuery.getAxes();
        this.quaxes = new LinkedHashMap<Axis, Quax>(queryAxes.size());
        for (QueryAxis queryAxis : queryAxes) {
            Quax quax = new Quax(queryAxis.getAxis().axisOrdinal(), this.model);
            quax.addChangeListener(this.quaxListener);
            this.quaxes.put(queryAxis.getAxis(), quax);
        }
    }

    public boolean isInitialized() {
        if (this.quaxes == null || this.quaxes.isEmpty()) {
            return false;
        }
        for (Quax quax : this.quaxes.values()) {
            if (quax.isInitialized()) continue;
            return false;
        }
        return true;
    }

    public boolean isValid() {
        if (this.parsedQuery == null || this.parsedQuery.getAxes() == null) {
            return false;
        }
        List<QueryAxis> axes = this.parsedQuery.getAxes();
        int axisCount = 0;
        for (QueryAxis qa : axes) {
            if (qa.getExp() == null) continue;
            ++axisCount;
        }
        return axisCount >= 2;
    }

    public PivotModelImpl getModel() {
        return this.model;
    }

    public String getCubeName() {
        CompoundId cube = this.parsedQuery.getCube();
        if (cube != null && !cube.getNames().isEmpty()) {
            return cube.getNames().get(0).getUnquotedName();
        }
        return null;
    }

    public void addChangeListener(QueryChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangeListener(QueryChangeListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireQueryChanged() {
        this.fireQueryChanged(true);
    }

    protected void fireQueryChanged(boolean update) {
        if (update) {
            this.useQuax = true;
            this.updateQuery();
        }
        QueryChangeEvent e = new QueryChangeEvent(this);
        ArrayList<QueryChangeListener> copiedListeners = new ArrayList<QueryChangeListener>(this.listeners);
        for (QueryChangeListener listener : copiedListeners) {
            listener.queryChanged(e);
        }
    }

    public MdxStatement getParsedQuery() {
        return this.parsedQuery;
    }

    public String getCurrentMdx(final boolean evaluated) {
        MdxStatement stmt = this.parsedQuery.copy();
        stmt.accept(new AbstractExpVisitor(){

            @Override
            public void visitMemberParameter(MemberParameter exp) {
                exp.setEvaluated(evaluated);
            }

            @Override
            public void visitValueParameter(ValueParameter exp) {
                exp.setEvaluated(evaluated);
            }
        });
        return stmt.toMdx();
    }

    public void evaluate(final ExpressionEvaluator evaluator) {
        this.parsedQuery.accept(new AbstractExpVisitor(){

            @Override
            public void visitMemberParameter(MemberParameter exp) {
                QueryAdapter.this.evaluate(exp, evaluator);
            }

            @Override
            public void visitValueParameter(ValueParameter exp) {
                QueryAdapter.this.evaluate(exp, evaluator);
            }
        });
    }

    protected void evaluate(ExpressionParameter exp, ExpressionEvaluator evaluator) {
        String expression = StringUtils.trimToNull((String)exp.getExpression());
        if (expression == null) {
            exp.setResult("");
        } else {
            Object result = evaluator.evaluate("${" + exp.getExpression() + "}", this.model.getExpressionContext());
            exp.setResult(ObjectUtils.toString((Object)result));
        }
    }

    public Quax getQuax(Axis axis) {
        if (!this.isInitialized()) {
            this.getModel().getCellSet();
        }
        return this.quaxes.get(axis);
    }

    public Quax createQuax(Axis axis) {
        if (!this.isInitialized()) {
            this.getModel().getCellSet();
        }
        Quax quax = new Quax(axis.axisOrdinal(), this.getModel());
        quax.initialize(new ArrayList<Position>());
        quax.addChangeListener(this.quaxListener);
        this.quaxes.put(axis, quax);
        return quax;
    }

    public Set<Axis> getAxes() {
        return Collections.unmodifiableSet(this.quaxes.keySet());
    }

    public boolean getUseQuax() {
        return this.useQuax;
    }

    public boolean isAxesSwapped() {
        return this.axesSwapped;
    }

    public void setAxesSwapped(boolean axesSwapped) {
        this.axesSwapped = axesSwapped;
    }

    public void swapAxes() {
        QueryAxis columnAxis = this.parsedQuery.getAxis((Axis)Axis.COLUMNS);
        QueryAxis rowAxis = this.parsedQuery.getAxis((Axis)Axis.ROWS);
        if (columnAxis != null && rowAxis != null) {
            Exp exp = columnAxis.getExp();
            columnAxis.setExp(rowAxis.getExp());
            rowAxis.setExp(exp);
            Quax columnQuax = this.quaxes.get(Axis.COLUMNS);
            Quax rowQuax = this.quaxes.get(Axis.ROWS);
            this.quaxes.put((Axis)Axis.COLUMNS, rowQuax);
            this.quaxes.put((Axis)Axis.ROWS, columnQuax);
            this.setAxesSwapped(!this.axesSwapped);
            this.fireQueryChanged();
        }
    }

    public boolean isNonEmpty() {
        boolean nonEmpty = true;
        List<QueryAxis> queryAxes = this.parsedQuery.getAxes();
        for (QueryAxis axis : queryAxes) {
            nonEmpty &= axis.isNonEmpty();
        }
        return !queryAxes.isEmpty() && nonEmpty;
    }

    public void setNonEmpty(boolean nonEmpty) {
        boolean changed;
        boolean bl = changed = nonEmpty != this.isNonEmpty();
        if (changed) {
            List<QueryAxis> queryAxes = this.parsedQuery.getAxes();
            for (QueryAxis axis : queryAxes) {
                axis.setNonEmpty(nonEmpty);
            }
            this.fireQueryChanged(false);
        }
    }

    public Quax getQuaxToSort() {
        return this.quaxToSort;
    }

    public void setQuaxToSort(Quax quaxToSort) {
        this.quaxToSort = quaxToSort;
        this.updateQuery();
    }

    protected boolean isSortOnQuery() {
        return this.model.isSorting() && this.model.getSortPosMembers() != null && !this.model.getSortPosMembers().isEmpty();
    }

    protected int activeQuaxToSort() {
        if (this.isSortOnQuery()) {
            return this.quaxToSort.getOrdinal();
        }
        return -1;
    }

    public Quax findQuax(Dimension dim) {
        if (!this.isInitialized()) {
            this.getModel().getCellSet();
        }
        for (Quax quax : this.quaxes.values()) {
            if (quax.dimIdx(dim) < 0) continue;
            return quax;
        }
        return null;
    }

    public MdxStatement updateQuery() {
        if (this.useQuax) {
            int iQuaxToSort = this.activeQuaxToSort();
            for (Quax quax : this.quaxes.values()) {
                QueryAxis queryAxis;
                if (quax.getPosTreeRoot() == null) continue;
                boolean doHierarchize = false;
                if (quax.isHierarchizeNeeded() && quax.getOrdinal() != iQuaxToSort) {
                    doHierarchize = true;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("MDX Generation added Hierarchize()");
                    }
                }
                Exp eSet = quax.genExp(doHierarchize);
                Axis axis = Axis.Factory.forOrdinal((int)quax.getOrdinal());
                if (this.isAxesSwapped()) {
                    if (axis == Axis.COLUMNS) {
                        axis = Axis.ROWS;
                    } else if (axis == Axis.ROWS) {
                        axis = Axis.COLUMNS;
                    }
                }
                if ((queryAxis = this.parsedQuery.getAxis(axis)) == null) {
                    this.parsedQuery.setAxis(new QueryAxis(axis, eSet, this.model.getDefaultNonEmpty()));
                    continue;
                }
                queryAxis.setExp(eSet);
            }
        }
        if (!this.useQuax) {
            if (this.cloneQuery == null) {
                if (this.isSortOnQuery()) {
                    this.cloneQuery = this.parsedQuery.copy();
                }
            } else {
                this.parsedQuery = this.isSortOnQuery() ? this.cloneQuery.copy() : this.cloneQuery;
            }
        }
        this.addSortToQuery();
        return this.parsedQuery;
    }

    public void addSortToQuery() {
        if (this.isSortOnQuery()) {
            switch (this.model.getSortCriteria()) {
                case ASC: 
                case DESC: 
                case BASC: 
                case BDESC: {
                    this.orderAxis(this.parsedQuery);
                    break;
                }
                case TOPCOUNT: {
                    this.topBottomAxis(this.parsedQuery, "TopCount");
                    break;
                }
                case BOTTOMCOUNT: {
                    this.topBottomAxis(this.parsedQuery, "BottomCount");
                    break;
                }
                default: {
                    return;
                }
            }
        }
    }

    protected void orderAxis(MdxStatement pq) {
        Exp sortExp;
        QueryAxis qa = pq.getAxis(Axis.Factory.forOrdinal((int)this.quaxToSort.getOrdinal()));
        Exp setForAx = qa.getExp();
        ArrayList<Exp> args = new ArrayList<Exp>(3);
        args.add(setForAx);
        List<Member> sortPosMembers = this.model.getSortPosMembers();
        if (sortPosMembers == null) {
            return;
        }
        QuaxUtil utils = new QuaxUtil(this.model.getCube(), this.model.getMemberHierarchyCache());
        if (sortPosMembers.size() > 1) {
            ArrayList<Exp> memberExp = new ArrayList<Exp>(sortPosMembers.size());
            for (Member member : sortPosMembers) {
                memberExp.add(utils.expForMember(member));
            }
            sortExp = new FunCall("()", Syntax.Parentheses, memberExp);
        } else {
            sortExp = utils.expForMember(sortPosMembers.get(0));
        }
        args.add(sortExp);
        args.add(Literal.createString(this.model.getSortCriteria().name()));
        FunCall order = new FunCall("Order", Syntax.Function, args);
        qa.setExp(order);
    }

    protected void topBottomAxis(MdxStatement pq, String function) {
        Exp sortExp;
        if (this.quaxToSort == null) {
            return;
        }
        QueryAxis qa = pq.getAxis(Axis.Factory.forOrdinal((int)this.quaxToSort.getOrdinal()));
        Exp setForAx = qa.getExp();
        List<Member> sortPosMembers = this.model.getSortPosMembers();
        if (sortPosMembers == null) {
            return;
        }
        QuaxUtil utils = new QuaxUtil(this.model.getCube(), this.model.getMemberHierarchyCache());
        if (sortPosMembers.size() > 1) {
            ArrayList<Exp> memberExp = new ArrayList<Exp>(sortPosMembers.size());
            for (Member member : sortPosMembers) {
                memberExp.add(utils.expForMember(member));
            }
            sortExp = new FunCall("()", Syntax.Parentheses, memberExp);
        } else {
            sortExp = utils.expForMember(sortPosMembers.get(0));
        }
        ArrayList<Exp> args = new ArrayList<Exp>(3);
        args.add(setForAx);
        args.add(Literal.create(this.model.getTopBottomCount()));
        args.add(sortExp);
        FunCall topbottom = new FunCall(function, Syntax.Function, args);
        qa.setExp(topbottom);
    }

    protected MdxStatement parseQuery(String mdxQuery) {
        MdxParserImpl parser = new MdxParserImpl();
        return parser.parse(mdxQuery);
    }

    public void afterExecute(CellSet cellSet) {
        List positions;
        List axes = cellSet.getAxes();
        HashMap<Axis, CellSetAxis> axisMap = new HashMap<Axis, CellSetAxis>();
        for (CellSetAxis axis : axes) {
            axisMap.put(axis.getAxisOrdinal(), axis);
        }
        if (!this.useQuax) {
            for (CellSetAxis axis : axes) {
                Quax quax;
                positions = axis.getPositions();
                Axis targetAxis = axis.getAxisOrdinal();
                if (this.axesSwapped) {
                    if (axis.getAxisOrdinal() == Axis.COLUMNS) {
                        targetAxis = Axis.ROWS;
                    } else if (axis.getAxisOrdinal() == Axis.ROWS) {
                        targetAxis = Axis.COLUMNS;
                    }
                }
                if ((quax = this.quaxes.get(targetAxis)) == null) continue;
                quax.initialize(positions);
            }
        } else {
            for (Quax quax : this.quaxes.values()) {
                CellSetAxis cellSetAxis;
                Axis targetAxis = Axis.Factory.forOrdinal((int)quax.getOrdinal());
                if (this.axesSwapped) {
                    if (quax.getOrdinal() == Axis.COLUMNS.axisOrdinal()) {
                        targetAxis = Axis.ROWS;
                    } else if (quax.getOrdinal() == Axis.ROWS.axisOrdinal()) {
                        targetAxis = Axis.COLUMNS;
                    }
                }
                if ((cellSetAxis = (CellSetAxis)axisMap.get(targetAxis)) == null) continue;
                List positions2 = cellSetAxis.getPositions();
                if (quax.getGenerateMode() == CalcSetMode.Generate) {
                    quax.resetGenerate();
                    quax.initialize(positions2);
                    continue;
                }
                int nDimension = quax.getNDimension();
                for (int j = 0; j < nDimension; ++j) {
                    if (!quax.isUnknownFunction(j)) continue;
                    List<Member> members = this.memListForHier(j, positions2);
                    quax.setHierMemberList(j, members);
                }
            }
        }
        if (this.logger.isDebugEnabled()) {
            for (CellSetAxis axis : axes) {
                positions = axis.getPositions();
                this.logger.debug("Positions of axis " + axis.getAxisOrdinal().axisOrdinal());
                if (positions.size() == 0) {
                    this.logger.debug("0 positions");
                    continue;
                }
                int nDimension = ((Position)positions.get(0)).getMembers().size();
                for (Position position : positions) {
                    List members = position.getMembers();
                    StringBuilder sb = new StringBuilder();
                    for (int j = 0; j < nDimension; ++j) {
                        if (j > 0) {
                            sb.append(" * ");
                        }
                        ArrayList<Member> memsj = new ArrayList<Member>(j + 1);
                        for (int k = 0; k <= j; ++k) {
                            memsj.add((Member)members.get(k));
                        }
                        if (this.canExpand(memsj)) {
                            sb.append("(+)");
                        } else if (this.canCollapse(memsj)) {
                            sb.append("(-)");
                        } else {
                            sb.append("   ");
                        }
                        sb.append(((Member)members.get(j)).getUniqueName());
                    }
                    this.logger.debug(sb.toString());
                }
            }
        }
    }

    protected List<Member> memListForHier(int hierIndex, List<Position> positions) {
        ArrayList<Member> members = new ArrayList<Member>();
        for (Position position : positions) {
            Member member = (Member)position.getMembers().get(hierIndex);
            if (members.contains(member)) continue;
            members.add(member);
        }
        return members;
    }

    protected Object createMemberSet(List<Member> members) {
        ArrayList<Exp> exps = new ArrayList<Exp>(members.size());
        QuaxUtil utils = new QuaxUtil(this.model.getCube(), this.model.getMemberHierarchyCache());
        for (Member member : members) {
            exps.add(utils.expForMember(member));
        }
        return new FunCall("{}", Syntax.Braces, exps);
    }

    public boolean canExpand(Member member) {
        if (member.isCalculated()) {
            return false;
        }
        try {
            if (member.getChildMemberCount() <= 0) {
                return false;
            }
        }
        catch (OlapException e) {
            throw new PivotException(e);
        }
        Dimension dim = member.getLevel().getHierarchy().getDimension();
        Quax quax = this.findQuax(dim);
        return quax == null ? false : quax.canExpand(member);
    }

    public boolean canExpand(List<Member> pathMembers) {
        if (pathMembers.isEmpty()) {
            return false;
        }
        Member member = pathMembers.get(pathMembers.size() - 1);
        if (member.isCalculated()) {
            return false;
        }
        try {
            if (member.getChildMemberCount() <= 0) {
                return false;
            }
        }
        catch (OlapException e) {
            throw new PivotException(e);
        }
        Dimension dim = member.getLevel().getHierarchy().getDimension();
        Quax quax = this.findQuax(dim);
        return quax == null ? false : quax.canExpand(pathMembers);
    }

    public boolean canCollapse(Member member) {
        if (member.isCalculated()) {
            return false;
        }
        Dimension dim = member.getLevel().getHierarchy().getDimension();
        Quax quax = this.findQuax(dim);
        return quax == null ? false : quax.canCollapse(member);
    }

    public boolean canCollapse(List<Member> pathMembers) {
        if (pathMembers.isEmpty()) {
            return false;
        }
        Member member = pathMembers.get(pathMembers.size() - 1);
        if (member.isCalculated()) {
            return false;
        }
        Dimension dim = member.getLevel().getHierarchy().getDimension();
        Quax quax = this.findQuax(dim);
        return quax == null ? false : quax.canCollapse(pathMembers);
    }

    public void expand(Member member) {
        Dimension dim = member.getLevel().getHierarchy().getDimension();
        Quax quax = this.findQuax(dim);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Expand member{}", (Object)this.getPositionString(null, member));
        }
        if (quax == null || !quax.canExpand(member)) {
            String msg = "Expand member failed for " + member.getUniqueName();
            throw new PivotException(msg);
        }
        quax.expand(member);
    }

    public void expand(List<Member> pathMembers) {
        Member member = pathMembers.get(pathMembers.size() - 1);
        Dimension dim = member.getLevel().getHierarchy().getDimension();
        Quax quax = this.findQuax(dim);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Expand path{}", (Object)this.getPositionString(pathMembers, null));
        }
        if (quax == null || !quax.canExpand(pathMembers)) {
            String msg = "Expand failed for" + this.getPositionString(pathMembers, null);
            throw new PivotException(msg);
        }
        quax.expand(pathMembers);
    }

    public void collapse(Member member) {
        Quax quax;
        Dimension dim = member.getLevel().getHierarchy().getDimension();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Collapse " + member.getUniqueName());
        }
        if ((quax = this.findQuax(dim)) == null) {
            String msg = "Collapse quax was null " + member.getUniqueName();
            throw new PivotException(msg);
        }
        quax.collapse(member);
    }

    public void collapse(List<Member> pathMembers) {
        Member member;
        Dimension dim;
        Quax quax;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Collapse{}", (Object)this.getPositionString(pathMembers, null));
        }
        if ((quax = this.findQuax(dim = (member = pathMembers.get(pathMembers.size() - 1)).getLevel().getHierarchy().getDimension())) == null) {
            String msg = "Target quax was null" + this.getPositionString(pathMembers, null);
            throw new PivotException(msg);
        }
        quax.collapse(pathMembers);
    }

    public boolean canDrillDown(Member member) {
        try {
            if (member.getChildMemberCount() <= 0) {
                return false;
            }
        }
        catch (OlapException e) {
            throw new PivotException(e);
        }
        Dimension dim = member.getLevel().getHierarchy().getDimension();
        Quax quax = this.findQuax(dim);
        return quax == null ? false : quax.canDrillDown(member);
    }

    public boolean canDrillUp(Hierarchy hierarchy) {
        Quax quax = this.findQuax(hierarchy.getDimension());
        return quax == null ? false : quax.canDrillUp(hierarchy);
    }

    public void drillDown(Member member) {
        Quax quax = this.findQuax(member.getLevel().getHierarchy().getDimension());
        if (quax == null) {
            String msg = "Target quax was null" + this.getPositionString(null, member);
            throw new PivotException(msg);
        }
        quax.drillDown(member);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Drill down{}", (Object)this.getPositionString(null, member));
        }
    }

    public void drillUp(Hierarchy hierarchy) {
        Quax quax = this.findQuax(hierarchy.getDimension());
        if (quax == null) {
            String msg = "Drill up hierarchy quax was null " + hierarchy.getCaption();
            throw new PivotException(msg);
        }
        quax.drillUp(hierarchy);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Drill up hierarchy {}", (Object)hierarchy.getCaption());
        }
    }

    public void changeSlicer(Exp exp) {
        this.parsedQuery.setSlicer(exp);
        this.fireQueryChanged(false);
    }

    protected String getPositionString(List<Member> posMembers, Member member) {
        StringBuilder sb = new StringBuilder();
        if (posMembers != null) {
            sb.append(" Position=");
            int i = 0;
            for (Member m : posMembers) {
                if (i > 0) {
                    sb.append(" ");
                }
                sb.append(m.getUniqueName());
                ++i;
            }
        }
        if (member != null) {
            sb.append(" Member=");
            sb.append(member.getUniqueName());
        }
        return sb.toString();
    }

    protected void onQuaxChanged(Quax quax, boolean changedByNavigator) {
        if (changedByNavigator && this.model.isSorting() && quax == this.getQuaxToSort()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Quax changed by navi - switch sorting off");
            }
            this.model.setSorting(false);
        }
        this.fireQueryChanged();
    }

    @Override
    public Serializable saveState() {
        Serializable[] state = new Serializable[4];
        state[0] = Boolean.valueOf(this.isAxesSwapped());
        state[1] = Boolean.valueOf(this.getUseQuax());
        state[2] = this.quaxToSort == null ? Integer.valueOf(-1) : Integer.valueOf(this.quaxToSort.getOrdinal());
        if (this.getUseQuax()) {
            Serializable[] quaxStates = new Serializable[this.quaxes.size()];
            int i = 0;
            for (Axis axis : this.quaxes.keySet()) {
                Quax quax = this.quaxes.get(axis);
                if (quax == null) {
                    quaxStates[i++] = new Serializable[]{Integer.valueOf(axis.axisOrdinal()), null};
                    continue;
                }
                quaxStates[i++] = new Serializable[]{Integer.valueOf(axis.axisOrdinal()), quax.saveState()};
            }
            state[3] = quaxStates;
        } else {
            state[3] = null;
        }
        return state;
    }

    @Override
    public void restoreState(Serializable state) {
        Serializable[] states = (Serializable[])state;
        this.axesSwapped = (Boolean)states[0];
        this.useQuax = (Boolean)states[1];
        int quaxOrdinal = (Integer)states[2];
        this.quaxToSort = null;
        if (quaxOrdinal > -1) {
            for (Quax quax : this.quaxes.values()) {
                if (quaxOrdinal != quax.getOrdinal()) continue;
                this.quaxToSort = quax;
                break;
            }
        }
        if (this.useQuax) {
            Serializable[] quaxStates = (Serializable[])states[3];
            if (this.quaxes.size() != quaxStates.length) {
                throw new IllegalArgumentException("Stored quax state is not compatible with the current MDX.");
            }
            for (int i = 0; i < quaxStates.length; ++i) {
                Serializable[] quaxState = (Serializable[])quaxStates[i];
                int ordinal = (Integer)quaxState[0];
                Axis axis = Axis.Factory.forOrdinal((int)ordinal);
                if (quaxState[1] == null) {
                    this.quaxes.remove(axis);
                    continue;
                }
                this.quaxes.get(axis).restoreState(quaxState[1]);
            }
        }
    }
}

