/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.pivot4j.impl.QuaxUtil;
import org.pivot4j.mdx.Exp;
import org.pivot4j.mdx.ExpNode;
import org.pivot4j.mdx.FunCall;
import org.pivot4j.mdx.Syntax;
import org.pivot4j.util.TreeNode;

public class ExpGenerator {
    private QuaxUtil quaxUtil;
    private ExpNode rootNode;
    private int nDimension;

    public void init(ExpNode rootNode, int nDimension, QuaxUtil quaxUtil) {
        this.rootNode = rootNode;
        this.nDimension = nDimension;
        this.quaxUtil = quaxUtil;
    }

    public Exp generate() {
        Exp exp = null;
        List nodes = this.rootNode.getChildren();
        ArrayList<Exp> openSet = new ArrayList<Exp>();
        for (TreeNode<Exp> treeNode : nodes) {
            Exp expForNode = this.genExpForNode(treeNode, this.nDimension);
            boolean closeOpenSet = false;
            if (this.nDimension == 1) {
                if (this.quaxUtil.isMember(expForNode)) {
                    openSet.add(expForNode);
                    continue;
                }
                closeOpenSet = true;
            } else {
                if (this.quaxUtil.isFunCallTo(expForNode, "()")) {
                    openSet.add(expForNode);
                    continue;
                }
                closeOpenSet = true;
            }
            if (closeOpenSet && !openSet.isEmpty()) {
                FunCall set = new FunCall("{}", Syntax.Braces, openSet);
                if (exp == null) {
                    exp = set;
                } else {
                    FunCall call = new FunCall("Union", Syntax.Function);
                    call.getArgs().add(exp);
                    call.getArgs().add(set);
                    exp = call;
                }
                openSet.clear();
            }
            if (exp == null) {
                exp = expForNode;
                continue;
            }
            FunCall call = new FunCall("Union", Syntax.Function);
            call.getArgs().add(exp);
            call.getArgs().add(expForNode);
            exp = call;
        }
        if (!openSet.isEmpty()) {
            FunCall set = new FunCall("{}", Syntax.Braces, openSet);
            if (exp == null) {
                exp = set;
            } else {
                FunCall funCall = new FunCall("Union", Syntax.Function);
                funCall.getArgs().add(exp);
                funCall.getArgs().add(set);
                exp = funCall;
            }
            openSet.clear();
        }
        return exp;
    }

    private Exp genExpForNode(TreeNode<Exp> node, int untilIndex) {
        Exp eNode = node.getReference();
        if (node.getLevel() == untilIndex) {
            return eNode;
        }
        Exp[] tuple = this.genTuple(node);
        if (tuple != null) {
            if (tuple.length == 1) {
                return tuple[0];
            }
            return new FunCall("()", Syntax.Parentheses, Arrays.asList(tuple));
        }
        Exp exp = null;
        List<TreeNode<Exp>> childNodes = node.getChildren();
        for (TreeNode<Exp> childNode : childNodes) {
            Exp eSet;
            Exp childExp = this.genExpForNode(childNode, untilIndex);
            if (!this.quaxUtil.isMember(eNode)) {
                eSet = eNode;
            } else {
                FunCall call = new FunCall("{}", Syntax.Braces);
                call.getArgs().add(eNode);
                eSet = call;
            }
            if (childExp == null) {
                exp = eSet;
                continue;
            }
            Exp childSet = this.bracesAround(childExp);
            FunCall cj = new FunCall("CrossJoin", Syntax.Function);
            cj.getArgs().add(eSet);
            cj.getArgs().add(childSet);
            if (exp == null) {
                exp = cj;
                continue;
            }
            FunCall call = new FunCall("Union", Syntax.Function);
            call.getArgs().add(exp);
            call.getArgs().add(cj);
            exp = call;
        }
        return exp;
    }

    private Exp bracesAround(Exp oExp) {
        Exp oSet;
        if (this.quaxUtil.isMember(oExp) || this.quaxUtil.isFunCallTo(oExp, "()")) {
            FunCall call = new FunCall("{}", Syntax.Braces);
            call.getArgs().add(oExp);
            oSet = call;
        } else {
            oSet = oExp;
        }
        return oSet;
    }

    private Exp[] genTuple(TreeNode<Exp> node) {
        if (!this.quaxUtil.isMember(node.getReference())) {
            return null;
        }
        int size = this.nDimension - node.getLevel() + 1;
        if (size == 1) {
            return new Exp[]{node.getReference()};
        }
        List<TreeNode<Exp>> childNodes = node.getChildren();
        if (childNodes.size() != 1) {
            return null;
        }
        Exp[] nextTuple = this.genTuple(childNodes.get(0));
        if (nextTuple == null) {
            return null;
        }
        Exp[] tupleMembers = new Exp[size];
        tupleMembers[0] = node.getReference();
        for (int i = 1; i < tupleMembers.length; ++i) {
            tupleMembers[i] = nextTuple[i - 1];
        }
        return tupleMembers;
    }
}

