/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.el;

import org.pivot4j.el.EvaluationFailedException;
import org.pivot4j.el.ExpressionContext;
import org.pivot4j.el.ExpressionEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExpressionEvaluator
implements ExpressionEvaluator {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public Object evaluate(String expression, ExpressionContext context) {
        Object result;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Evaluating expression : ");
            this.logger.debug("\t- expression : {}", (Object)expression);
        }
        try {
            result = this.doEvaluate(expression, context);
        }
        catch (EvaluationFailedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EvaluationFailedException("Failed to evaluate the expression : " + e, expression, e);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\t- result : {}", result);
        }
        return result;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    protected abstract Object doEvaluate(String var1, ExpressionContext var2) throws Exception;
}

