/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.datasource;

import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.lang.NullArgumentException;
import org.olap4j.OlapConnection;
import org.pivot4j.datasource.AbstractOlapDataSource;

public class WrappingOlapDataSource
extends AbstractOlapDataSource {
    private DataSource dataSource;

    public WrappingOlapDataSource(DataSource dataSource) {
        if (dataSource == null) {
            throw new NullArgumentException("dataSource");
        }
        this.dataSource = dataSource;
    }

    @Override
    protected OlapConnection createConnection(String userName, String password) throws SQLException {
        return this.dataSource.getConnection(userName, password).unwrap(OlapConnection.class);
    }

    protected DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.equals(this.dataSource.getClass())) {
            return (T)this.dataSource;
        }
        return super.unwrap(iface);
    }
}

