/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.util;

import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.repackaged.guava.base.Preconditions;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.CHARSEXP;
import org.renjin.sexp.Closure;
import org.renjin.sexp.ComplexVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.Environment;
import org.renjin.sexp.ExpressionVector;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.PrimitiveFunction;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.SEXPBuilder;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

public class CDefines {
    public static final Null R_NilValue = Null.INSTANCE;
    public static final Symbol R_MissingArg = Symbol.MISSING_ARG;
    public static final Symbol R_UnboundValue = Symbol.UNBOUND_VALUE;
    public static final Object NULL = null;
    public static final String NA_STRING = StringVector.NA;
    public static final SexpType CLOSXP = new SexpType();
    public static final SexpType VECSXP = new SexpType();
    public static final SexpType STRSXP = new SexpType();
    public static final SexpType REALSXP = new SexpType();
    public static final SexpType INTSXP = new SexpType();
    public static final Symbol R_NamesSymbol = Symbols.NAMES;
    public static final Symbol R_SrcrefSymbol = Symbols.SRC_REF;
    public static final Symbol R_SrcfileSymbol = Symbols.SRC_FILE;
    public static final Symbol R_ClassSymbol = Symbols.CLASS;
    public static final CHARSEXP R_BlankString = new CHARSEXP("");

    protected CDefines() {
    }

    public static CHARSEXP STRING_ELT(SEXP x, int i) {
        StringVector vector2 = (StringVector)x;
        return new CHARSEXP(vector2.getElementAsString(i));
    }

    public static SEXP VECTOR_ELT(SEXP x, int i) {
        ListVector vector2 = (ListVector)x;
        return vector2.getElementAsSEXP(i);
    }

    public static String CHAR(CHARSEXP s) {
        return s.getValue();
    }

    public static CHARSEXP PRINTNAME(SEXP s) {
        return new CHARSEXP(((Symbol)s).getPrintName());
    }

    public static char[] CHAR(SEXP s) {
        CHARSEXP cs = (CHARSEXP)s;
        return cs.getValue().toCharArray();
    }

    public static SEXP TAG(SEXP e) {
        Preconditions.checkNotNull(e);
        return ((PairList)e).getRawTag();
    }

    public static SEXP CAR(SEXP listExp) {
        PairList.Node typedList = (PairList.Node)listExp;
        return typedList.getValue();
    }

    public static SEXP CDR(SEXP listExp) {
        PairList.Node list2 = (PairList.Node)listExp;
        return list2.hasNextNode() ? list2.getNextNode() : R_NilValue;
    }

    public static SEXP CAAR(SEXP e) {
        return CDefines.CAR(CDefines.CDR(e));
    }

    public static SEXP CDAR(SEXP e) {
        return CDefines.CDR(CDefines.CAR(e));
    }

    public static SEXP CADR(SEXP e) {
        return CDefines.CAR(CDefines.CDR(e));
    }

    public static SEXP CDDR(SEXP e) {
        return CDefines.CDR(CDefines.CDR(e));
    }

    public static SEXP CADDR(SEXP e) {
        return CDefines.CAR(CDefines.CDR(CDefines.CDR(e)));
    }

    public static SEXP CADDDR(SEXP e) {
        return CDefines.CAR(CDefines.CDR(CDefines.CDR(CDefines.CDR(e))));
    }

    public static SEXP CAD4R(SEXP e) {
        return CDefines.CAR(CDefines.CDR(CDefines.CDR(CDefines.CDR(CDefines.CDR(e)))));
    }

    public static SEXP SETCAR(SEXP x, SEXP y) {
        if (x == NULL || x == R_NilValue) {
            CDefines.error(CDefines._("bad value"), new Object[0]);
        }
        CDefines.CHECK_OLD_TO_NEW(x, y);
        ((PairList.Node)x).setValue(y);
        return y;
    }

    public static SEXP SETCDR(SEXP x, SEXP y) {
        if (x == NULL || x == R_NilValue) {
            CDefines.error(CDefines._("bad value"), new Object[0]);
        }
        CDefines.CHECK_OLD_TO_NEW(x, y);
        ((PairList.Node)x).setNextNode((PairList.Node)y);
        return y;
    }

    public static SEXP SETCADR(SEXP x, SEXP y) {
        if (x == NULL || x == R_NilValue || CDefines.CDR(x) == NULL || CDefines.CDR(x) == R_NilValue) {
            CDefines.error(CDefines._("bad value"), new Object[0]);
        }
        SEXP cell = CDefines.CDR(x);
        CDefines.CHECK_OLD_TO_NEW(cell, y);
        ((PairList.Node)cell).setNextNode((PairList.Node)y);
        return y;
    }

    public static SEXP SETCADDR(SEXP x, SEXP y) {
        if (x == NULL || x == R_NilValue || CDefines.CDR(x) == NULL || CDefines.CDR(x) == R_NilValue || CDefines.CDDR(x) == NULL || CDefines.CDDR(x) == R_NilValue) {
            CDefines.error(CDefines._("bad value"), new Object[0]);
        }
        SEXP cell = CDefines.CDDR(x);
        CDefines.CHECK_OLD_TO_NEW(cell, y);
        ((PairList.Node)cell).setValue(y);
        return y;
    }

    public static SEXP CDDDR(SEXP x) {
        return CDefines.CDR(CDefines.CDR(CDefines.CDR(x)));
    }

    public static SEXP SETCADDDR(SEXP x, SEXP y) {
        if (x == NULL || x == R_NilValue || CDefines.CDR(x) == NULL || CDefines.CDR(x) == R_NilValue || CDefines.CDDR(x) == NULL || CDefines.CDDR(x) == R_NilValue || CDefines.CDDDR(x) == NULL || CDefines.CDDDR(x) == R_NilValue) {
            CDefines.error(CDefines._("bad value"), new Object[0]);
        }
        SEXP cell = CDefines.CDDDR(x);
        CDefines.CHECK_OLD_TO_NEW(cell, y);
        ((PairList.Node)cell).setValue(y);
        return y;
    }

    public static SEXP CD4R(SEXP x) {
        return CDefines.CDR(CDefines.CDR(CDefines.CDR(CDefines.CDR(x))));
    }

    public static SEXP SETCAD4R(SEXP x, SEXP y) {
        if (x == NULL || x == R_NilValue || CDefines.CDR(x) == NULL || CDefines.CDR(x) == R_NilValue || CDefines.CDDR(x) == NULL || CDefines.CDDR(x) == R_NilValue || CDefines.CDDDR(x) == NULL || CDefines.CDDDR(x) == R_NilValue || CDefines.CD4R(x) == NULL || CDefines.CD4R(x) == R_NilValue) {
            CDefines.error(CDefines._("bad value"), new Object[0]);
        }
        SEXP cell = CDefines.CD4R(x);
        CDefines.CHECK_OLD_TO_NEW(cell, y);
        ((PairList.Node)cell).setValue(y);
        return y;
    }

    public static String PRIMNAME(SEXP x) {
        return ((PrimitiveFunction)x).getName();
    }

    public static void CHECK_OLD_TO_NEW(SEXP x, SEXP y) {
    }

    public static void PROTECT(Object s) {
    }

    public static void UNPROTECT(int c2) {
    }

    public static void PROTECT_PTR(SEXP s) {
    }

    public static void REPROTECT(Object x, int i) {
    }

    public static PairList.Node CONS(SEXP car, SEXP cdr, AttributeMap attributes2) {
        Preconditions.checkNotNull(car);
        Preconditions.checkNotNull(cdr);
        if (cdr == R_NilValue) {
            return new PairList.Node(Null.INSTANCE, car, attributes2, null);
        }
        return new PairList.Node(Null.INSTANCE, car, attributes2, (PairList.Node)cdr);
    }

    public static PairList.Node CONS(SEXP car, SEXP cdr) {
        return CDefines.CONS(car, cdr, AttributeMap.EMPTY);
    }

    public static PairList.Node list1(SEXP s) {
        return CDefines.CONS(s, R_NilValue);
    }

    public static PairList.Node list2(SEXP s, SEXP t2) {
        return CDefines.CONS(s, CDefines.list1(t2));
    }

    public static PairList.Node list3(SEXP s, SEXP t2, SEXP u) {
        return CDefines.CONS(s, CDefines.list2(t2, u));
    }

    public static PairList.Node list4(SEXP s, SEXP t2, SEXP u, SEXP v) {
        return CDefines.CONS(s, CDefines.list3(t2, u, v));
    }

    public static FunctionCall LCONS(SEXP car, SEXP cdr) {
        Preconditions.checkNotNull(car);
        if (cdr == R_NilValue) {
            return new FunctionCall(car, null);
        }
        return new FunctionCall(car, (PairList.Node)cdr);
    }

    public static void UNPROTECT_PTR(SEXP s) {
    }

    public static PairList.Node lang1(SEXP s) {
        return CDefines.LCONS(s, R_NilValue);
    }

    public static FunctionCall lang2(SEXP s, SEXP t2) {
        return CDefines.LCONS(s, CDefines.list1(t2));
    }

    public static FunctionCall lang3(SEXP s, SEXP t2, SEXP u) {
        return CDefines.LCONS(s, CDefines.list2(t2, u));
    }

    public static FunctionCall lang4(SEXP s, SEXP t2, SEXP u, SEXP v) {
        return CDefines.LCONS(s, CDefines.list3(t2, u, v));
    }

    public static void SET_TAG(SEXP x, SEXP v) {
        ((PairList)x).setTag(v);
    }

    public static int length(SEXP s) {
        return s.length();
    }

    public static Symbol install(String name) {
        return Symbol.get(name);
    }

    public static String translateChar(SEXP s) {
        CHARSEXP charVec = (CHARSEXP)s;
        return charVec.toString();
    }

    public static boolean isSymbol(SEXP s) {
        return s instanceof Symbol;
    }

    public static boolean isLogical(SEXP s) {
        return s instanceof LogicalVector;
    }

    public static boolean isReal(SEXP s) {
        return s instanceof DoubleVector;
    }

    public static boolean isComplex(SEXP s) {
        return s instanceof ComplexVector;
    }

    public static boolean isExpression(SEXP s) {
        return s instanceof ExpressionVector;
    }

    public static boolean isEnvironment(SEXP s) {
        return s instanceof Environment;
    }

    public static boolean isString(SEXP s) {
        return s instanceof StringVector;
    }

    public static double asReal(SEXP s) {
        return s.asReal();
    }

    public static void error(String message, Object ... args2) {
        throw new EvalException(String.format(message, args2), new Object[0]);
    }

    public static String _(String s) {
        return s;
    }

    public static SEXP eval(SEXP exp2, Context context, SEXP rho) {
        return context.evaluate(exp2, (Environment)rho);
    }

    public static SexpType TYPEOF(SEXP exp2) {
        if (exp2 instanceof Closure) {
            return CLOSXP;
        }
        if (exp2 instanceof ListVector) {
            return VECSXP;
        }
        return null;
    }

    public static boolean isNewList(SEXP s) {
        return s == R_NilValue || CDefines.TYPEOF(s) == VECSXP;
    }

    public static Vector.Builder allocVector(SexpType type, int size) {
        if (type == VECSXP) {
            return new ListVector.Builder(size);
        }
        if (type == STRSXP) {
            return new StringVector.Builder(size);
        }
        throw new UnsupportedOperationException();
    }

    public static final SEXP getAttrib(SEXP s, Symbol attribName) {
        return s.getAttribute(attribName);
    }

    public static void setAttrib(SEXPBuilder builder, Symbol name, SEXP value) {
        builder.setAttribute(name, value);
    }

    public static boolean isNull(SEXP exp2) {
        return exp2 == Null.INSTANCE;
    }

    public static final CHARSEXP mkString(String s) {
        return new CHARSEXP(s);
    }

    public static class SexpType {
        private SexpType() {
        }
    }
}

