/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.nls;

import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.Function;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.Logical;
import org.renjin.sexp.Null;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Vector;

class NlsModel {
    private final FunctionCall conv;
    private final FunctionCall incr;
    private final FunctionCall deviance;
    private final FunctionCall trace;
    private final Function setPars;
    private final FunctionCall getPars;
    private Context context;

    NlsModel(Context context, ListVector listVector) {
        this.context = context;
        this.conv = NlsModel.getElementAsFunctionCall(listVector, "conv");
        this.incr = NlsModel.getElementAsFunctionCall(listVector, "incr");
        this.deviance = NlsModel.getElementAsFunctionCall(listVector, "deviance");
        this.trace = NlsModel.getElementAsFunctionCall(listVector, "trace");
        this.setPars = NlsModel.getElementAsFunction(listVector, "setPars");
        this.getPars = NlsModel.getElementAsFunctionCall(listVector, "getPars");
    }

    public double calculateDeviation() {
        return this.evaluateCallAsDouble(this.deviance);
    }

    public DoubleVector calculateIncrements() {
        return (DoubleVector)this.evaluateCall(this.incr);
    }

    private SEXP evaluateCall(FunctionCall functionCall) {
        return this.context.evaluate(functionCall, this.context.getGlobalEnvironment());
    }

    private double evaluateCallAsDouble(FunctionCall functionCall) {
        return ((Vector)this.evaluateCall(functionCall)).getElementAsDouble(0);
    }

    public double getConvergence() {
        return this.evaluateCallAsDouble(this.conv);
    }

    private static Function getElementAsFunction(ListVector sEXP, String string) {
        if ((sEXP = sEXP.get(string)) == Null.INSTANCE || !(sEXP instanceof Function)) {
            throw new EvalException("'%s' absent", "m$" + string + "()");
        }
        return (Function)sEXP;
    }

    private static FunctionCall getElementAsFunctionCall(ListVector listVector, String string) {
        return FunctionCall.newCall(NlsModel.getElementAsFunction(listVector, string), new SEXP[0]);
    }

    public AtomicVector getParameterValues() {
        return (AtomicVector)this.evaluateCall(this.getPars);
    }

    public void trace() {
        this.context.evaluate(this.trace, this.context.getGlobalEnvironment());
    }

    public boolean updateParameters(double[] dArray) {
        SEXP sEXP = ((NlsModel)((Object)sEXP)).context.evaluate(FunctionCall.newCall(((NlsModel)((Object)sEXP)).setPars, new DoubleArrayVector(dArray)), ((NlsModel)((Object)sEXP)).context.getGlobalEnvironment());
        if (!(sEXP instanceof AtomicVector)) {
            throw new EvalException("Unexpected result from setPars", new Object[0]);
        }
        boolean bl = ((AtomicVector)sEXP).getElementAsLogical(0) == Logical.TRUE;
        return bl;
    }
}

