/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.sexp;

import org.renjin.eval.EvalException;
import org.renjin.invoke.ClassBinding;
import org.renjin.invoke.ClassBindings;
import org.renjin.invoke.reflection.MemberBinding;
import org.renjin.sexp.AbstractSEXP;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.SexpVisitor;
import org.renjin.sexp.Symbol;

public final class ExternalPtr<T>
extends AbstractSEXP {
    private T instance;
    private ClassBinding binding;
    private SEXP tag;
    private SEXP _protected;

    public ExternalPtr(T instance, AttributeMap attributes2) {
        super(attributes2);
        this.unsafeSetAddress(instance);
    }

    public ExternalPtr(T instance, SEXP tag, SEXP prot) {
        this(instance);
        this.tag = tag;
        this._protected = prot;
    }

    public ExternalPtr(T instance) {
        this(instance, AttributeMap.EMPTY);
    }

    @Override
    public String getTypeName() {
        return "externalptr";
    }

    private MemberBinding getMemberBinding(Symbol name) {
        if (this.binding == null) {
            throw new EvalException("ExternalPtr is NULL for name " + name.getPrintName(), new Object[0]);
        }
        return this.binding.getMemberBinding(name);
    }

    public SEXP getMember(Symbol name) {
        return this.getMemberBinding(name).getValue(this.instance);
    }

    public void setMember(Symbol name, SEXP value) {
        this.getMemberBinding(name).setValue(this.instance, value);
    }

    public T getInstance() {
        return this.instance;
    }

    public SEXP getTag() {
        return this.tag;
    }

    public SEXP getProtected() {
        return this._protected;
    }

    @Override
    public void accept(SexpVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    protected SEXP cloneWithNewAttributes(AttributeMap attributes2) {
        this.unsafeSetAttributes(attributes2);
        return this;
    }

    public void unsafeSetAddress(T address) {
        this.instance = address;
        this.binding = this.instance == null ? null : (this.instance instanceof Class ? ClassBindings.getClassDefinitionBinding((Class)this.instance) : ClassBindings.getClassBinding(this.instance.getClass()));
    }

    public void unsafeSetTag(SEXP tag) {
        this.tag = tag;
    }

    public void unsafeSetProtected(SEXP _protected) {
        this._protected = _protected;
    }
}

