/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.repackaged.guava.thirdparty.publicsuffix;

import java.util.List;
import org.renjin.repackaged.guava.annotations.GwtCompatible;
import org.renjin.repackaged.guava.base.Joiner;
import org.renjin.repackaged.guava.collect.ImmutableMap;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.repackaged.guava.thirdparty.publicsuffix.PublicSuffixType;

@GwtCompatible
class TrieParser {
    private static final Joiner PREFIX_JOINER = Joiner.on("");

    TrieParser() {
    }

    static ImmutableMap<String, PublicSuffixType> parseTrie(CharSequence encoded) {
        ImmutableMap.Builder<String, PublicSuffixType> builder = ImmutableMap.builder();
        int encodedLen = encoded.length();
        for (int idx = 0; idx < encodedLen; idx += TrieParser.doParseTrieToBuilder(Lists.<CharSequence>newLinkedList(), encoded.subSequence(idx, encodedLen), builder)) {
        }
        return builder.build();
    }

    private static int doParseTrieToBuilder(List<CharSequence> stack, CharSequence encoded, ImmutableMap.Builder<String, PublicSuffixType> builder) {
        String domain;
        int idx;
        int encodedLen = encoded.length();
        char c2 = '\u0000';
        for (idx = 0; idx < encodedLen && (c2 = encoded.charAt(idx)) != '&' && c2 != '?' && c2 != '!' && c2 != ':' && c2 != ','; ++idx) {
        }
        stack.add(0, TrieParser.reverse(encoded.subSequence(0, idx)));
        if ((c2 == '!' || c2 == '?' || c2 == ':' || c2 == ',') && (domain = PREFIX_JOINER.join(stack)).length() > 0) {
            builder.put(domain, PublicSuffixType.fromCode(c2));
        }
        ++idx;
        if (c2 != '?' && c2 != ',') {
            while (idx < encodedLen) {
                if (encoded.charAt(idx += TrieParser.doParseTrieToBuilder(stack, encoded.subSequence(idx, encodedLen), builder)) != '?' && encoded.charAt(idx) != ',') continue;
                ++idx;
                break;
            }
        }
        stack.remove(0);
        return idx;
    }

    private static CharSequence reverse(CharSequence s) {
        int length2 = s.length();
        if (length2 <= 1) {
            return s;
        }
        char[] buffer = new char[length2];
        buffer[0] = s.charAt(length2 - 1);
        for (int i = 1; i < length2; ++i) {
            buffer[i] = s.charAt(length2 - 1 - i);
            if (!Character.isSurrogatePair(buffer[i], buffer[i - 1])) continue;
            TrieParser.swap(buffer, i - 1, i);
        }
        return new String(buffer);
    }

    private static void swap(char[] buffer, int f, int s) {
        char tmp = buffer[f];
        buffer[f] = buffer[s];
        buffer[s] = tmp;
    }
}

