/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.time;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.List;
import org.renjin.invoke.annotations.Internal;
import org.renjin.primitives.time.PosixCtVector;
import org.renjin.primitives.time.PosixLtVector;
import org.renjin.primitives.time.RDateTimeFormats;
import org.renjin.primitives.time.RDateTimeFormatter;
import org.renjin.repackaged.guava.base.Strings;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringArrayVector;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbols;

public class Time {
    public static LocalDate EPOCH = LocalDate.of(1970, 1, 1);

    @Internal
    public static SEXP strptime(StringVector x, StringVector formats, String tz) {
        if (x.length() == 0 || formats.length() == 0) {
            return StringVector.EMPTY;
        }
        ZoneId timeZone = Time.timeZoneFromRSpecification(tz);
        List<RDateTimeFormatter> formatters = RDateTimeFormats.forPatterns(formats, false, timeZone);
        PosixLtVector.Builder result = new PosixLtVector.Builder();
        if (!Strings.isNullOrEmpty(tz)) {
            result.withTimeZone(timeZone, tz);
        }
        int resultLength = Math.max(x.length(), formats.length());
        for (int i = 0; i != resultLength; ++i) {
            RDateTimeFormatter formatter = formatters.get(i % formatters.size());
            String string = x.getElementAsString(i % x.length());
            if (StringVector.isNA(string)) {
                result.addNA();
                continue;
            }
            try {
                result.add(formatter.parse(string));
                continue;
            }
            catch (DateTimeParseException e) {
                result.addNA();
            }
        }
        return result.buildListVector();
    }

    @Internal(value="as.POSIXct")
    public static DoubleVector asPOSIXct(ListVector x, String tz) {
        SEXP timeZoneAttribute = Strings.isNullOrEmpty(tz) ? x.getAttribute(Symbols.TZONE) : StringArrayVector.valueOf(tz);
        return new PosixCtVector.Builder().setTimeZone(timeZoneAttribute).addAll(new PosixLtVector(x)).buildDoubleVector();
    }

    @Internal(value="as.POSIXlt")
    public static ListVector asPOSIXlt(AtomicVector x, String tz) {
        SEXP timeZoneAttribute = Strings.isNullOrEmpty(tz) ? x.getAttribute(Symbols.TZONE) : StringArrayVector.valueOf(tz);
        return new PosixLtVector.Builder().withTimeZone(timeZoneAttribute).addAll(new PosixCtVector(x)).buildListVector();
    }

    @Internal
    public static DoubleVector POSIXlt2Date(ListVector x) {
        PosixLtVector ltVector = new PosixLtVector(x);
        DoubleArrayVector.Builder dateVector = DoubleArrayVector.Builder.withInitialCapacity(ltVector.length());
        for (int i = 0; i != ltVector.length(); ++i) {
            ZonedDateTime date2 = ltVector.getElementAsDateTime(i);
            if (date2 == null) {
                dateVector.addNA();
                continue;
            }
            dateVector.add(EPOCH.until(date2, ChronoUnit.DAYS));
        }
        dateVector.setAttribute(Symbols.CLASS, (SEXP)StringVector.valueOf("Date"));
        return dateVector.build();
    }

    @Internal
    public static ListVector Date2POSIXlt(DoubleVector x) {
        PosixLtVector.Builder ltVector = new PosixLtVector.Builder();
        for (int i = 0; i != x.length(); ++i) {
            int daysSinceEpoch = x.getElementAsInt(i);
            if (IntVector.isNA(daysSinceEpoch)) {
                ltVector.addNA();
                continue;
            }
            ltVector.add(EPOCH.plusDays(daysSinceEpoch));
        }
        return ltVector.buildListVector();
    }

    @Internal(value="Sys.time")
    public static DoubleVector sysTime() {
        return new PosixCtVector.Builder().add(ZonedDateTime.now()).buildDoubleVector();
    }

    @Internal(value="format.POSIXlt")
    public static StringVector formatPOSIXlt(ListVector x, StringVector patterns, boolean useTz) {
        PosixLtVector dateTimes = new PosixLtVector(x);
        List<RDateTimeFormatter> formatters = RDateTimeFormats.forPatterns(patterns, useTz, dateTimes.getTimeZone());
        StringVector.Builder result = new StringVector.Builder();
        int resultLength = Math.max(dateTimes.length(), patterns.length());
        for (int i = 0; i != resultLength; ++i) {
            RDateTimeFormatter formatter = formatters.get(i % formatters.size());
            ZonedDateTime dateTime = dateTimes.getElementAsDateTime(i % dateTimes.length());
            if (dateTime == null) {
                result.addNA();
                continue;
            }
            result.add(formatter.format(dateTime));
        }
        return result.build();
    }

    public static ZoneId timeZoneFromRSpecification(String tz) {
        if (Strings.isNullOrEmpty(tz)) {
            return ZoneId.systemDefault();
        }
        if ("GMT".equals(tz)) {
            return ZoneId.of("UTC");
        }
        if ("Coordinated Universal Time".equals(tz)) {
            return ZoneId.of("UTC");
        }
        return ZoneId.of(tz, ZoneId.SHORT_IDS);
    }

    public static ZoneId timeZoneFromPosixObject(SEXP lt) {
        SEXP attribute = lt.getAttribute(Symbols.TZONE);
        return Time.timeZoneFromTzoneAttribute(attribute);
    }

    public static ZoneId timeZoneFromTzoneAttribute(SEXP attribute) {
        if (attribute instanceof StringVector) {
            return Time.timeZoneFromRSpecification(((StringVector)attribute).getElementAsString(0));
        }
        return ZoneId.systemDefault();
    }
}

