/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.time;

import java.text.ParsePosition;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;

public class RDateTimeFormatter {
    private final String formatString;
    private final DateTimeFormatter formatter;
    private final boolean hasTime;
    private final boolean hasZone;
    private final ZoneId zoneId;

    RDateTimeFormatter(String formatString, DateTimeFormatter formatter, boolean hasTime, boolean hasZone, ZoneId zoneId) {
        this.formatString = formatString;
        this.formatter = formatter;
        this.hasTime = hasTime;
        this.hasZone = hasZone;
        this.zoneId = zoneId;
    }

    public ZonedDateTime parse(String string) {
        ParsePosition position = new ParsePosition(0);
        TemporalAccessor result = this.formatter.parse((CharSequence)string, position);
        if (this.hasTime) {
            if (this.hasZone) {
                return ZonedDateTime.from(result);
            }
            return LocalDateTime.from(result).atZone(this.zoneId);
        }
        return LocalDate.from(result).atStartOfDay(this.zoneId);
    }

    public String format(TemporalAccessor dateTime) {
        return this.formatter.format(dateTime);
    }
}

