/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.subset;

import org.renjin.primitives.subset.IndexIterator;
import org.renjin.primitives.subset.Subscript;
import org.renjin.sexp.IntVector;

class ArrayIndexIterator
implements IndexIterator {
    private static final int STATE_BEGIN = 0;
    private static final int STATE_RUNNING = 1;
    private static final int STATE_END = 2;
    private final int numDim;
    private IndexIterator[] iterators;
    private int[] increments;
    private int[] offsetStack;
    private int state = 0;

    public ArrayIndexIterator(int[] dim2, Subscript[] subscripts) {
        this.numDim = subscripts.length;
        this.iterators = new IndexIterator[subscripts.length];
        for (int i = 0; i < this.numDim; ++i) {
            this.iterators[i] = subscripts[i].computeIndexes();
        }
        this.increments = new int[this.numDim];
        this.increments[0] = 1;
        for (int d = 1; d < this.numDim; ++d) {
            this.increments[d] = this.increments[d - 1] * dim2[d - 1];
        }
        this.offsetStack = new int[this.numDim + 1];
    }

    @Override
    public int next() {
        int nextIndex;
        int d;
        block10: {
            if (this.state == 2) {
                return -1;
            }
            if (this.state == 0) {
                int firstIndex = 0;
                for (int d2 = this.numDim - 1; d2 >= 0; --d2) {
                    int index = this.iterators[d2].next();
                    if (index == -1) {
                        this.state = 2;
                        return -1;
                    }
                    if (IntVector.isNA(index)) {
                        firstIndex = Integer.MIN_VALUE;
                    } else if (!IntVector.isNA(firstIndex)) {
                        firstIndex += index * this.increments[d2];
                    }
                    this.offsetStack[d2] = firstIndex;
                }
                this.state = 1;
                return firstIndex;
            }
            d = 0;
            do {
                if ((nextIndex = this.iterators[d].next()) != -1) {
                    this.updateOffset(d, nextIndex);
                    break block10;
                }
                this.iterators[d].restart();
            } while (++d < this.numDim);
            this.state = 2;
            return -1;
        }
        while (d > 0) {
            nextIndex = this.iterators[--d].next();
            this.updateOffset(d, nextIndex);
        }
        return this.offsetStack[0];
    }

    private void updateOffset(int dimensionIndex, int nextIndex) {
        int offset = this.offsetStack[dimensionIndex + 1];
        this.offsetStack[dimensionIndex] = IntVector.isNA(offset) || IntVector.isNA(nextIndex) ? Integer.MIN_VALUE : offset + nextIndex * this.increments[dimensionIndex];
    }

    @Override
    public void restart() {
        throw new UnsupportedOperationException();
    }
}

