/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.special;

import java.util.ArrayList;
import java.util.List;
import org.renjin.eval.ClosureDispatcher;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.sexp.Environment;
import org.renjin.sexp.ExpressionVector;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.Promise;
import org.renjin.sexp.PromisePairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.SexpVisitor;
import org.renjin.sexp.SpecialFunction;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;

public class SubstituteFunction
extends SpecialFunction {
    private static final Symbol EXPR_ARGUMENT = Symbol.get("expr");
    private static final Symbol ENV_ARGUMENT = Symbol.get("env");
    private final PairList formals = new PairList.Builder().add(EXPR_ARGUMENT, (SEXP)Symbol.MISSING_ARG).add(ENV_ARGUMENT, (SEXP)Symbol.MISSING_ARG).build();

    public SubstituteFunction() {
        super("substitute");
    }

    @Override
    public SEXP apply(Context context, Environment rho, FunctionCall call2, PairList args2) {
        SEXP expr;
        PairList matchedArguments = ClosureDispatcher.matchArguments(this.formals, args2);
        SEXP exprArgument = matchedArguments.findByTag(EXPR_ARGUMENT);
        SEXP envArgument = matchedArguments.findByTag(ENV_ARGUMENT);
        if (exprArgument == Symbols.ELLIPSES) {
            SEXP ellipses = rho.getEllipsesVariable();
            if (ellipses == Null.INSTANCE) {
                expr = Null.INSTANCE;
            } else {
                PromisePairList.Node promisePairList = (PromisePairList.Node)ellipses;
                Promise promisedArg = (Promise)promisePairList.getValue();
                expr = promisedArg.getExpression();
            }
        } else {
            expr = exprArgument;
        }
        return SubstituteFunction.substitute(expr, SubstituteFunction.buildContext(context, rho, envArgument));
    }

    private static SubstituteContext buildContext(Context context, Environment rho, SEXP argument) {
        if (argument == Symbol.MISSING_ARG) {
            return SubstituteFunction.buildContext(context, rho);
        }
        SEXP env2 = context.evaluate(argument, rho);
        return SubstituteFunction.buildContext(context, env2);
    }

    private static SubstituteContext buildContext(Context context, SEXP evaluatedEnv) {
        if (evaluatedEnv instanceof Environment) {
            if (context.getGlobalEnvironment() == evaluatedEnv) {
                return new GlobalEnvironmentContext();
            }
            return new EnvironmentContext(context, (Environment)evaluatedEnv);
        }
        if (evaluatedEnv instanceof ListVector) {
            return new ListContext((ListVector)evaluatedEnv);
        }
        if (evaluatedEnv instanceof PairList) {
            return new PairListContext((PairList)evaluatedEnv);
        }
        throw new EvalException("Cannot substitute using environment of type %s: expected list, pairlist, or environment", evaluatedEnv.getTypeName());
    }

    public static SEXP substitute(Context context, SEXP exp2, SEXP environment2) {
        return SubstituteFunction.substitute(exp2, SubstituteFunction.buildContext(context, environment2));
    }

    private static SEXP substitute(SEXP exp2, SubstituteContext context) {
        SubstitutingVisitor visitor = new SubstitutingVisitor(context);
        exp2.accept(visitor);
        return visitor.getResult();
    }

    private static class PairListContext
    implements SubstituteContext {
        private PairList list;

        public PairListContext(PairList list2) {
            this.list = list2;
        }

        @Override
        public SEXP getVariable(Symbol name) {
            for (PairList.Node node : this.list.nodes()) {
                if (node.getTag() != name) continue;
                return node.getValue();
            }
            return Symbol.UNBOUND_VALUE;
        }

        @Override
        public boolean hasVariable(Symbol name) {
            return this.getVariable(name) != Symbol.UNBOUND_VALUE;
        }
    }

    private static class ListContext
    implements SubstituteContext {
        private ListVector list;

        public ListContext(ListVector list2) {
            this.list = list2;
        }

        @Override
        public SEXP getVariable(Symbol name) {
            int index = this.list.getIndexByName(name.getPrintName());
            if (index == -1) {
                return Symbol.UNBOUND_VALUE;
            }
            return this.list.getElementAsSEXP(index);
        }

        @Override
        public boolean hasVariable(Symbol name) {
            return this.list.getIndexByName(name.getPrintName()) != -1;
        }
    }

    private static class GlobalEnvironmentContext
    implements SubstituteContext {
        private GlobalEnvironmentContext() {
        }

        @Override
        public SEXP getVariable(Symbol name) {
            return Symbol.UNBOUND_VALUE;
        }

        @Override
        public boolean hasVariable(Symbol name) {
            return false;
        }
    }

    private static class EnvironmentContext
    implements SubstituteContext {
        private final Environment rho;
        private Context context;

        public EnvironmentContext(Context context, Environment rho) {
            this.rho = rho;
            this.context = context;
        }

        @Override
        public SEXP getVariable(Symbol name) {
            return this.rho.getVariable(this.context, name);
        }

        @Override
        public boolean hasVariable(Symbol name) {
            return this.rho.hasVariable(name);
        }
    }

    private static interface SubstituteContext {
        public SEXP getVariable(Symbol var1);

        public boolean hasVariable(Symbol var1);
    }

    public static class SubstitutingVisitor
    extends SexpVisitor<SEXP> {
        private final SubstituteContext context;
        private SEXP result;

        public SubstitutingVisitor(SubstituteContext context) {
            this.context = context;
        }

        @Override
        public void visit(FunctionCall call2) {
            this.result = new FunctionCall(this.substitute(call2.getFunction()), this.substituteArgumentList(call2.getArguments()), call2.getAttributes());
        }

        private PairList substituteArgumentList(PairList arguments) {
            PairList.Builder builder = PairList.Node.newBuilder();
            for (PairList.Node node : arguments.nodes()) {
                if (node.getValue().equals(Symbols.ELLIPSES)) {
                    SEXP extraArguments = this.context.getVariable(Symbols.ELLIPSES);
                    if (extraArguments != Symbol.UNBOUND_VALUE) {
                        builder.addAll(this.unpackPromiseList((PromisePairList)extraArguments));
                        continue;
                    }
                    builder.add(Symbols.ELLIPSES);
                    continue;
                }
                builder.add(node.getRawTag(), this.substitute(node.getValue()));
            }
            return builder.build();
        }

        @Override
        public void visit(PairList.Node pairList) {
            PairList.Builder builder = PairList.Node.newBuilder();
            for (PairList.Node node : pairList.nodes()) {
                builder.add(node.getRawTag(), this.substitute(node.getValue()));
            }
            this.result = builder.build();
        }

        @Override
        public void visit(ListVector list2) {
            ListVector.Builder builder = ListVector.newBuilder();
            for (SEXP exp2 : list2) {
                builder.add(this.substitute(exp2));
            }
            builder.copyAttributesFrom(list2);
            this.result = builder.build();
        }

        @Override
        public void visit(ExpressionVector vector2) {
            ArrayList<SEXP> list2 = Lists.newArrayList();
            for (SEXP exp2 : vector2) {
                list2.add(this.substitute(exp2));
            }
            this.result = new ExpressionVector((List<SEXP>)list2, vector2.getAttributes());
        }

        @Override
        public void visit(Symbol symbol2) {
            this.result = this.context.hasVariable(symbol2) ? this.unpromise(this.context.getVariable(symbol2)) : symbol2;
        }

        private PairList unpackPromiseList(PromisePairList dotExp) {
            PairList.Builder unpacked = new PairList.Builder();
            for (PairList.Node node : dotExp.nodes()) {
                unpacked.add(node.getRawTag(), this.unpromise(node.getValue()));
            }
            return unpacked.build();
        }

        private SEXP unpromise(SEXP value) {
            while (value instanceof Promise) {
                value = ((Promise)value).getExpression();
            }
            return value;
        }

        @Override
        public void visit(PromisePairList dotExp) {
            super.visit(dotExp);
        }

        @Override
        protected void unhandled(SEXP exp2) {
            this.result = exp2;
        }

        @Override
        public SEXP getResult() {
            return this.result;
        }

        private SEXP substitute(SEXP exp2) {
            return SubstituteFunction.substitute(exp2, this.context);
        }
    }
}

