/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.sequence;

import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.invoke.annotations.Builtin;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.Internal;
import org.renjin.primitives.sequence.DoubleSequence;
import org.renjin.primitives.sequence.IntSequence;
import org.renjin.repackaged.guava.annotations.VisibleForTesting;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Vector;

public class Sequences {
    @Builtin(value=":")
    public static AtomicVector colon(@Current Context context, SEXP n1, SEXP n2) {
        if (n1.inherits("factor") && n2.inherits("factor")) {
            return Sequences.crossColon(n1, n2);
        }
        return Sequences.colonSequence(context, n1, n2);
    }

    private static AtomicVector crossColon(SEXP n1, SEXP n2) {
        throw new UnsupportedOperationException("crossColon not yet implemented");
    }

    public static AtomicVector colonSequence(Context context, SEXP s1, SEXP s2) {
        Sequences.assertScalar(context, s1);
        Sequences.assertScalar(context, s2);
        double n1 = s1.asReal();
        double n2 = s2.asReal();
        Sequences.assertNotNa(n1);
        Sequences.assertNotNa(n2);
        return new Range(n1, n2).vector();
    }

    private static void assertNotNa(double r1) {
        if (DoubleVector.isNaN(r1)) {
            throw new EvalException("NA/NaN argument", new Object[0]);
        }
    }

    private static void assertScalar(Context context, SEXP exp2) {
        if (exp2.length() == 0) {
            throw new EvalException("argument of length 0", new Object[0]);
        }
        if (exp2.length() > 1) {
            context.warn(String.format("numerical expression has %d elements: only the first used", exp2.length()));
        }
    }

    @Internal(value="rep.int")
    public static Vector repeatInt(Vector x, Vector timesVector) {
        if (timesVector.length() == 1) {
            int times2;
            Vector.Builder result = x.newBuilderWithInitialSize(x.length() * times2);
            int count = 0;
            for (times2 = timesVector.getElementAsInt(0); times2 > 0; --times2) {
                for (int i = 0; i != x.length(); ++i) {
                    result.setFrom(count++, x, i);
                }
            }
            return result.build();
        }
        if (timesVector.length() != x.length()) {
            throw new EvalException("Invalid 'times' value: times must be the same length as x", new Object[0]);
        }
        Vector.Builder result = x.newBuilderWithInitialCapacity(x.length());
        for (int i = 0; i != x.length(); ++i) {
            for (int times3 = timesVector.getElementAsInt(i); times3 > 0; --times3) {
                result.addFrom(x, i);
            }
        }
        return result.build();
    }

    @Builtin
    public static IntVector seq_along(SEXP exp2) {
        return new IntSequence(1, 1, exp2.length());
    }

    @Builtin
    public static IntVector seq_len(int length2) {
        return new IntSequence(1, 1, length2);
    }

    private static SEXP newSequence(double from, double by, double to, int length2) {
        if (Sequences.isIntegerRange(from, to, by)) {
            return new IntSequence((int)from, (int)by, length2);
        }
        return new DoubleSequence(from, by, length2);
    }

    private static boolean isIntegerRange(double from, double to, double by) {
        return by == (double)((int)by) && from <= 2.147483647E9 && from >= -2.147483648E9 && to <= 2.147483647E9 && to >= -2.147483648E9;
    }

    @VisibleForTesting
    static class Range {
        boolean useInteger;
        private double range;
        double count;
        final double n1;
        final double n2;

        public Range(double n1, double n2) {
            this.n1 = n1;
            this.n2 = n2;
            this.range = Math.abs(n2 - n1);
            this.count = this.range + 1.0 + 2.220446E-16;
            this.determineType();
        }

        private void determineType() {
            int in1 = (int)this.n1;
            boolean bl = this.useInteger = this.n1 == (double)in1;
            if (this.useInteger) {
                if (this.n1 <= -2.147483648E9 || this.n1 > 2.147483647E9) {
                    this.useInteger = false;
                } else {
                    double upperBound = this.n1 + (this.n1 <= this.n2 ? this.count - 1.0 : -(this.count - 1.0));
                    if (upperBound <= -2.147483648E9 || upperBound > 2.147483647E9) {
                        this.useInteger = false;
                    }
                }
            }
        }

        public AtomicVector vector() {
            if (this.useInteger) {
                return IntSequence.fromTo(this.n1, this.n2);
            }
            return DoubleSequence.fromTo(this.n1, this.n2);
        }
    }
}

