/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.packaging;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Optional;
import org.renjin.eval.EvalException;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.ExternalPtr;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringArrayVector;
import org.renjin.sexp.Symbols;

public class DllSymbol {
    private final String name;
    private final MethodHandle methodHandle;
    private final Optional<Convention> convention;
    private final boolean registered;

    public DllSymbol(String name, MethodHandle methodHandle, Convention convention, boolean registered) {
        if (methodHandle == null) {
            throw new NullPointerException("Null method handle for symbol '" + name + "'");
        }
        this.name = name;
        this.methodHandle = methodHandle;
        this.convention = Optional.of(convention);
        this.registered = registered;
    }

    @Deprecated
    public DllSymbol(String name, MethodHandle methodHandle, Convention convention) {
        this(name, methodHandle, convention, true);
    }

    public DllSymbol(Convention convention, Method method) {
        this(Optional.of(convention), method);
    }

    public DllSymbol(Optional<Convention> convention, Method method) {
        this.name = method.getName();
        this.registered = false;
        this.convention = convention;
        try {
            this.methodHandle = MethodHandles.publicLookup().unreflect(method);
        }
        catch (IllegalAccessException e) {
            throw new EvalException("Cannot access method '%s': %s", method.getName(), e.getMessage(), e);
        }
        if (this.methodHandle == null) {
            throw new NullPointerException("unreflect() returned null for " + method);
        }
    }

    public String getName() {
        return this.name;
    }

    public MethodHandle getMethodHandle() {
        return this.methodHandle;
    }

    public Convention getConvention() {
        return this.convention.orElse(null);
    }

    public ListVector buildNativeSymbolInfoSexp() {
        ListVector.NamedBuilder symbol2 = new ListVector.NamedBuilder();
        symbol2.add("name", this.name);
        symbol2.add("address", this.buildAddressSexp());
        symbol2.add("numParameters", this.methodHandle.type().parameterCount());
        if (this.convention.isPresent()) {
            symbol2.setAttribute(Symbols.CLASS, (SEXP)new StringArrayVector(this.convention.get().getClassName(), "NativeSymbolInfo"));
        } else {
            symbol2.setAttribute(Symbols.CLASS, (SEXP)new StringArrayVector("NativeSymbolInfo"));
        }
        return symbol2.build();
    }

    private ExternalPtr<MethodHandle> buildAddressSexp() {
        AttributeMap.Builder attributes2 = AttributeMap.builder();
        if (this.registered) {
            attributes2.setClass("RegisteredNativeSymbol");
        } else {
            attributes2.setClass("NativeSymbol");
        }
        return new ExternalPtr<MethodHandle>(this.methodHandle, attributes2.build());
    }

    public static DllSymbol fromSexp(SEXP method) {
        ListVector list2 = (ListVector)method;
        String name = list2.getElementAsString("name");
        ExternalPtr address = (ExternalPtr)list2.get("address");
        Convention convention = DllSymbol.conventionFromClass(method);
        boolean registered = address.inherits("RegisteredNativeSymbol");
        return new DllSymbol(name, (MethodHandle)address.getInstance(), convention, registered);
    }

    public static DllSymbol fromAddressSexp(SEXP method) {
        ExternalPtr address = (ExternalPtr)method;
        boolean registered = address.inherits("RegisteredNativeSymbol");
        return new DllSymbol("native", (MethodHandle)address.getInstance(), Convention.C, registered);
    }

    private static Convention conventionFromClass(SEXP method) {
        for (Convention convention : Convention.values()) {
            if (!method.inherits(convention.getClassName())) continue;
            return convention;
        }
        return Convention.C;
    }

    public static enum Convention {
        C("CRoutine"),
        CALL("CallRoutine"),
        FORTRAN("FortranRoutine"),
        EXTERNAL("ExternalRoutine");

        private String className;

        private Convention(String className) {
            this.className = className;
        }

        public String getClassName() {
            return this.className;
        }
    }
}

