/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.io;

import java.io.IOException;
import java.io.PrintWriter;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.Internal;
import org.renjin.invoke.annotations.Invisible;
import org.renjin.primitives.io.connections.Connections;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.RawVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.SexpVisitor;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;

public class Cat
extends SexpVisitor<String> {
    private final PrintWriter writer;
    private String separator;
    private boolean needsSeparator = false;
    private int fill;

    @Internal
    @Invisible
    public static void cat(@Current Context context, ListVector list2, SEXP connection2, String sep, int fill, SEXP labels, boolean append2) throws IOException {
        list2 = context.materialize(list2);
        PrintWriter printWriter = Connections.getConnection(context, connection2).getPrintWriter();
        Cat visitor = new Cat(printWriter, sep, 0);
        for (SEXP element : list2) {
            element.accept(visitor);
            if (fill <= 0) continue;
            printWriter.println();
        }
        if (sep.contains("\n")) {
            printWriter.println();
        }
        printWriter.flush();
    }

    private Cat(PrintWriter writer, String separator, int fill) {
        this.writer = writer;
        this.separator = separator;
        this.fill = fill;
    }

    @Override
    public void visit(StringVector vector2) {
        this.catVector(vector2);
    }

    @Override
    public void visit(IntVector vector2) {
        this.catVector(vector2);
    }

    @Override
    public void visit(LogicalVector vector2) {
        this.catVector(vector2);
    }

    @Override
    public void visit(Null nullExpression) {
    }

    @Override
    public void visit(DoubleVector vector2) {
        this.catVector(vector2);
    }

    private void catVector(AtomicVector vector2) {
        for (int i = 0; i != vector2.length(); ++i) {
            this.catElement(vector2.getElementAsString(i));
        }
    }

    @Override
    public void visit(Symbol symbol2) {
        this.catElement(symbol2.getPrintName());
    }

    private void catElement(String element) {
        if (this.needsSeparator) {
            this.writer.print(this.separator);
        } else {
            this.needsSeparator = true;
        }
        this.writer.print(element);
    }

    @Override
    public void visit(RawVector vector2) {
        this.catVector(vector2);
    }

    @Override
    protected void unhandled(SEXP exp2) {
        throw new EvalException("argument of type '%s' cannot be handled by 'cat'", exp2.getTypeName());
    }
}

