/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives;

import java.io.PrintWriter;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.eval.Options;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.Internal;
import org.renjin.sexp.AbstractSEXP;
import org.renjin.sexp.Environment;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;

public class Warning {
    public static final Symbol LAST_WARNING = Symbol.get("last.warning");

    @Internal
    public static void warning(@Current Context context, boolean call2, boolean immediate, String message) {
        SEXP callSexp = call2 ? Warning.findCurrentCall(context, 1) : Null.INSTANCE;
        Warning.warning(context, callSexp, immediate, message);
    }

    public static void warning(Context context, SEXP call2, boolean immediate, String message) {
        AbstractSEXP quoteCall = call2 == Null.INSTANCE ? Null.INSTANCE : FunctionCall.newCall(Symbol.get("quote"), call2);
        FunctionCall signalCall = FunctionCall.newCall(Symbol.get(".signalSimpleWarning"), StringVector.valueOf(message), quoteCall, LogicalVector.valueOf(immediate));
        context.evaluate(signalCall, context.getGlobalEnvironment());
    }

    private static SEXP findCurrentCall(Context context, int toSkip) {
        while (!context.isTopLevel()) {
            if (context.getCall() != null) {
                if (toSkip == 0) {
                    return context.getCall();
                }
                --toSkip;
            }
            context = context.getParent();
        }
        return Null.INSTANCE;
    }

    @Internal(value=".dfltWarn")
    public static void defaultWarning(@Current Context context, String message, SEXP call2, boolean immediate) {
        SEXP warningExpression = context.getSession().getSingleton(Options.class).get("warning.expression");
        if (warningExpression != Null.INSTANCE) {
            context.evaluate(warningExpression, context.getGlobalEnvironment());
            return;
        }
        int warnMode = context.getSession().getSingleton(Options.class).getInt("warn", 0);
        if (IntVector.isNA(warnMode)) {
            warnMode = 0;
        }
        if (warnMode >= 2) {
            throw new EvalException(String.format("(converted from warning) %s", message), new Object[0]);
        }
        if (warnMode == 1 || warnMode <= 0 && immediate) {
            PrintWriter stderr2 = context.getSession().getEffectiveStdErr();
            stderr2.println("Warning in " + call2.toString() + " :");
            stderr2.println("  " + message);
            return;
        }
        ListVector.NamedBuilder lastWarning = new ListVector.NamedBuilder();
        Environment baseEnv = context.getBaseEnvironment();
        if (baseEnv.hasVariable(LAST_WARNING)) {
            lastWarning.addAll((ListVector)baseEnv.getVariable(context, LAST_WARNING).force(context));
        }
        lastWarning.add(message, call2);
        baseEnv.setVariable(context, LAST_WARNING, (SEXP)lastWarning.build());
    }

    @Internal
    public static void printDeferredWarnings(@Current Context context) {
        context.getSession().getEffectiveStdErr().println("In addition: (TODO)");
    }
}

