/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.renjin.eval.Context;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.Internal;
import org.renjin.parser.NumericLiterals;
import org.renjin.primitives.io.connections.Connections;
import org.renjin.primitives.io.connections.PushbackBufferedReader;
import org.renjin.repackaged.guava.base.Strings;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

public class Scan {
    @Internal
    public static Vector scan(@Current Context context, SEXP file2, Vector what, int nmax, String seperator, String dec, String quote, int skip, int nlines, StringVector naStrings, boolean flush2, boolean fill, boolean stripWhite, boolean quiet, boolean blankLinesSkip, boolean multiLine, String commentChar, boolean allowEscapes, String encoding) throws IOException {
        String line;
        PushbackBufferedReader lineReader;
        if (file2 instanceof StringVector) {
            String fileName = ((StringVector)file2).getElementAsString(0);
            if (fileName.length() == 0) {
                lineReader = context.getSession().getConnectionTable().getStdin().getReader();
            } else {
                IntVector fileConn = Connections.file(context, fileName, "o", true, encoding, false);
                lineReader = Connections.getConnection(context, fileConn).getReader();
            }
        } else {
            lineReader = Connections.getConnection(context, file2).getReader();
        }
        Splitter splitter = Strings.isNullOrEmpty(seperator) ? new WhitespaceSplitter(quote) : new CharSplitter(quote, seperator);
        Scanner scanner = what instanceof ListVector ? new ListReader((ListVector)what, splitter, dec.charAt(0)) : new ScalarReader(Scan.getAtomicScanner(what, dec.charAt(0)), splitter);
        int linesRead = 0;
        int linesSkipped = 0;
        while ((linesRead < nlines || nlines <= 0) && (line = lineReader.readLine()) != null) {
            if (linesSkipped < skip) {
                ++linesSkipped;
                continue;
            }
            ++linesRead;
            if (blankLinesSkip && line.isEmpty() || !Strings.isNullOrEmpty(commentChar) && line.startsWith(commentChar)) continue;
            scanner.read(line);
        }
        return scanner.build();
    }

    private static Scanner getAtomicScanner(SEXP exp2, char decimal) {
        if (exp2 instanceof StringVector) {
            return new StringReader();
        }
        if (exp2 instanceof DoubleVector) {
            return new DoubleReader(decimal);
        }
        if (exp2 instanceof IntVector) {
            return new IntReader();
        }
        throw new UnsupportedOperationException(String.format("column type '%s' not implemented", exp2.getTypeName()));
    }

    static class WhitespaceSplitter
    implements Splitter {
        private final char quote;

        public WhitespaceSplitter(String quote) {
            this.quote = quote.isEmpty() ? (char)'\u0000' : quote.charAt(0);
        }

        @Override
        public List<String> split(String line) {
            StringBuilder sb = new StringBuilder();
            ArrayList<String> fields = Lists.newArrayList();
            boolean quoted = false;
            for (int i = 0; i != line.length(); ++i) {
                char c2 = line.charAt(i);
                if (this.quote != '\u0000' && c2 == this.quote) {
                    quoted = !quoted;
                    continue;
                }
                if (!quoted && Character.isWhitespace(c2)) {
                    if (sb.length() <= 0) continue;
                    fields.add(sb.toString());
                    sb.setLength(0);
                    continue;
                }
                sb.append(c2);
            }
            if (sb.length() > 0) {
                fields.add(sb.toString());
            }
            return fields;
        }
    }

    static class CharSplitter
    implements Splitter {
        private char quote;
        private char separator;

        public CharSplitter(String quote, String separator) {
            this.quote = quote.isEmpty() ? (char)'\u0000' : quote.charAt(0);
            this.separator = separator.charAt(0);
        }

        @Override
        public List<String> split(String line) {
            StringBuilder sb = new StringBuilder();
            ArrayList<String> fields = Lists.newArrayList();
            boolean quoted = false;
            for (int i = 0; i != line.length(); ++i) {
                char c2 = line.charAt(i);
                if (this.quote != '\u0000' && c2 == this.quote) {
                    quoted = !quoted;
                    continue;
                }
                if (!quoted && c2 == this.separator) {
                    fields.add(sb.toString());
                    sb.setLength(0);
                    continue;
                }
                sb.append(c2);
            }
            fields.add(sb.toString());
            return fields;
        }
    }

    static interface Splitter {
        public List<String> split(String var1);
    }

    private static class ListReader
    implements Scanner {
        private Splitter splitter;
        private StringVector names;
        private List<Scanner> columnReaders = Lists.newArrayList();

        public ListReader(ListVector columns, Splitter splitter, char decimal) {
            this.splitter = splitter;
            this.names = (StringVector)columns.getAttribute(Symbols.NAMES);
            for (SEXP column : columns) {
                this.columnReaders.add(Scan.getAtomicScanner(column, decimal));
            }
        }

        @Override
        public void read(String line) {
            List<String> fields = this.splitter.split(line);
            for (int i = 0; i != fields.size(); ++i) {
                this.columnReaders.get(i).read(fields.get(i));
            }
        }

        @Override
        public Vector build() {
            ListVector.Builder result = new ListVector.Builder();
            for (Scanner scanner : this.columnReaders) {
                result.add(scanner.build());
            }
            result.setAttribute(Symbols.NAMES, (SEXP)this.names);
            return result.build();
        }
    }

    private static class ScalarReader
    implements Scanner {
        private Splitter splitter;
        private Scanner columnReader;

        public ScalarReader(Scanner scanner, Splitter splitter) {
            this.splitter = splitter;
            this.columnReader = scanner;
        }

        @Override
        public void read(String line) {
            List<String> fields = this.splitter.split(line);
            for (int i = 0; i != fields.size(); ++i) {
                this.columnReader.read(fields.get(i));
            }
        }

        @Override
        public Vector build() {
            return this.columnReader.build();
        }
    }

    private static class IntReader
    implements Scanner {
        private final IntArrayVector.Builder builder = new IntArrayVector.Builder();

        private IntReader() {
        }

        @Override
        public void read(String line) {
            this.builder.add(NumericLiterals.parseInt(line));
        }

        @Override
        public Vector build() {
            return this.builder.build();
        }
    }

    private static class DoubleReader
    implements Scanner {
        private final char decimal;
        private final DoubleArrayVector.Builder builder;

        private DoubleReader(char decimal) {
            this.decimal = decimal;
            this.builder = new DoubleArrayVector.Builder();
        }

        @Override
        public void read(String line) {
            this.builder.add(NumericLiterals.parseDouble(line, 0, line.length(), this.decimal, false));
        }

        @Override
        public Vector build() {
            return this.builder.build();
        }
    }

    private static class StringReader
    implements Scanner {
        private final StringVector.Builder builder = new StringVector.Builder();

        private StringReader() {
        }

        @Override
        public void read(String value) {
            this.builder.add(value);
        }

        @Override
        public StringVector build() {
            return this.builder.build();
        }
    }

    static interface Scanner {
        public void read(String var1);

        public Vector build();
    }
}

