/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives;

import org.apache.commons.math.complex.Complex;
import org.renjin.appl.Appl;
import org.renjin.eval.EvalException;
import org.renjin.gcc.runtime.DoublePtr;
import org.renjin.gcc.runtime.IntPtr;
import org.renjin.invoke.annotations.Internal;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.ComplexArrayVector;
import org.renjin.sexp.ComplexVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.SEXP;

public class Polyroot {
    @Internal
    public static SEXP polyroot(AtomicVector z) {
        if (!(z instanceof ComplexVector || z instanceof DoubleVector || z instanceof IntVector || z instanceof LogicalVector)) {
            throw new EvalException("unsupported vector type: " + z.getTypeName(), new Object[0]);
        }
        int n = z.length();
        int degree = 0;
        for (int i = 0; i < n; ++i) {
            double re = z.getElementAsDouble(i);
            double im = z.getElementAsComplexIm(i);
            if (re == 0.0 && im == 0.0) continue;
            degree = i;
        }
        n = degree + 1;
        if (degree >= 1) {
            double[] rr = new double[n];
            double[] ri = new double[n];
            double[] zr = new double[n];
            double[] zi = new double[n];
            for (int i = 0; i < n; ++i) {
                double re = z.getElementAsDouble(i);
                double im = z.getElementAsComplexIm(i);
                if (!DoubleVector.isFinite(re) || !DoubleVector.isFinite(im)) {
                    throw new EvalException("invalid polynomial coefficient", new Object[0]);
                }
                zr[degree - i] = re;
                zi[degree - i] = im;
            }
            IntPtr fail = new IntPtr(0);
            Appl.cpolyroot(new DoublePtr(zr), new DoublePtr(zi), new IntPtr(degree), new DoublePtr(rr), new DoublePtr(ri), fail);
            if (fail.unwrap() != 0) {
                throw new EvalException("root finding code failed", new Object[0]);
            }
            ComplexArrayVector.Builder result = new ComplexArrayVector.Builder(degree);
            for (int i = 0; i < degree; ++i) {
                result.set(i, rr[i], ri[i]);
            }
            return result.build();
        }
        return new ComplexArrayVector(new Complex[0]);
    }
}

