/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.eval.FinalizationClosure;
import org.renjin.eval.Session;
import org.renjin.invoke.annotations.Builtin;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.DataParallel;
import org.renjin.invoke.annotations.Internal;
import org.renjin.invoke.annotations.Invisible;
import org.renjin.invoke.annotations.Recycle;
import org.renjin.primitives.Vectors;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.Closure;
import org.renjin.sexp.Environment;
import org.renjin.sexp.HasNamedValues;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.NamedValue;
import org.renjin.sexp.Null;
import org.renjin.sexp.S4Object;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringArrayVector;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;

public final class Environments {
    private Environments() {
    }

    @Builtin
    public static Environment asEnvironment(Environment arg) {
        return arg;
    }

    @Internal
    public static ListVector env2list(@Current Context context, Environment env2, boolean allNames) {
        ListVector.NamedBuilder list2 = new ListVector.NamedBuilder();
        for (Symbol name : env2.getSymbolNames()) {
            if (!allNames && name.getPrintName().startsWith(".")) continue;
            list2.add(name, env2.getVariable(context, name));
        }
        return list2.build();
    }

    @Internal
    public static Environment list2env(@Current Context context, ListVector list2, Environment env2) {
        AtomicVector names2 = list2.getNames();
        if (names2.length() != list2.length()) {
            throw new EvalException("names(x) must be a character vector of the same length as x", new Object[0]);
        }
        for (NamedValue namedValue : list2.namedValues()) {
            env2.setVariable(context, namedValue.getName(), namedValue.getValue());
        }
        return env2;
    }

    @Builtin(value="as.environment")
    public static Environment asEnvironment(@Current Context context, int pos) {
        Environment env2;
        if (IntVector.isNA(pos) || pos < -1 || pos == 0) {
            throw new EvalException("invalid 'pos' argument", new Object[0]);
        }
        if (pos == -1) {
            Context cptr = context;
            while (context.getType() != Context.Type.FUNCTION && !cptr.isTopLevel()) {
                cptr = cptr.getParent();
            }
            if (cptr.getType() != Context.Type.FUNCTION) {
                throw new EvalException("no enclosing environment", new Object[0]);
            }
            env2 = cptr.getCallingEnvironment();
            if (env2 == null) {
                throw new EvalException("invalid 'pos' argument", new Object[0]);
            }
        } else {
            for (env2 = context.getGlobalEnvironment(); env2 != Environment.EMPTY && pos > 1; --pos, env2 = env2.getParent()) {
            }
            if (pos != 1) {
                throw new EvalException("invalid 'pos' argument", new Object[0]);
            }
        }
        return env2;
    }

    @Builtin(value="as.environment")
    public static Environment asEnvironment(@Current Context context, String name) {
        if (name.equals(".GlobalEnv")) {
            return context.getGlobalEnvironment();
        }
        for (Environment result = context.getEnvironment(); result != Environment.EMPTY; result = result.getParent()) {
            if (Objects.equals(result.getName(), name)) {
                return result;
            }
            if (!name.equals("package:base") || result != context.getBaseEnvironment()) continue;
            return result;
        }
        throw new EvalException("no environment called '%s' on the search list", name);
    }

    @Builtin(value="as.environment")
    public static Environment asEnvironment(ListVector list2) {
        Environment.Builder env2 = Environment.createChildEnvironment(Environment.EMPTY);
        for (NamedValue namedValue : list2.namedValues()) {
            env2.setVariable(Symbol.get(namedValue.getName()), namedValue.getValue());
        }
        return env2.build();
    }

    @Builtin(value="as.environment")
    public static Environment asEnvironment(S4Object obj) {
        SEXP env2 = obj.getAttribute(Symbol.get(".xData"));
        if (env2 instanceof Environment) {
            return (Environment)env2;
        }
        throw new EvalException("object does not extend 'environment'", new Object[0]);
    }

    @Internal
    public static String environmentName(Environment env2) {
        return env2.getName();
    }

    @Internal(value="parent.env")
    public static Environment getParentEnv(Environment environment2) {
        return environment2.getParent();
    }

    @Internal(value="parent.env<-")
    public static Environment setParentEnv(Environment environment2, Environment newParent) {
        environment2.setParent(newParent);
        return environment2;
    }

    @Internal
    public static StringVector ls(Environment environment2, boolean allNames) {
        StringVector.Builder names2 = new StringVector.Builder();
        for (Symbol name : environment2.getSymbolNames()) {
            if (!allNames && name.getPrintName().startsWith(".")) continue;
            names2.add(name.getPrintName());
        }
        return names2.build();
    }

    @Internal
    public static void lockEnvironment(Environment env2, boolean bindings) {
        env2.lock(bindings);
    }

    @Internal
    public static void lockBinding(Symbol name, Environment env2) {
        env2.lockBinding(name);
    }

    @Internal
    public static void unlockBinding(Symbol name, Environment env2) {
        env2.unlockBinding(name);
    }

    @Internal
    public static boolean bindingIsLocked(Symbol name, Environment env2) {
        return env2.bindingIsLocked(name);
    }

    @Internal
    public static boolean environmentIsLocked(Environment env2) {
        return env2.isLocked();
    }

    @Internal
    public static boolean bindingIsActive(Symbol symbol2, Environment env2) {
        return env2.isActiveBinding(symbol2);
    }

    @Internal
    public static void makeActiveBinding(Symbol sym, Closure closure, Environment env2) {
        env2.makeActiveBinding(sym, closure);
    }

    @Internal(value="lib.fixup")
    public static Environment libfixup(@Current Context context, Environment loadEnv, Environment libEnv) {
        for (Symbol name : loadEnv.getSymbolNames()) {
            Closure closure;
            SEXP value = loadEnv.getVariable(context, name);
            if (value instanceof Closure && (closure = (Closure)value).getEnclosingEnvironment() == loadEnv) {
                value = closure.setEnclosingEnvironment(libEnv);
            }
            loadEnv.setVariable(context, name, value);
        }
        return libEnv;
    }

    @Internal
    public static Environment environment(@Current Context context) {
        return context.getParent().getEnvironment();
    }

    @Internal
    public static SEXP environment(@Current Context context, SEXP exp2) {
        if (exp2 == Null.INSTANCE) {
            return context.getCallingEnvironment();
        }
        if (exp2 instanceof Closure) {
            return ((Closure)exp2).getEnclosingEnvironment();
        }
        return exp2.getAttribute(Symbols.DOT_ENVIRONMENT);
    }

    @Builtin(value="environment<-")
    public static SEXP setEnvironment(SEXP exp2, Environment newRho) {
        if (exp2 instanceof Closure) {
            return ((Closure)exp2).setEnclosingEnvironment(newRho);
        }
        return exp2.setAttribute(Symbols.DOT_ENVIRONMENT.getPrintName(), (SEXP)newRho);
    }

    @Internal(value="new.env")
    public static Environment newEnv(boolean hash, Environment parent2, int size) {
        return Environment.createChildEnvironment(parent2).build();
    }

    @Builtin
    public static Environment baseenv(@Current Context context) {
        return context.getBaseEnvironment();
    }

    @Builtin
    public static Environment emptyenv() {
        return Environment.EMPTY;
    }

    @Builtin
    public static Environment globalenv(@Current Context context) {
        return context.getGlobalEnvironment();
    }

    @Internal
    @DataParallel
    public static boolean exists(@Current Context context, @Recycle String x, Environment environment2, String mode, boolean inherits2) {
        if ("any".equals(mode)) {
            return Environments.existsAnySymbol(Symbol.get(x), environment2, inherits2);
        }
        return environment2.findVariable(context, Symbol.get(x), Vectors.modePredicate(mode), inherits2) != Symbol.UNBOUND_VALUE;
    }

    private static boolean existsAnySymbol(Symbol symbol2, Environment environment2, boolean inherits2) {
        if (environment2.exists(symbol2)) {
            return true;
        }
        if (inherits2 && environment2.getParent() != Environment.EMPTY) {
            return Environments.existsAnySymbol(symbol2, environment2.getParent(), inherits2);
        }
        return false;
    }

    @Internal
    public static SEXP get(@Current Context context, String x, Environment environment2, String mode, boolean inherits2) {
        SEXP value = environment2.findVariable(context, Symbol.get(x), Vectors.modePredicate(mode), inherits2);
        if (value == Symbol.UNBOUND_VALUE) {
            throw new EvalException("Object '%s' not found", StringVector.isNA(x) ? "NA" : x);
        }
        return value;
    }

    @Internal
    public static SEXP mget(@Current Context context, StringVector x, Environment environment2, String mode, SEXP defaultValue, boolean inherits2) {
        Predicate<SEXP> predicate = Vectors.modePredicate(mode);
        ListVector.NamedBuilder result = new ListVector.NamedBuilder();
        for (String name : x) {
            SEXP value = environment2.findVariable(context, Symbol.get(name), predicate, inherits2);
            if (value == Symbol.UNBOUND_VALUE) {
                result.add(name, defaultValue);
                continue;
            }
            result.add(name, value);
        }
        return result.build();
    }

    @Internal
    public static SEXP get0(@Current Context context, String x, Environment environment2, String mode, boolean inherits2, SEXP ifnotfound) {
        SEXP value = environment2.findVariable(context, Symbol.get(x), Vectors.modePredicate(mode), inherits2);
        if (value == Symbol.UNBOUND_VALUE) {
            return ifnotfound;
        }
        return value;
    }

    @Internal
    public static StringVector search(@Current Context context) {
        ArrayList<String> names2 = Lists.newArrayList();
        for (Environment env2 = context.getGlobalEnvironment(); env2 != Environment.EMPTY; env2 = env2.getParent()) {
            if (context.getNamespaceRegistry().isNamespaceEnv(env2)) {
                names2.add("namespace:" + env2.getName());
                continue;
            }
            names2.add(env2.getName());
        }
        names2.set(0, ".GlobalEnv");
        names2.set(names2.size() - 1, "package:base");
        return new StringArrayVector((Collection<String>)names2);
    }

    @Invisible
    @Internal
    public static Environment attach(@Current Context context, SEXP what, int pos, String name) {
        if (pos < 2) {
            throw new EvalException("Attachment position must be 2 or greater", new Object[0]);
        }
        Environment child = context.getGlobalEnvironment();
        for (int i = 2; i != pos; ++i) {
            child = child.getParent();
        }
        Environment newEnv = Environment.createChildEnvironment(child.getParent()).build();
        child.setParent(newEnv);
        newEnv.setAttribute(Symbols.NAME.getPrintName(), (SEXP)StringVector.valueOf(name));
        if (what instanceof HasNamedValues) {
            for (NamedValue namedValue : ((HasNamedValues)what).namedValues()) {
                if (!namedValue.hasName()) {
                    throw new UnsupportedOperationException("all elements of a list must be named");
                }
                newEnv.setVariable(context, namedValue.getName(), namedValue.getValue());
            }
        } else {
            throw new EvalException("object of type '%s' cannot be attached", what.getTypeName());
        }
        return newEnv;
    }

    @Internal
    public static void detach(@Current Context context, int pos) {
        Environment env2;
        if (pos < 2) {
            throw new EvalException("Attachment position must be 2 or greater", new Object[0]);
        }
        Environment before = null;
        for (env2 = context.getGlobalEnvironment(); pos > 1 && env2 != Environment.EMPTY; env2 = env2.getParent(), --pos) {
            before = env2;
        }
        if (env2 == Environment.EMPTY) {
            throw new EvalException("No such environment", new Object[0]);
        }
        before.setParent(env2.getParent());
    }

    @Internal(value="reg.finalizer")
    public static void registerFinalizer(@Current Session session, Environment environment2, Closure function2, boolean onExit) {
        session.registerFinalizer(environment2, new FinalizationClosure(function2), onExit);
    }
}

