/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives;

import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.invoke.annotations.Builtin;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.Generic;
import org.renjin.invoke.annotations.Internal;
import org.renjin.invoke.annotations.InvokeAsCharacter;
import org.renjin.primitives.Types;
import org.renjin.s4.S4;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.NamedValue;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.S4Object;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

public class Attributes {
    private Attributes() {
    }

    public static IntVector validateDim(SEXP sexp2, SEXP attributeValue) {
        if (!(attributeValue instanceof Vector)) {
            throw new EvalException("Invalid dim: " + attributeValue, new Object[0]);
        }
        Vector vector2 = (Vector)attributeValue;
        int[] dim2 = new int[vector2.length()];
        int prod2 = 1;
        for (int i = 0; i != vector2.length(); ++i) {
            dim2[i] = vector2.getElementAsInt(i);
            if (dim2[i] < 0) {
                throw new EvalException("the dims contain negative values", new Object[0]);
            }
            prod2 *= dim2[i];
        }
        if (prod2 != sexp2.length()) {
            throw new EvalException("dims [product %d] do not match the length of object [%d]", prod2, sexp2.length());
        }
        return new IntArrayVector(dim2);
    }

    public static PairList expandAttributes(PairList attributes2) {
        PairList.Builder result = new PairList.Builder();
        for (PairList.Node node : attributes2.nodes()) {
            result.add(node.getTag(), Attributes.postProcessAttributeValue(node.getTag(), node.getValue()));
        }
        return result.build();
    }

    public static SEXP postProcessAttributeValue(Symbol name, SEXP value) {
        return value;
    }

    @Generic
    @Builtin(value="dim")
    public static SEXP getDimensions(SEXP sexp2) {
        return sexp2.getAttribute(Symbols.DIM);
    }

    @Generic
    @Builtin(value="dim<-")
    public static SEXP setDimensions(SEXP exp2, AtomicVector vector2) {
        if (!(exp2 instanceof Vector) && !(exp2 instanceof PairList) || exp2 instanceof FunctionCall) {
            throw new EvalException("cannot set dim() on object of type '%s'", exp2.getTypeName());
        }
        AttributeMap.Builder newAttributes = exp2.getAttributes().copy();
        if (vector2 == Null.INSTANCE) {
            newAttributes.removeDim();
        } else {
            newAttributes.setDim(vector2);
        }
        newAttributes.remove(Symbols.NAMES);
        newAttributes.removeDimnames();
        return exp2.setAttributes(newAttributes);
    }

    @Generic
    @Builtin(value="dimnames")
    public static SEXP getDimensionNames(SEXP exp2) {
        return exp2.getAttribute(Symbols.DIMNAMES);
    }

    @Generic
    @Builtin(value="dimnames<-")
    public static SEXP setDimensionNames(@Current Context context, SEXP exp2, ListVector dimnames2) {
        if (dimnames2.length() == 0) {
            return exp2.setAttribute(Symbols.DIMNAMES, (SEXP)Null.INSTANCE);
        }
        ListVector.Builder dn = new ListVector.Builder();
        dn.setAttribute(Symbols.NAMES, (SEXP)dimnames2.getNames());
        for (SEXP names2 : dimnames2) {
            if (names2 != Null.INSTANCE && !(names2 instanceof StringVector)) {
                names2 = context.evaluate(FunctionCall.newCall(Symbol.get("as.character"), names2));
            }
            dn.add(names2);
        }
        return exp2.setAttribute(Symbols.DIMNAMES, (SEXP)dn.build());
    }

    @Generic
    @Builtin(value="dimnames<-")
    public static SEXP setDimensionNames(@Current Context context, SEXP exp2, Null nz) {
        return exp2.setAttribute(Symbols.DIMNAMES, (SEXP)Null.INSTANCE);
    }

    @Builtin
    public static Vector attributes(SEXP sexp2) {
        AttributeMap attributes2 = sexp2.getAttributes();
        if (attributes2 == AttributeMap.EMPTY) {
            return Null.INSTANCE;
        }
        ListVector.NamedBuilder list2 = new ListVector.NamedBuilder();
        for (Symbol name : attributes2.names()) {
            list2.add(name, Attributes.postProcessAttributeValue(name, attributes2.get(name)));
        }
        return list2.build();
    }

    @Builtin(value="attr")
    public static SEXP getAttribute(SEXP exp2, String which2, boolean exact) {
        SEXP partialMatch = null;
        int partialMatchCount = 0;
        AttributeMap attributes2 = exp2.getAttributes();
        for (Symbol name : attributes2.names()) {
            if (name.getPrintName().equals(which2)) {
                return Attributes.postProcessAttributeValue(name, attributes2.get(name));
            }
            if (exact || !name.getPrintName().startsWith(which2)) continue;
            partialMatch = Attributes.postProcessAttributeValue(name, attributes2.get(name));
            ++partialMatchCount;
        }
        return partialMatchCount == 1 ? partialMatch : Null.INSTANCE;
    }

    @Builtin(value="attr")
    public static SEXP getAttribute(SEXP exp2, String which2) {
        return Attributes.getAttribute(exp2, which2, false);
    }

    @Builtin(value="attributes<-")
    public static SEXP setAttributes(SEXP exp2, ListVector attributes2) {
        return Attributes.setAttributes(exp2, attributes2.namedValues());
    }

    @Builtin(value="attributes<-")
    public static SEXP setAttributes(SEXP exp2, PairList list2) {
        return Attributes.setAttributes(exp2, list2.nodes());
    }

    public static SEXP setAttributes(SEXP exp2, Iterable<? extends NamedValue> attributes2) {
        AttributeMap.Builder builder = AttributeMap.builder();
        for (NamedValue namedValue : attributes2) {
            Symbol name = Symbol.get(namedValue.getName());
            builder.set(name, namedValue.getValue());
        }
        if (exp2 == Null.INSTANCE) {
            return ListVector.EMPTY.setAttributes(builder);
        }
        return exp2.setAttributes(builder);
    }

    @Generic
    @Builtin(value="names")
    public static SEXP getNames(SEXP exp2) {
        if (exp2.getAttributes().getDim().length() == 1) {
            return exp2.getAttributes().getDimNames(0);
        }
        return exp2.getNames();
    }

    @Generic
    @Builtin(value="names<-")
    public static SEXP setNames(@Current Context context, SEXP exp2, @InvokeAsCharacter Vector names2) {
        if (Types.isS4(exp2)) {
            String className = ((StringVector)exp2.getAttribute(Symbols.CLASS)).getElementAsString(0);
            if (exp2 instanceof S4Object) {
                if (exp2.getAttribute(Symbols.NAMES) == Null.INSTANCE) {
                    throw new EvalException("class '%s' has no 'names' slot", className);
                }
                throw new EvalException("invalid to use names()<- to set the 'names' slot in a non-vector class ('%s')", className);
            }
            if (exp2.getAttribute(Symbols.NAMES) == Null.INSTANCE) {
                context.warn(String.format("class '%s' has no 'names' slot; assigning a names attribute will create an invalid object", className));
            }
        }
        if (exp2.getAttributes().getDim().length() == 1) {
            return exp2.setAttributes(exp2.getAttributes().copy().setArrayNames(names2));
        }
        AttributeMap.Builder newAttributes = exp2.getAttributes().copy();
        newAttributes.setNames(names2);
        return exp2.setAttributes(newAttributes);
    }

    @Generic
    @Builtin(value="levels<-")
    public static SEXP setLabels(SEXP exp2, SEXP levels2) {
        return exp2.setAttribute(Symbols.LEVELS, levels2);
    }

    @Builtin(value="class")
    public static StringVector getClass(SEXP exp2) {
        SEXP classAttribute = exp2.getAttribute(Symbols.CLASS);
        if (classAttribute.length() > 0) {
            return (StringVector)classAttribute;
        }
        SEXP dim2 = exp2.getAttribute(Symbols.DIM);
        if (dim2.length() == 2) {
            return StringVector.valueOf("matrix");
        }
        if (dim2.length() > 0) {
            return StringVector.valueOf("array");
        }
        return StringVector.valueOf(exp2.getImplicitClass());
    }

    @Builtin
    public static SEXP unclass(SEXP exp2) {
        return exp2.setAttributes(exp2.getAttributes().copy().remove(Symbols.CLASS));
    }

    @Builtin(value="attr<-")
    public static SEXP setAttribute(SEXP exp2, String which2, SEXP value) {
        return exp2.setAttribute(which2, value);
    }

    @Internal
    public static SEXP inherits(@Current Context context, SEXP exp2, StringVector what, boolean which2) {
        int i;
        StringVector classes = Attributes.getClass(exp2);
        boolean s4 = Types.isS4(exp2);
        int[] inherits2 = new int[what.length()];
        for (i = 0; i < what.length(); ++i) {
            String whatClass = what.getElementAsString(i);
            inherits2[i] = Attributes.inherits(context, whatClass, classes, s4);
        }
        if (which2) {
            return new IntArrayVector(inherits2);
        }
        for (i = 0; i < inherits2.length; ++i) {
            if (inherits2[i] == 0) continue;
            return LogicalVector.TRUE;
        }
        return LogicalVector.FALSE;
    }

    private static int inherits(Context context, String whatClass, StringVector classes, boolean s4) {
        for (int i = 0; i < classes.length(); ++i) {
            String className = classes.getElementAsString(i);
            if (whatClass.equals(className)) {
                return i + 1;
            }
            if (!s4) continue;
            AtomicVector superClasses = S4.computeDataClassesS4(context, className);
            for (int j = 0; j < superClasses.length(); ++j) {
                if (!whatClass.equals(superClasses.getElementAsString(j))) continue;
                return i + 1;
            }
        }
        return 0;
    }

    public static StringVector getSlotElementsNames(SEXP exp2, Symbol slot) {
        SEXP attribute = exp2.getAttribute(slot);
        if (attribute != null && attribute.length() > 0) {
            return (StringVector)attribute.getNames();
        }
        return StringVector.EMPTY;
    }
}

