/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.pipeliner.optimize;

import org.renjin.pipeliner.DeferredGraph;
import org.renjin.pipeliner.node.DeferredNode;
import org.renjin.pipeliner.node.FunctionNode;
import org.renjin.pipeliner.optimize.Optimizer;
import org.renjin.primitives.vector.DeferredComputation;

public class IdentityRemover
implements Optimizer {
    private static boolean DEBUG = false;

    @Override
    public boolean optimize(DeferredGraph graph, FunctionNode node) {
        DeferredNode replacementValue = this.trySimplify(node);
        if (replacementValue != null) {
            graph.replaceNode(node, replacementValue);
            return true;
        }
        return false;
    }

    private DeferredNode trySimplify(FunctionNode node) {
        String op = node.getComputationName();
        if (node.getOperands().size() == 2) {
            if ("^".equals(op) && node.getOperand(1).hasValue(1.0)) {
                if (DEBUG) {
                    System.out.println("Killed ^1");
                }
                return node.getOperand(0);
            }
            if ("*".equals(op)) {
                if (node.getOperand(0).hasValue(1.0)) {
                    if (DEBUG) {
                        System.out.println("Killed 1*x");
                    }
                    return node.getOperand(1);
                }
                if (node.getOperand(1).hasValue(1.0)) {
                    if (DEBUG) {
                        System.out.println("Killed x*1");
                    }
                    return node.getOperand(0);
                }
                if (node.getOperand(0).hasValue(0.0) || node.getOperand(1).hasValue(0.0)) {
                    // empty if block
                }
            }
            if ("+".equals(op) || "-".equals(op)) {
                if (node.getOperand(0).hasValue(0.0)) {
                    if (DEBUG) {
                        System.out.println("Killed 0+-x");
                    }
                    return node.getOperand(1);
                }
                if (node.getOperand(1).hasValue(0.0)) {
                    if (DEBUG) {
                        System.out.println("Killed x+-0");
                    }
                    return node.getOperand(0);
                }
            }
        }
        if (("mean".equals(op) || "min".equals(op) || "max".equals(op)) && node.getOperand(0) instanceof DeferredComputation && ((DeferredComputation)node.getOperand(0).getVector()).getComputationName().equals("rep")) {
            if (DEBUG) {
                System.out.println("Killed mean/max/min(rep(x))");
            }
            return node.getOperand(0).getOperand(0);
        }
        return null;
    }
}

