/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.parser;

import java.text.NumberFormat;
import org.apache.commons.math.complex.Complex;
import org.renjin.parser.FDBigInteger;
import org.renjin.sexp.ComplexVector;
import org.renjin.sexp.DoubleVector;

public class NumericLiterals {
    public static final NumberFormat REAL_FORMAT = NumericLiterals.createRealFormat();
    private static final int SIGNIFICAND_WIDTH = 53;
    private static final int EXP_SHIFT = 52;
    private static final long FRACT_HOB = 0x10000000000000L;
    public static final int EXP_BIAS = 1023;
    private static final long EXP_ONE = 0x3FF0000000000000L;
    private static final int MAX_SMALL_BIN_EXP = 62;
    private static final int MIN_SMALL_BIN_EXP = -21;
    private static final int MAX_DECIMAL_DIGITS = 15;
    private static final int MAX_DECIMAL_EXPONENT = 308;
    private static final int MIN_DECIMAL_EXPONENT = -324;
    private static final int BIG_DECIMAL_EXPONENT = 324;
    private static final int MAX_NDIGITS = 1100;
    private static final int INT_DECIMAL_DIGITS = 9;
    public static final long EXP_BIT_MASK = 0x7FF0000000000000L;
    public static final long SIGNIF_BIT_MASK = 0xFFFFFFFFFFFFFL;
    private static final long SIGN_BIT_MASK = Long.MIN_VALUE;
    private static final double[] SMALL_10_POW = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20, 1.0E21, 1.0E22};
    private static final float[] SINGLE_SMALL_10_POW = new float[]{1.0f, 10.0f, 100.0f, 1000.0f, 10000.0f, 100000.0f, 1000000.0f, 1.0E7f, 1.0E8f, 1.0E9f, 1.0E10f};
    private static final double[] BIG_10_POW = new double[]{1.0E16, 1.0E32, 1.0E64, 1.0E128, 1.0E256};
    private static final double[] TINY_10_POW = new double[]{1.0E-16, 1.0E-32, 1.0E-64, 1.0E-128, 1.0E-256};
    private static final int MAX_SMALL_TEN = SMALL_10_POW.length - 1;
    private static final int SINGLE_MAX_SMALL_TEN = SINGLE_SMALL_10_POW.length - 1;

    public static String format(double value, String naString) {
        if (DoubleVector.isNA(value)) {
            return naString;
        }
        return NumericLiterals.toString(value);
    }

    public static String format(int value) {
        return Integer.toString(value);
    }

    public static String toString(double value) {
        if (Double.isNaN(value)) {
            return "NaN";
        }
        if (Double.isInfinite(value)) {
            if (value < 0.0) {
                return "-Inf";
            }
            return "Inf";
        }
        if (value > 100000.0) {
            return Double.toString(value);
        }
        return REAL_FORMAT.format(value);
    }

    public static String toString(Complex complex2) {
        StringBuilder sb = new StringBuilder();
        sb.append(NumericLiterals.toString(complex2.getReal()));
        if (complex2.getImaginary() >= 0.0) {
            sb.append('+');
        }
        sb.append(NumericLiterals.toString(complex2.getImaginary()));
        sb.append('i');
        return sb.toString();
    }

    public static NumberFormat createRealFormat() {
        NumberFormat format2 = NumberFormat.getNumberInstance();
        format2.setMinimumFractionDigits(0);
        format2.setMaximumFractionDigits(14);
        format2.setGroupingUsed(false);
        return format2;
    }

    public static double parseDouble(CharSequence text) {
        return NumericLiterals.parseDouble(text, 0, text.length(), '.', false);
    }

    public static Complex parseComplex(CharSequence s) {
        int lastCharIndex = s.length() - 1;
        if (s.charAt(lastCharIndex) == 'i') {
            int imaginaryStart = NumericLiterals.findImaginaryStart(s);
            if (imaginaryStart <= 0) {
                return ComplexVector.NA;
            }
            double real2 = NumericLiterals.parseDouble(s, 0, imaginaryStart, '.', true);
            if (DoubleVector.isNA(real2)) {
                return ComplexVector.NA;
            }
            double imaginary = NumericLiterals.parseDouble(s, imaginaryStart, lastCharIndex, '.', true);
            return ComplexVector.complex(real2, imaginary);
        }
        double real3 = NumericLiterals.parseDouble(s, 0, s.length(), '.', true);
        return ComplexVector.complex(real3);
    }

    private static int findImaginaryStart(CharSequence s) {
        for (int index = s.length() - 2; index >= 0; --index) {
            char c2 = s.charAt(index);
            if (c2 != '+' && c2 != '-') continue;
            return index;
        }
        return -1;
    }

    public static int parseInt(CharSequence line) {
        return (int)NumericLiterals.parseDouble(line);
    }

    public static double parseDouble(CharSequence s, int startIndex, int endIndex, char dec, boolean NA) {
        int p;
        int sign2 = 1;
        for (p = startIndex; p < endIndex && Character.isWhitespace(s.charAt(p)); ++p) {
        }
        while (endIndex > p && Character.isWhitespace(s.charAt(endIndex - 1))) {
            --endIndex;
        }
        if (NA && p + 2 < endIndex && s.charAt(p) == 'N' && s.charAt(p + 1) == 'A') {
            return DoubleVector.NA;
        }
        if (p == endIndex) {
            return DoubleVector.NA;
        }
        switch (s.charAt(p)) {
            case '-': {
                sign2 = -1;
                ++p;
                break;
            }
            case '+': {
                ++p;
            }
        }
        if (NumericLiterals.equalsIgnoringCase(s, p, endIndex, "NAN")) {
            return Double.NaN;
        }
        if (NumericLiterals.equalsIgnoringCase(s, p, endIndex, "INF") || NumericLiterals.equalsIgnoringCase(s, p, endIndex, "INFINITY")) {
            return (double)sign2 * Double.POSITIVE_INFINITY;
        }
        if (endIndex - p > 2 && s.charAt(p) == '0' && (s.charAt(p + 1) == 'x' || s.charAt(p + 2) == 'X')) {
            return NumericLiterals.parseDoubleHex(s, sign2, p, endIndex, dec);
        }
        return NumericLiterals.parseDoubleDecimal(s, sign2, p, endIndex, dec);
    }

    private static double parseDoubleDecimal(CharSequence in, int sign2, int startIndex, int endIndex, char decimalPoint) {
        boolean isZero;
        char c2;
        int i;
        char[] digits = new char[endIndex - startIndex];
        int nDigits = 0;
        boolean decSeen = false;
        int decPt = 0;
        int nLeadZero = 0;
        int nTrailZero = 0;
        for (i = startIndex; i < endIndex; ++i) {
            c2 = in.charAt(i);
            if (c2 == '0') {
                ++nLeadZero;
                continue;
            }
            if (c2 != decimalPoint) break;
            if (decSeen) {
                return DoubleVector.NA;
            }
            decPt = i - startIndex;
            decSeen = true;
        }
        while (i < endIndex) {
            c2 = in.charAt(i);
            if (c2 >= '1' && c2 <= '9') {
                digits[nDigits++] = c2;
                nTrailZero = 0;
            } else if (c2 == '0') {
                digits[nDigits++] = c2;
                ++nTrailZero;
            } else {
                if (c2 != decimalPoint) break;
                if (decSeen) {
                    return DoubleVector.NA;
                }
                decPt = i - startIndex;
                decSeen = true;
            }
            ++i;
        }
        boolean bl = isZero = (nDigits -= nTrailZero) == 0;
        if (isZero && nLeadZero == 0) {
            return DoubleVector.NA;
        }
        int decExp = decSeen ? decPt - nLeadZero : nDigits + nTrailZero;
        if (i < endIndex && ((c2 = in.charAt(i)) == 'e' || c2 == 'E')) {
            int expSign = 1;
            int expVal = 0;
            int reallyBig = 0xCCCCCCC;
            boolean expOverflow = false;
            switch (in.charAt(++i)) {
                case '-': {
                    expSign = -1;
                }
                case '+': {
                    ++i;
                }
            }
            int expAt = i;
            while (i < endIndex) {
                if (expVal >= reallyBig) {
                    expOverflow = true;
                }
                if ((c2 = in.charAt(i++)) >= '0' && c2 <= '9') {
                    expVal = expVal * 10 + (c2 - 48);
                    continue;
                }
                --i;
                break;
            }
            int expLimit = 324 + nDigits + nTrailZero;
            decExp = expOverflow || expVal > expLimit ? expSign * expLimit : (decExp += expSign * expVal);
            if (i == expAt) {
                return DoubleVector.NA;
            }
        }
        if (i < endIndex) {
            return DoubleVector.NA;
        }
        if (isZero) {
            return (double)sign2 * 0.0;
        }
        return NumericLiterals.doubleValue(sign2 < 0, decExp, digits, nDigits);
    }

    private static double parseDoubleHex(CharSequence s, int sign2, int startIndex, int endIndex, char dec) {
        double ans = 0.0;
        int expn = 0;
        int exph = -1;
        int p = startIndex;
        p += 2;
        while (p < s.length()) {
            block20: {
                block17: {
                    char c2;
                    block19: {
                        block18: {
                            block16: {
                                c2 = s.charAt(p);
                                if ('0' > c2 || c2 > '9') break block16;
                                ans = 16.0 * ans + (double)(s.charAt(p) - 48);
                                break block17;
                            }
                            if ('a' > c2 || c2 > 'f') break block18;
                            ans = 16.0 * ans + (double)(s.charAt(p) - 97 + 10);
                            break block17;
                        }
                        if ('A' > c2 || c2 > 'F') break block19;
                        ans = 16.0 * ans + (double)(s.charAt(p) - 65 + 10);
                        break block17;
                    }
                    if (c2 != dec) break;
                    exph = 0;
                    break block20;
                }
                if (exph >= 0) {
                    exph += 4;
                }
            }
            ++p;
        }
        if (p < endIndex && (s.charAt(p) == 'p' || s.charAt(p) == 'P')) {
            int expsign = 1;
            double p2 = 2.0;
            switch (s.charAt(++p)) {
                case '-': {
                    expsign = -1;
                    ++p;
                    break;
                }
                case '+': {
                    ++p;
                }
            }
            int n = 0;
            while (p < endIndex && s.charAt(p) >= '0' && s.charAt(p) <= '9') {
                n = n * 10 + (s.charAt(p) - 48);
                ++p;
            }
            expn += expsign * n;
            if (exph > 0) {
                expn -= exph;
            }
            if (expn < 0) {
                n = -expn;
                double fac = 1.0;
                while (n != 0) {
                    if ((n & 1) != 0) {
                        fac *= p2;
                    }
                    n >>= 1;
                    p2 *= p2;
                }
                ans /= fac;
            } else {
                n = expn;
                double fac = 1.0;
                while (n != 0) {
                    if ((n & 1) != 0) {
                        fac *= p2;
                    }
                    n >>= 1;
                    p2 *= p2;
                }
                ans *= fac;
            }
        }
        if (p < endIndex) {
            ans = DoubleVector.NA;
            p = 0;
            return (double)sign2 * ans;
        }
        return (double)sign2 * ans;
    }

    public static double doubleValue(boolean isNegative, int decExponent, char[] digits, int nDigits) {
        boolean overvalue;
        double t2;
        int j;
        int kDigits = Math.min(nDigits, 16);
        int iValue = digits[0] - 48;
        int iDigits = Math.min(kDigits, 9);
        for (int i = 1; i < iDigits; ++i) {
            iValue = iValue * 10 + digits[i] - 48;
        }
        long lValue = iValue;
        for (int i = iDigits; i < kDigits; ++i) {
            lValue = lValue * 10L + (long)(digits[i] - 48);
        }
        double dValue = lValue;
        int exp2 = decExponent - kDigits;
        if (nDigits <= 15) {
            if (exp2 == 0 || dValue == 0.0) {
                return isNegative ? -dValue : dValue;
            }
            if (exp2 >= 0) {
                if (exp2 <= MAX_SMALL_TEN) {
                    double rValue = dValue * SMALL_10_POW[exp2];
                    return isNegative ? -rValue : rValue;
                }
                int slop = 15 - kDigits;
                if (exp2 <= MAX_SMALL_TEN + slop) {
                    double rValue = (dValue *= SMALL_10_POW[slop]) * SMALL_10_POW[exp2 - slop];
                    return isNegative ? -rValue : rValue;
                }
            } else if (exp2 >= -MAX_SMALL_TEN) {
                double rValue = dValue / SMALL_10_POW[-exp2];
                return isNegative ? -rValue : rValue;
            }
        }
        if (exp2 > 0) {
            if (decExponent > 309) {
                return isNegative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            if ((exp2 & 0xF) != 0) {
                dValue *= SMALL_10_POW[exp2 & 0xF];
            }
            if ((exp2 >>= 4) != 0) {
                j = 0;
                while (exp2 > 1) {
                    if ((exp2 & 1) != 0) {
                        dValue *= BIG_10_POW[j];
                    }
                    ++j;
                    exp2 >>= 1;
                }
                t2 = dValue * BIG_10_POW[j];
                if (Double.isInfinite(t2)) {
                    t2 = dValue / 2.0;
                    if (Double.isInfinite(t2 *= BIG_10_POW[j])) {
                        return isNegative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
                    }
                    t2 = Double.MAX_VALUE;
                }
                dValue = t2;
            }
        } else if (exp2 < 0) {
            exp2 = -exp2;
            if (decExponent < -325) {
                return isNegative ? -0.0 : 0.0;
            }
            if ((exp2 & 0xF) != 0) {
                dValue /= SMALL_10_POW[exp2 & 0xF];
            }
            if ((exp2 >>= 4) != 0) {
                j = 0;
                while (exp2 > 1) {
                    if ((exp2 & 1) != 0) {
                        dValue *= TINY_10_POW[j];
                    }
                    ++j;
                    exp2 >>= 1;
                }
                t2 = dValue * TINY_10_POW[j];
                if (t2 == 0.0) {
                    t2 = dValue * 2.0;
                    if ((t2 *= TINY_10_POW[j]) == 0.0) {
                        return isNegative ? -0.0 : 0.0;
                    }
                    t2 = Double.MIN_VALUE;
                }
                dValue = t2;
            }
        }
        if (nDigits > 1100) {
            nDigits = 1101;
            digits[1100] = 49;
        }
        FDBigInteger bigD0 = new FDBigInteger(lValue, digits, kDigits, nDigits);
        exp2 = decExponent - nDigits;
        long ieeeBits = Double.doubleToRawLongBits(dValue);
        int B5 = Math.max(0, -exp2);
        int D5 = Math.max(0, exp2);
        bigD0 = bigD0.multByPow52(D5, 0);
        bigD0.makeImmutable();
        FDBigInteger bigD = null;
        int prevD2 = 0;
        do {
            FDBigInteger diff;
            int cmpResult;
            int binexp = (int)(ieeeBits >>> 52);
            long bigBbits = ieeeBits & 0xFFFFFFFFFFFFFL;
            if (binexp > 0) {
                bigBbits |= 0x10000000000000L;
            } else {
                assert (bigBbits != 0L) : bigBbits;
                int leadingZeros = Long.numberOfLeadingZeros(bigBbits);
                int shift = leadingZeros - 11;
                bigBbits <<= shift;
                binexp = 1 - shift;
            }
            int lowOrderZeros = Long.numberOfTrailingZeros(bigBbits);
            bigBbits >>>= lowOrderZeros;
            int bigIntExp = (binexp -= 1023) - 52 + lowOrderZeros;
            int bigIntNBits = 53 - lowOrderZeros;
            int B2 = B5;
            int D2 = D5;
            if (bigIntExp >= 0) {
                B2 += bigIntExp;
            } else {
                D2 -= bigIntExp;
            }
            int Ulp2 = B2;
            int hulpbias = binexp <= -1023 ? binexp + lowOrderZeros + 1023 : 1 + lowOrderZeros;
            int common2 = Math.min(B2 += hulpbias, Math.min(D2 += hulpbias, Ulp2));
            Ulp2 -= common2;
            FDBigInteger bigB = FDBigInteger.valueOfMulPow52(bigBbits, B5, B2 -= common2);
            if (bigD == null || prevD2 != (D2 -= common2)) {
                bigD = bigD0.leftShift(D2);
                prevD2 = D2;
            }
            if ((cmpResult = bigB.cmp(bigD)) > 0) {
                overvalue = true;
                diff = bigB.leftInplaceSub(bigD);
                if (bigIntNBits == 1 && bigIntExp > -1022 && --Ulp2 < 0) {
                    Ulp2 = 0;
                    diff = diff.leftShift(1);
                }
            } else {
                if (cmpResult >= 0) break;
                overvalue = false;
                diff = bigD.rightInplaceSub(bigB);
            }
            if ((cmpResult = diff.cmpPow52(B5, Ulp2)) < 0) break;
            if (cmpResult != 0) continue;
            if ((ieeeBits & 1L) == 0L) break;
            ieeeBits += overvalue ? -1L : 1L;
            break;
        } while ((ieeeBits += overvalue ? -1L : 1L) != 0L && ieeeBits != 0x7FF0000000000000L);
        if (isNegative) {
            ieeeBits |= Long.MIN_VALUE;
        }
        return Double.longBitsToDouble(ieeeBits);
    }

    private static boolean equalsIgnoringCase(CharSequence s, int start, int endIndex, String word) {
        int lenRemaining = endIndex - start;
        int wordLen = word.length();
        if (lenRemaining != wordLen) {
            return false;
        }
        for (int i = 0; i < wordLen; ++i) {
            if (Character.toUpperCase(s.charAt(start + i)) == word.charAt(i)) continue;
            return false;
        }
        return true;
    }
}

