/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Builtins;
import org.renjin.nmath.qnbeta;
import org.renjin.nmath.qnchisq;

public class qnf {
    private qnf() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double qnf(double d, double d2, double d3, double d4, int n, int n2) {
        if (Builtins.__isnan(d) != 0) return d + d2 + d3 + d4;
        if (Builtins.__isnan(d2) != 0) return d + d2 + d3 + d4;
        if (Builtins.__isnan(d3) != 0) return d + d2 + d3 + d4;
        if (Builtins.__isnan(d4) != 0) return d + d2 + d3 + d4;
        if (d2 <= 0.0) return Double.NaN;
        if (d3 <= 0.0) return Double.NaN;
        if (d4 < 0.0) return Double.NaN;
        if (Builtins.__finite(d4) == 0) return Double.NaN;
        if (Builtins.__finite(d2) == 0) {
            if (Builtins.__finite(d3) == 0) return Double.NaN;
        }
        if (n2 != 0) {
            if (d > 0.0) return Double.NaN;
            if (d == 0.0) {
                if (n != 0) return Double.POSITIVE_INFINITY;
                return 0.0;
            }
            if (d == Double.NEGATIVE_INFINITY) {
                if (n == 0) return Double.POSITIVE_INFINITY;
                return 0.0;
            }
        } else {
            if (d < 0.0) return Double.NaN;
            if (d > 1.0) return Double.NaN;
            if (d == 0.0) {
                if (n == 0) return Double.POSITIVE_INFINITY;
                return 0.0;
            }
            if (d == 1.0) {
                if (n != 0) return Double.POSITIVE_INFINITY;
                return 0.0;
            }
        }
        if (d3 > 1.0E8) return qnchisq.qnchisq(d, d2, d4, n, n2) / d2;
        d = qnbeta.qnbeta(d, d2 / 2.0, d3 / 2.0, d4, n, n2);
        d4 = 1.0 - d;
        return d / d4 * (d3 / d2);
    }
}

