/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Builtins;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.nmath.fmax2;

public class qgeom {
    private qgeom() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double qgeom(double d, double d2, int n, int n2) {
        if (Builtins.__isnan(d) != 0 || Builtins.__isnan(d2) != 0) {
            d += d2;
            return d;
        } else {
            if (d2 <= 0.0) return Double.NaN;
            if (d2 > 1.0) return Double.NaN;
            if (n2 != 0) {
                if (d > 0.0) return Double.NaN;
            }
            if (n2 == 0) {
                if (d < 0.0) return Double.NaN;
                if (d > 1.0) return Double.NaN;
            }
            if (d2 == 1.0) return 0.0;
            if (n2 != 0) {
                if (d > 0.0) return Double.NaN;
                if (d == 0.0) {
                    if (n != 0) return Double.POSITIVE_INFINITY;
                    return 0.0;
                }
                if (d == Double.NEGATIVE_INFINITY) {
                    if (n == 0) return Double.POSITIVE_INFINITY;
                    return 0.0;
                }
            } else {
                if (d < 0.0) return Double.NaN;
                if (d > 1.0) return Double.NaN;
                if (d == 0.0) {
                    if (n == 0) return Double.POSITIVE_INFINITY;
                    return 0.0;
                }
                if (d == 1.0) {
                    if (n != 0) return Double.POSITIVE_INFINITY;
                    return 0.0;
                }
            }
            if (n != 0) {
                d = n2 != 0 ? (d > -0.6931471805599453 ? Math.log(-Mathlib.expm1(d)) : Mathlib.log1p(-Math.exp(d))) : Mathlib.log1p(-d);
                return fmax2.fmax2(0.0, Mathlib.ceil(d / Mathlib.log1p(-d2) - 1.0 - 1.0E-12));
            } else {
                if (n2 != 0) return fmax2.fmax2(0.0, Mathlib.ceil(d / Mathlib.log1p(-d2) - 1.0 - 1.0E-12));
                d = Math.log(d);
            }
            return fmax2.fmax2(0.0, Mathlib.ceil(d / Mathlib.log1p(-d2) - 1.0 - 1.0E-12));
        }
    }
}

