/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Builtins;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.nmath.bd0;
import org.renjin.nmath.dnorm;
import org.renjin.nmath.stirlerr;

public class dt {
    private dt() {
    }

    public static double dt(double d, double d2, int n) {
        double d3 = 0.0;
        if (Builtins.__isnan(d) != 0 || Builtins.__isnan(d2) != 0) {
            d += d2;
        } else if (d2 <= 0.0) {
            d = Double.NaN;
        } else if (Builtins.__finite(d) == 0) {
            d = n != 0 ? Double.NEGATIVE_INFINITY : 0.0;
        } else if (Builtins.__finite(d2) == 0) {
            d = dnorm.dnorm4(d, 0.0, 1.0, n);
        } else {
            double d4 = stirlerr.Rf_stirlerr((d2 + 1.0) / 2.0) - bd0.Rf_bd0(d2 / 2.0, (d2 + 1.0) / 2.0) - stirlerr.Rf_stirlerr(d2 / 2.0);
            double d5 = d * d / d2;
            boolean bl = d5 > 4.503599627370496E15;
            boolean bl2 = bl;
            if (bl) {
                d3 = Math.abs(d);
                d5 = Math.log(d3) - Math.log(d2) / 2.0;
                d = d2 * d5;
            } else if (d5 > 0.2) {
                d5 = Math.log(d5 + 1.0) / 2.0;
                d = d2 * d5;
            } else {
                d5 = Mathlib.log1p(d5) / 2.0;
                d = d * d / 2.0 - bd0.Rf_bd0(d2 / 2.0, (d * d + d2) / 2.0);
            }
            if (n != 0) {
                d = d4 - d - (d5 + 0.9189385332046728);
            } else {
                d2 = bl2 ? Mathlib.sqrt(d2) / d3 : Math.exp(-d5);
                d = Math.exp(d4 - d) * 0.3989422804014327 * d2;
            }
        }
        return d;
    }
}

