/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Builtins;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.gcc.runtime.Stdlib;
import org.renjin.nmath.bd0;
import org.renjin.nmath.fmax2;
import org.renjin.nmath.lgamma;
import org.renjin.nmath.stirlerr;

public class dpois {
    private dpois() {
    }

    public static double dpois(double d, double d2, int n) {
        if (Builtins.__isnan(d) != 0 || Builtins.__isnan(d2) != 0) {
            d += d2;
        } else if (d2 < 0.0) {
            d = Double.NaN;
        } else if (Math.abs(d - Mathlib.round(d)) > fmax2.fmax2(1.0, Math.abs(d)) * 1.0E-7) {
            Stdlib.printf(new BytePtr("non-integer x = %f\u0000".getBytes(), 0), d);
            d = n != 0 ? Double.NEGATIVE_INFINITY : 0.0;
        } else {
            d = d < 0.0 || Builtins.__finite(d) == 0 ? (n != 0 ? Double.NEGATIVE_INFINITY : 0.0) : dpois.dpois_raw(Mathlib.round(d), d2, n);
        }
        return d;
    }

    public static double dpois_raw(double d, double d2, int n) {
        d = d2 == 0.0 ? (d == 0.0 ? (n != 0 ? 0.0 : 1.0) : (n != 0 ? Double.NEGATIVE_INFINITY : 0.0)) : (Builtins.__finite(d2) == 0 ? (n != 0 ? Double.NEGATIVE_INFINITY : 0.0) : (d < 0.0 ? (n != 0 ? Double.NEGATIVE_INFINITY : 0.0) : (d2 * Double.MIN_NORMAL >= d ? (n != 0 ? -d2 : Math.exp(-d2)) : (d * Double.MIN_NORMAL > d2 ? (Builtins.__finite(d) == 0 ? (n != 0 ? Double.NEGATIVE_INFINITY : 0.0) : (n != 0 ? Math.log(d2) * d - d2 - lgamma.lgammafn(d + 1.0) : Math.exp(Math.log(d2) * d - d2 - lgamma.lgammafn(d + 1.0)))) : (n != 0 ? Math.log(d * (Math.PI * 2)) * -0.5 + (-stirlerr.Rf_stirlerr(d) - bd0.Rf_bd0(d, d2)) : Math.exp(-stirlerr.Rf_stirlerr(d) - bd0.Rf_bd0(d, d2)) / Mathlib.sqrt(d * (Math.PI * 2)))))));
        return d;
    }
}

