/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Builtins;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.gcc.runtime.Stdlib;
import org.renjin.nmath.dbinom;
import org.renjin.nmath.dpois;
import org.renjin.nmath.fmax2;
import org.renjin.nmath.lgamma;

public class dnbinom {
    private dnbinom() {
    }

    public static double dnbinom(double d, double d2, double d3, int n) {
        if (Builtins.__isnan(d) != 0 || Builtins.__isnan(d2) != 0 || Builtins.__isnan(d3) != 0) {
            d = d + d2 + d3;
        } else if (d3 <= 0.0 || d3 > 1.0 || d2 < 0.0) {
            d = Double.NaN;
        } else if (Math.abs(d - Mathlib.round(d)) > fmax2.fmax2(1.0, Math.abs(d)) * 1.0E-7) {
            Stdlib.printf(new BytePtr("non-integer x = %f\u0000".getBytes(), 0), d);
            d = n != 0 ? Double.NEGATIVE_INFINITY : 0.0;
        } else if (d < 0.0 || Builtins.__finite(d) == 0) {
            d = n != 0 ? Double.NEGATIVE_INFINITY : 0.0;
        } else if (d == 0.0 && d2 == 0.0) {
            d = n != 0 ? 0.0 : 1.0;
        } else {
            double d4 = Mathlib.round(d);
            if (Builtins.__finite(d2) == 0) {
                d2 = Double.MAX_VALUE;
            }
            d = dbinom.dbinom_raw(d2, d4 + d2, d3, 1.0 - d3, n);
            d2 /= d2 + d4;
            d = n != 0 ? Math.log(d2) + d : d2 * d;
        }
        return d;
    }

    public static double dnbinom_mu(double d, double d2, double d3, int n) {
        if (Builtins.__isnan(d) != 0 || Builtins.__isnan(d2) != 0 || Builtins.__isnan(d3) != 0) {
            d = d + d2 + d3;
        } else if (d3 < 0.0 || d2 < 0.0) {
            d = Double.NaN;
        } else if (Math.abs(d - Mathlib.round(d)) > fmax2.fmax2(1.0, Math.abs(d)) * 1.0E-7) {
            Stdlib.printf(new BytePtr("non-integer x = %f\u0000".getBytes(), 0), d);
            d = n != 0 ? Double.NEGATIVE_INFINITY : 0.0;
        } else if (d < 0.0 || Builtins.__finite(d) == 0) {
            d = n != 0 ? Double.NEGATIVE_INFINITY : 0.0;
        } else if (d == 0.0 && d2 == 0.0) {
            d = n != 0 ? 0.0 : 1.0;
        } else {
            double d4 = Mathlib.round(d);
            if (Builtins.__finite(d2) == 0) {
                d = dpois.dpois_raw(d4, d3, n);
            } else if (d4 == 0.0) {
                if (n != 0) {
                    d = d2 < d3 ? Math.log(d2 / (d2 + d3)) : Mathlib.log1p(-d3 / (d2 + d3));
                    d *= d2;
                } else {
                    d = d2 < d3 ? Math.log(d2 / (d2 + d3)) : Mathlib.log1p(-d3 / (d2 + d3));
                    d = Math.exp(d * d2);
                }
            } else if (d2 * 1.0E-10 > d4) {
                d = d2 < d3 ? Math.log(d2 / (d2 / d3 + 1.0)) : Math.log(d3 / (d3 / d2 + 1.0));
                d = n != 0 ? d4 * d - d3 - lgamma.lgammafn(d4 + 1.0) + Mathlib.log1p((d4 - 1.0) * d4 / (d2 * 2.0)) : Math.exp(d4 * d - d3 - lgamma.lgammafn(d4 + 1.0) + Mathlib.log1p((d4 - 1.0) * d4 / (d2 * 2.0)));
            } else {
                d = d2 / (d2 + d4);
                d2 = dbinom.dbinom_raw(d2, d4 + d2, d2 / (d2 + d3), d3 / (d2 + d3), n);
                d = n != 0 ? Math.log(d) + d2 : (d *= d2);
            }
        }
        return d;
    }
}

