/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.math;

import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.DoublePtr;
import org.renjin.gcc.runtime.IntPtr;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.math.dlacpy__;
import org.renjin.math.dlamch__;
import org.renjin.math.dlansy__;
import org.renjin.math.dlascl__;
import org.renjin.math.dormtr__;
import org.renjin.math.dscal__;
import org.renjin.math.dstedc__;
import org.renjin.math.dsterf__;
import org.renjin.math.dsytrd__;
import org.renjin.math.ilaenv__;
import org.renjin.math.lsame__;
import org.renjin.math.xerbla__;

public class dsyevd__ {
    private dsyevd__() {
    }

    public static void dsyevd_(Ptr jobz, Ptr uplo, Ptr n, Ptr a, Ptr lda, Ptr w, Ptr work, Ptr lwork, Ptr iwork, Ptr liwork, Ptr info2, int _jobz, int _uplo) {
        double[] dArray = new double[1];
        int[] nArray = new int[1];
        double[] sigma = new double[1];
        int[] llwrk2 = new int[1];
        int[] llwork = new int[1];
        int[] iinfo = new int[1];
        sigma[0] = 0.0;
        int lopt = 0;
        int liopt = 0;
        iinfo[0] = 0;
        int stride$1 = lda.getInt();
        stride$1 = Math.max(stride$1, 0);
        int offset$2 = ~stride$1;
        boolean wantz = lsame__.lsame_(jobz, new BytePtr("V".getBytes(), 0), 1, 1);
        boolean lower = lsame__.lsame_(uplo, new BytePtr("L".getBytes(), 0), 1, 1);
        boolean iftmp$5 = lwork.getInt() == -1 || liwork.getInt() == -1;
        boolean lquery = iftmp$5;
        info2.setInt(0);
        if (wantz ^ true && lsame__.lsame_(jobz, new BytePtr("N".getBytes(), 0), 1, 1) ^ true) {
            info2.setInt(-1);
        } else if (lower ^ true && lsame__.lsame_(uplo, new BytePtr("U".getBytes(), 0), 1, 1) ^ true) {
            info2.setInt(-2);
        } else if (n.getInt() < 0) {
            info2.setInt(-3);
        } else {
            int M$3 = 1;
            int n2 = n.getInt();
            if (n2 > M$3) {
                M$3 = n2;
            }
            if (lda.getInt() < M$3) {
                info2.setInt(-5);
            }
        }
        if (info2.getInt() == 0) {
            int lwmin;
            int liwmin;
            if (n.getInt() <= 1) {
                liwmin = 1;
                lopt = lwmin = 1;
                liopt = liwmin;
            } else {
                if (wantz) {
                    liwmin = n.getInt() * 5 + 3;
                    int n3 = n.getInt();
                    int n4 = n3 * n3;
                    int n5 = n.getInt() * 6 + 1;
                    int n6 = n4 * 2;
                    lwmin = n5 + n6;
                } else {
                    liwmin = 1;
                    lwmin = n.getInt() * 2 + 1;
                }
                int M$4 = lwmin;
                int n7 = n.getInt() * 2;
                int n8 = ilaenv__.ilaenv_(new IntPtr(new int[]{1}, 0), new BytePtr("DSYTRD".getBytes(), 0), uplo, n, new IntPtr(new int[]{-1}, 0), new IntPtr(new int[]{-1}, 0), new IntPtr(new int[]{-1}, 0), 6, 1);
                int n9 = n7 + n8;
                if (n9 > M$4) {
                    M$4 = n9;
                }
                lopt = M$4;
                liopt = liwmin;
            }
            double d = lopt;
            work.setDouble(d);
            iwork.setInt(liopt);
            if (lwork.getInt() < lwmin && lquery ^ true) {
                info2.setInt(-8);
            } else if (liwork.getInt() < liwmin && lquery ^ true) {
                info2.setInt(-10);
            }
        }
        if (info2.getInt() != 0) {
            int n10;
            nArray[0] = n10 = -info2.getInt();
            xerbla__.xerbla_(new BytePtr("DSYEVD".getBytes(), 0), new IntPtr(nArray, 0), 6);
        } else if (!lquery && n.getInt() != 0) {
            if (n.getInt() == 1) {
                int n11 = offset$2 + stride$1 + 1;
                double d = a.getAlignedDouble(n11);
                w.setDouble(d);
                if (wantz) {
                    int n12 = offset$2 + stride$1 + 1;
                    a.setAlignedDouble(n12, 1.0);
                }
            } else {
                int llwrk2$9;
                int llwork$8;
                double safmin = dlamch__.dlamch_(new BytePtr("Safe minimum".getBytes(), 0), 12);
                double eps = dlamch__.dlamch_(new BytePtr("Precision".getBytes(), 0), 9);
                double smlnum = safmin / eps;
                double bignum = 1.0 / smlnum;
                double rmin = Mathlib.sqrt(smlnum);
                double rmax = Mathlib.sqrt(bignum);
                double anrm = dlansy__.dlansy_(new BytePtr("M".getBytes(), 0), uplo, n, a, lda, work, 1, 1);
                boolean iscale = false;
                if (anrm > 0.0 && anrm < rmin) {
                    double sigma$6;
                    iscale = true;
                    sigma[0] = sigma$6 = rmin / anrm;
                } else if (anrm > rmax) {
                    double sigma$7;
                    iscale = true;
                    sigma[0] = sigma$7 = rmax / anrm;
                }
                if (iscale) {
                    Ptr ptr = n;
                    dlascl__.dlascl_(uplo, new IntPtr(new int[]{0}, 0), new IntPtr(new int[]{0}, 0), new DoublePtr(new double[]{1.0}, 0), new DoublePtr(sigma, 0), ptr, ptr, a, lda, info2, 1);
                }
                int indtau = n.getInt() + 1;
                int indwrk = n.getInt() + indtau;
                llwork[0] = llwork$8 = lwork.getInt() - indwrk + 1;
                int n13 = n.getInt();
                int n14 = n.getInt();
                int indwk2 = n13 * n14 + indwrk;
                llwrk2[0] = llwrk2$9 = lwork.getInt() - indwk2 + 1;
                int n15 = indwrk + -1;
                Ptr ptr = work;
                int n16 = n15 * 8;
                int n17 = indtau + -1;
                Ptr ptr2 = work;
                int n18 = n17 * 8;
                Ptr ptr3 = work;
                dsytrd__.dsytrd_(uplo, n, a, lda, w, ptr3, ptr2.pointerPlus(n18), ptr.pointerPlus(n16), new IntPtr(llwork, 0), new IntPtr(iinfo, 0), 1);
                if (wantz ^ true) {
                    Ptr ptr4 = work;
                    dsterf__.dsterf_(n, w, ptr4, info2);
                } else {
                    int n19 = indwk2 + -1;
                    Ptr ptr5 = work;
                    int n20 = n19 * 8;
                    int n21 = indwrk + -1;
                    Ptr ptr6 = work;
                    int n22 = n21 * 8;
                    Ptr ptr7 = work;
                    dstedc__.dstedc_(new BytePtr("I".getBytes(), 0), n, w, ptr7, ptr6.pointerPlus(n22), n, ptr5.pointerPlus(n20), new IntPtr(llwrk2, 0), iwork, liwork, info2, 1);
                    int n23 = indwk2 + -1;
                    Ptr ptr8 = work;
                    int n24 = n23 * 8;
                    int n25 = indwrk + -1;
                    Ptr ptr9 = work;
                    int n26 = n25 * 8;
                    int n27 = indtau + -1;
                    Ptr ptr10 = work;
                    int n28 = n27 * 8;
                    Ptr ptr11 = n;
                    dormtr__.dormtr_(new BytePtr("L".getBytes(), 0), uplo, new BytePtr("N".getBytes(), 0), ptr11, ptr11, a, lda, ptr10.pointerPlus(n28), ptr9.pointerPlus(n26), n, ptr8.pointerPlus(n24), new IntPtr(llwrk2, 0), new IntPtr(iinfo, 0), 1, 1, 1);
                    int n29 = indwrk + -1;
                    Ptr ptr12 = work;
                    int n30 = n29 * 8;
                    Ptr ptr13 = n;
                    dlacpy__.dlacpy_(new BytePtr("A".getBytes(), 0), ptr13, ptr13, ptr12.pointerPlus(n30), n, a, lda, 1);
                }
                if (iscale) {
                    double d;
                    double sigma$10 = sigma[0];
                    dArray[0] = d = 1.0 / sigma$10;
                    dscal__.dscal_(n, new DoublePtr(dArray, 0), w, new IntPtr(new int[]{1}, 0));
                }
                double d = lopt;
                work.setDouble(d);
                iwork.setInt(liopt);
            }
        }
    }
}

