/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gnur.api;

import org.renjin.gcc.runtime.AbstractPtr;
import org.renjin.gcc.runtime.OffsetPtr;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.sexp.AtomicVector;

public class DoubleVectorPtr
extends AbstractPtr {
    private AtomicVector vector;
    private int offset;

    public DoubleVectorPtr(AtomicVector vector2, int offset) {
        this.vector = vector2;
        this.offset = offset;
    }

    @Override
    public Object getArray() {
        return this.vector;
    }

    @Override
    public final int getOffsetInBytes() {
        return this.offset * 8;
    }

    @Override
    public Ptr realloc(int newSizeInBytes) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public Ptr pointerPlus(int bytes) {
        if (bytes == 0) {
            return this;
        }
        if (bytes % 8 == 0) {
            return new DoubleVectorPtr(this.vector, this.offset + bytes / 8);
        }
        return new OffsetPtr(this, bytes);
    }

    @Override
    public double getAlignedDouble(int index) {
        return this.vector.getElementAsDouble(this.offset + index);
    }

    @Override
    public double getDouble(int offset) {
        if (offset % 8 == 0) {
            return this.getAlignedDouble(offset / 8);
        }
        return super.getDouble(offset);
    }

    @Override
    public byte getByte(int bytes) {
        return this.getByteViaDouble(bytes);
    }

    @Override
    public void setByte(int offset, byte value) {
        throw new UnsupportedOperationException("Illegal modification of a shared vector! Mis-behaving C/C++ code has tried to modify a vector that it should not.");
    }

    @Override
    public int toInt() {
        return this.offset * 8;
    }

    @Override
    public boolean isNull() {
        return false;
    }
}

