/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.runtime;

import java.util.Arrays;
import org.renjin.gcc.runtime.AbstractPtr;
import org.renjin.gcc.runtime.MallocThunk;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.gcc.runtime.Realloc;

public class ShortPtr
extends AbstractPtr {
    public static final int BYTES = 2;
    public static final ShortPtr NULL = new ShortPtr();
    public final short[] array;
    public final int offset;

    private ShortPtr() {
        this.array = null;
        this.offset = 0;
    }

    public ShortPtr(short[] array2, int offset) {
        this.array = array2;
        this.offset = offset;
    }

    public ShortPtr(short ... array2) {
        this.array = array2;
        this.offset = 0;
    }

    public static ShortPtr malloc(int bytes) {
        return new ShortPtr(new short[AbstractPtr.mallocSize(bytes, 2)]);
    }

    public short[] getArray() {
        return this.array;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getOffsetInBytes() {
        return this.offset * 2;
    }

    @Override
    public Ptr realloc(int newSizeInBytes) {
        return new ShortPtr(Realloc.realloc(this.array, this.offset, newSizeInBytes / 2));
    }

    @Override
    public Ptr pointerPlus(int bytes) {
        return new ShortPtr(this.array, this.offset + bytes / 2);
    }

    @Override
    public short getShort() {
        return this.array[this.offset];
    }

    @Override
    public short getAlignedShort(int index) {
        return this.array[this.offset + index];
    }

    @Override
    public short getShort(int offset) {
        if (offset % 2 == 0) {
            return this.getAlignedShort(offset / 2);
        }
        return super.getShort(offset);
    }

    @Override
    public void setAlignedShort(int index, short shortValue) {
        this.array[this.offset + index] = shortValue;
    }

    @Override
    public void setShort(short value) {
        this.array[this.offset] = value;
    }

    @Override
    public void setShort(int offset, short value) {
        if (offset % 2 == 0) {
            this.setAlignedShort(offset / 2, value);
        } else {
            super.setShort(offset, value);
        }
    }

    @Override
    public byte getByte(int offset) {
        return this.getByteViaShort(offset);
    }

    @Override
    public void setByte(int offset, byte value) {
        this.setByteViaShort(offset, value);
    }

    @Override
    public int toInt() {
        return this.offset * 2;
    }

    @Override
    public boolean isNull() {
        return this.array == null && this.offset != 0;
    }

    public short unwrap() {
        return this.array[this.offset];
    }

    public String toString() {
        return this.offset + "+" + Arrays.toString(this.array);
    }

    public static void memset(short[] array2, int offset, int value, int length2) {
        throw new UnsupportedOperationException("TODO");
    }

    public static short memset(int byteValue) {
        throw new UnsupportedOperationException("TODO");
    }

    public static ShortPtr cast(Object voidPointer) {
        if (voidPointer instanceof MallocThunk) {
            return ((MallocThunk)voidPointer).shortPtr();
        }
        if (voidPointer == null) {
            return NULL;
        }
        return (ShortPtr)voidPointer;
    }
}

