/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.runtime;

import java.util.Arrays;
import org.renjin.gcc.runtime.AbstractPtr;
import org.renjin.gcc.runtime.MallocThunk;
import org.renjin.gcc.runtime.OffsetPtr;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.gcc.runtime.Realloc;

public class LongPtr
extends AbstractPtr {
    public static final int BYTES = 8;
    public static final LongPtr NULL = new LongPtr();
    public final long[] array;
    public final int offset;

    private LongPtr() {
        this.array = null;
        this.offset = 0;
    }

    public LongPtr(long[] array2, int offset) {
        this.array = array2;
        this.offset = offset;
    }

    public LongPtr(long ... array2) {
        this.array = array2;
        this.offset = 0;
    }

    public static LongPtr malloc(int bytes) {
        return new LongPtr(new long[LongPtr.mallocSize(bytes, 8)]);
    }

    public long[] getArray() {
        return this.array;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getOffsetInBytes() {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public LongPtr realloc(int newSizeInBytes) {
        return new LongPtr(Realloc.realloc(this.array, this.offset, newSizeInBytes / 8));
    }

    @Override
    public Ptr pointerPlus(int bytes) {
        if (bytes == 0) {
            return this;
        }
        if (bytes % 8 == 0) {
            return new LongPtr(this.array, this.offset + bytes / 8);
        }
        return new OffsetPtr(this, this.offset * 8 + bytes);
    }

    @Override
    public long getLong() {
        return this.array[this.offset];
    }

    @Override
    public long getAlignedLong(int index) {
        return this.array[this.offset + index];
    }

    @Override
    public long getLong(int offset) {
        if (offset % 8 == 0) {
            return this.array[this.offset + offset / 8];
        }
        return super.getLong(offset);
    }

    @Override
    public void setAlignedLong(int index, long value) {
        this.array[this.offset + index] = value;
    }

    @Override
    public void setLong(int offset, long longValue) {
        if (offset % 8 == 0) {
            this.array[this.offset + offset / 8] = longValue;
        } else {
            super.setLong(offset, longValue);
        }
    }

    @Override
    public double getDouble() {
        return Double.longBitsToDouble(this.array[this.offset]);
    }

    @Override
    public double getAlignedDouble(int index) {
        return Double.longBitsToDouble(this.array[this.offset + index]);
    }

    @Override
    public byte getByte(int offset) {
        return this.getByteViaLong(offset);
    }

    @Override
    public void setByte(int offset, byte value) {
        this.setByteViaLong(offset, value);
    }

    @Override
    public int toInt() {
        return this.offset * 8;
    }

    @Override
    public boolean isNull() {
        return this.array == null && this.offset == 0;
    }

    public long unwrap() {
        return this.array[this.offset];
    }

    public String toString() {
        return this.offset + "+" + Arrays.toString(this.array);
    }

    public static int memcmp(LongPtr x, LongPtr y, int n) {
        return LongPtr.memcmp(x.array, x.offset, y.array, y.offset, n);
    }

    public static int memcmp(long[] x, int xi, long[] y, int yi, int n) {
        while (n > 0) {
            long vx = x[xi];
            long vy = y[yi];
            if (vx != vy || n < 8) {
                return LongPtr.memcmp(vx, vy, n);
            }
            ++xi;
            ++yi;
            n -= 8;
        }
        return 0;
    }

    public static int memcmp(long x, long y, int n) {
        for (int i = 0; i < n; ++i) {
            int xb = (int)(x & 0xFFL);
            int yb = (int)(y & 0xFFL);
            if (xb < yb) {
                return -1;
            }
            if (xb > yb) {
                return 1;
            }
            x >>= 8;
            y >>= 8;
        }
        return 0;
    }

    public static void memset(double[] str, int strOffset, int c2, int n) {
        assert (n % 64 == 0);
        Arrays.fill(str, strOffset, strOffset + c2 / 64, (double)LongPtr.memset(c2));
    }

    public static long memset(int c2) {
        return ((long)c2 & 0xFFL) << 56 | ((long)c2 & 0xFFL) << 48 | ((long)c2 & 0xFFL) << 40 | ((long)c2 & 0xFFL) << 32 | ((long)c2 & 0xFFL) << 24 | ((long)c2 & 0xFFL) << 16 | ((long)c2 & 0xFFL) << 8 | (long)c2 & 0xFFL;
    }

    public static LongPtr cast(Object voidPointer) {
        if (voidPointer instanceof MallocThunk) {
            return ((MallocThunk)voidPointer).longPtr();
        }
        if (voidPointer == null) {
            return NULL;
        }
        return (LongPtr)voidPointer;
    }

    public static void memcpy(LongPtr x, LongPtr y, int numBytes) {
        int offsetS;
        long[] arrayS = y.getArray();
        int restY = arrayS.length - (offsetS = y.getOffset());
        if (restY > 0) {
            long[] carray = new long[numBytes];
            int i = 0;
            for (int j = offsetS; j < arrayS.length && i < numBytes; ++j, ++i) {
                carray[i] = arrayS[j];
            }
            x = new LongPtr(carray);
        }
    }

    public static double unsignedInt64ToReal64(long i) {
        if (i >= 0L) {
            return i;
        }
        int upper = (int)(i >>> 32);
        int lower = (int)i;
        long lowerLong = (long)lower & 0xFFFFFFFFL;
        long upperLong = (long)upper & 0xFFFFFFFFL;
        return (double)lowerLong + (double)upperLong * 4.294967296E9;
    }

    @Deprecated
    public static long unsignedDivide(long dividend, long divisor) {
        return Long.divideUnsigned(dividend, divisor);
    }

    @Deprecated
    public static long unsignedRemainder(long dividend, long divisor) {
        return Long.remainderUnsigned(dividend, divisor);
    }

    @Deprecated
    public static int compareUnsigned(long a, long b) {
        return Long.compareUnsigned(a, b);
    }

    public static long unsignedMax(long a, long b) {
        if (Long.compareUnsigned(a, b) > 0) {
            return a;
        }
        return b;
    }

    public static long unsignedMin(long a, long b) {
        if (Long.compareUnsigned(a, b) < 0) {
            return a;
        }
        return b;
    }
}

