/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.runtime;

import java.util.Arrays;
import org.renjin.gcc.runtime.AbstractPtr;
import org.renjin.gcc.runtime.MallocThunk;
import org.renjin.gcc.runtime.OffsetPtr;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.gcc.runtime.Realloc;

public class CharPtr
extends AbstractPtr {
    public static final int BYTES = 2;
    public static final CharPtr NULL = new CharPtr();
    public final char[] array;
    public final int offset;

    private CharPtr() {
        this.array = null;
        this.offset = 0;
    }

    public CharPtr(char[] array2, int offset) {
        this.array = array2;
        this.offset = offset;
    }

    public CharPtr(char ... array2) {
        this.array = array2;
        this.offset = 0;
    }

    public char[] getArray() {
        return this.array;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getOffsetInBytes() {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public CharPtr realloc(int newSizeInBytes) {
        return new CharPtr(Realloc.realloc(this.array, this.offset, newSizeInBytes / 2));
    }

    @Override
    public Ptr pointerPlus(int bytes) {
        if (bytes % 2 == 0) {
            return new CharPtr(this.array, this.offset + bytes / 2);
        }
        return new OffsetPtr(this, bytes);
    }

    @Override
    public char getChar() {
        return this.array[this.offset];
    }

    @Override
    public void setAlignedChar(int index, char value) {
        this.array[this.offset + index] = value;
    }

    @Override
    public char getChar(int offset) {
        if (offset % 2 == 0) {
            return this.array[this.offset + offset / 2];
        }
        return super.getChar(offset);
    }

    @Override
    public void setChar(char value) {
        this.array[this.offset] = value;
    }

    @Override
    public void setChar(int offset, char value) {
        if (offset % 2 == 0) {
            this.array[this.offset + offset / 2] = value;
        } else {
            super.setChar(offset, value);
        }
    }

    @Override
    public char getAlignedChar(int index) {
        return this.array[this.offset + index];
    }

    @Override
    public byte getByte(int byteIndex) {
        return this.getByteViaChar(byteIndex);
    }

    @Override
    public void setByte(int offset, byte value) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public int toInt() {
        return this.offset * 2;
    }

    @Override
    public boolean isNull() {
        return this.array == null && this.offset == 0;
    }

    public static CharPtr fromString(String string) {
        int nchars = string.length();
        char[] array2 = new char[nchars + 1];
        System.arraycopy(string.toCharArray(), 0, array2, 0, nchars);
        return new CharPtr(array2);
    }

    public String toString() {
        return this.offset + "+" + Arrays.toString(this.array);
    }

    public String asString() {
        int length2;
        for (length2 = this.offset; length2 < this.array.length && this.array[length2] != '\u0000'; ++length2) {
        }
        return new String(this.array, this.offset, length2 - this.offset);
    }

    public static CharPtr cast(Object voidPointer) {
        if (voidPointer instanceof MallocThunk) {
            return ((MallocThunk)voidPointer).charPtr();
        }
        if (voidPointer == null) {
            return NULL;
        }
        return (CharPtr)voidPointer;
    }

    public static void memset(char[] array2, int offset, int value, int length2) {
        throw new UnsupportedOperationException("TODO");
    }

    public static char memset(int byteValue) {
        throw new UnsupportedOperationException("TODO");
    }

    public static void memcpy(CharPtr x, CharPtr y, int numBytes) {
        int offsetS;
        char[] arrayS = y.getArray();
        int restY = arrayS.length - (offsetS = y.getOffset());
        if (restY > 0) {
            char[] carray = new char[numBytes];
            int i = 0;
            for (int j = offsetS; j < arrayS.length && i < numBytes; ++j, ++i) {
                carray[i] = arrayS[j];
            }
            x = new CharPtr(carray);
        }
    }
}

